/*
 * @(#)ClickUpdator.java            2004. 12. 2.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.tracking.auto.updator;

import java.util.List;

import lombok.extern.slf4j.Slf4j;
import pluto.common.log.TargetSecondCheckSwitchUpdator;
import pluto.config.SqlManager;

/**
 * 자동 메일 클릭 정보 업데이트를 수행한다.<br>
 * 기본 로직은 pluto.common.log.TargetSecondCheckSwitchUpdator에 <br>
 * 선언되어 있고 이것을 상속받아 여기서는 쿼리를 받아오는 로직만을 <br>
 * 추가해 놓았다.
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class ClickUpdator extends TargetSecondCheckSwitchUpdator {
	
	
	protected static String _QUERY_FIRST_CHECK = null;
	protected static String _QUERY_SECOND_CHECK = null;
	
	protected static List _QUERY_UPDATE_FIRST_OK_COMMON_INFO = null;
	protected static List _QUERY_INSERT_FIRST_OK_LIST_INFO = null;

	protected static List _QUERY_UPDATE_SECOND_OK_COMMON_INFO = null;
	protected static List _QUERY_UPDATE_SECOND_OK_LIST_INFO = null;
	
	protected static List _QUERY_UPDATE_FINAL_COMMON_INFO = null;
	protected static List _QUERY_UPDATE_FINAL_LIST_INFO = null;
	
	//TMS 추가 
	protected static String _UPDATE_CLICK_LIST = null;
	protected static String _INSERT_CLICK_LIST = null;
	protected static String _INSERT_CLICK_OPTIMIZ = null;
	
	static {
		log.info("[ init ] ClickUpdator Query initialize .... ");
		try {
			_QUERY_FIRST_CHECK = SqlManager.getQuery("JUPITER_CLICK", "QUERY_FIRST_CHECK");
			_QUERY_SECOND_CHECK = SqlManager.getQuery("JUPITER_CLICK", "QUERY_SECOND_CHECK");
			
			_QUERY_UPDATE_FIRST_OK_COMMON_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_FIRST_OK_COMMON_INFO");
			_QUERY_INSERT_FIRST_OK_LIST_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_INSERT_FIRST_OK_LIST_INFO");

			_QUERY_UPDATE_SECOND_OK_COMMON_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_SECOND_OK_COMMON_INFO");
			_QUERY_UPDATE_SECOND_OK_LIST_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_SECOND_OK_LIST_INFO");
			
			_QUERY_UPDATE_FINAL_COMMON_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_FINAL_COMMON_INFO");
			_QUERY_UPDATE_FINAL_LIST_INFO = SqlManager.getMultiQuery("JUPITER_CLICK", "QUERY_UPDATE_FINAL_LIST_INFO");
		
			_UPDATE_CLICK_LIST = SqlManager.getQuery("JUPITER_CLICK", "UPDATE_CLICK_LIST");
			_INSERT_CLICK_LIST =  SqlManager.getQuery("JUPITER_CLICK", "INSERT_CLICK_LIST");
			_INSERT_CLICK_OPTIMIZ =  SqlManager.getQuery("WINDFORCE_CLICK", "INSERT_CLICK_OPTIMIZ");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
		log.info("[ init ] ClickUpdator Query initialize .... [OK]");
	}
	
	
	
	/** Creates a new instance of ClickUpdator */
	public ClickUpdator() {
		super();
		this.QUERY_FIRST_CHECK = _QUERY_FIRST_CHECK;
		this.QUERY_SECOND_CHECK = _QUERY_SECOND_CHECK;
		
		this.QUERY_UPDATE_FIRST_OK_COMMON_INFO = _QUERY_UPDATE_FIRST_OK_COMMON_INFO;
		this.QUERY_INSERT_FIRST_OK_LIST_INFO = _QUERY_INSERT_FIRST_OK_LIST_INFO;
		
		this.QUERY_UPDATE_SECOND_OK_COMMON_INFO = _QUERY_UPDATE_SECOND_OK_COMMON_INFO;
		this.QUERY_UPDATE_SECOND_OK_LIST_INFO = _QUERY_UPDATE_SECOND_OK_LIST_INFO;
		
		this.QUERY_UPDATE_FINAL_COMMON_INFO = _QUERY_UPDATE_FINAL_COMMON_INFO;
		this.QUERY_UPDATE_FINAL_LIST_INFO = _QUERY_UPDATE_FINAL_LIST_INFO;
		
		this.UPDATE_CLICK_LIST = _UPDATE_CLICK_LIST;
		this.INSERT_CLICK_LIST = _INSERT_CLICK_LIST;
		this.INSERT_CLICK_OPTIMIZ = _INSERT_CLICK_OPTIMIZ;
		
		if(log.isDebugEnabled()){
			// foo
		}

	}
}
