/*
 * @(#)ResearchTestLogUpdator.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.research.updator;

import lombok.extern.slf4j.Slf4j;
import mars.research.parser.ResearchLogParser;
import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;

/**
 * 시험발송 설문 응답 결과를 DB에 업데이트 하는 로직을 정의한다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class ResearchTestLogUpdator extends LogUpdatorImpl  {
	
	
	private static String QUERY_UPDATE_TEST_Q_PART = null;
	
	static {
		QUERY_UPDATE_TEST_Q_PART = SqlManager.getQuery( "RESEARCH" , "QUERY_UPDATE_TEST_Q_PART" );
	}
	
	
	
	/** Creates a new instance of ResearchTestLogUpdator */
	public ResearchTestLogUpdator() {
	}
	
	/** 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object src) throws Exception {
		
		ResearchLogParser __RE_LOG_DATA__ = ( ResearchLogParser )src;
		
		int count = executeUpdate( 
				QUERY_UPDATE_TEST_Q_PART , __RE_LOG_DATA__ );
				
		if (log.isDebugEnabled())  
				log.debug( "UPDATE COUNT : " + String.valueOf( count ) );
				
		return String.valueOf( count );
	}
}

