/*
 * @(#)ResearchMainLogUpdator.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.research.updator;

import java.util.Iterator;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import mars.research.parser.ResearchLogParser;
import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;
import pluto.db.eMsResultSet;
import pluto.util.StringUtil;
import pluto.util.eMsStringTokenizer;
import pluto.util.convert.DelimConvertor;

/**
 * 설문 응답 결과를 DB에 업데이트 하는 로직을 정의한다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class ResearchMainLogUpdator extends LogUpdatorImpl  {
	
	private static String QUERY_DELETE_ANSWER_LIST = null;
	private static String QUERY_INSERT_ANSWER_LIST = null;
	private static String QUERY_UPDATE_SCHEDULE_Q_PART = null;
	private static String QUERY_UPDATE_LIST_TABLE_Q_PART = null;
	
	static {
		QUERY_DELETE_ANSWER_LIST = SqlManager.getQuery( "WINDFORCE_RESEARCH" , "QUERY_DELETE_ANSWER_LIST" );
		QUERY_INSERT_ANSWER_LIST = SqlManager.getQuery( "WINDFORCE_RESEARCH" , "QUERY_INSERT_ANSWER_LIST" );
		QUERY_UPDATE_SCHEDULE_Q_PART = SqlManager.getQuery( "WINDFORCE_RESEARCH" , "QUERY_UPDATE_SCHEDULE_Q_PART" );
		QUERY_UPDATE_LIST_TABLE_Q_PART = SqlManager.getQuery( "WINDFORCE_RESEARCH" , "QUERY_UPDATE_LIST_TABLE_Q_PART" );
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	protected eMsStringTokenizer __TOKEN = new eMsStringTokenizer();
	
	/** Creates a new instance of ResearchMainLogUpdater */
	public ResearchMainLogUpdator() {
	}
	
	/** 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object src) throws Exception {
		ResearchLogParser __RE_LOG_DATA__ = ( ResearchLogParser )src;
		
		eMsResultSet rs = null;
		
	
		try {
			// 61 테이블의 기존 설문을 삭제한다.
			// 삭제된 레코드가 있다면 이미 설문을 참여한거다...
			int delete_cnt = executeUpdate( QUERY_DELETE_ANSWER_LIST , __RE_LOG_DATA__ );
			
			int insertcount = 0;
			
			List __ANSWER_LIST__ = __RE_LOG_DATA__.getAnswerList();
			
			String __VAR_0 = null;
			String __VAR_1 = null;
			String __VAR_2 = null;
			
			for( Iterator iter = __ANSWER_LIST__.iterator(); iter.hasNext() ;  ) {
				String __ELM = iter.next().toString();
				__TOKEN.parse( __ELM , "|" );
				__VAR_0 = DelimConvertor.decode( __TOKEN.nextToken() );
				__VAR_1 = DelimConvertor.decode( __TOKEN.nextToken() );
				__VAR_2 = DelimConvertor.decode( __TOKEN.nextToken() );
				
				// Q_NO / Q_TYPE 이 없으면 건너뛰어야 한다.
				if( StringUtil.isNull( __VAR_0 ) || StringUtil.isNull( __VAR_1 ) ){
					continue;
				}
				
				__RE_LOG_DATA__.put( "Q_NO" , __VAR_1 );
				__RE_LOG_DATA__.put( "Q_TYPE" , __VAR_0 );
				
				if( __VAR_0.equals("1") || __VAR_0.equals("2") ) {
					if( __VAR_2.length() > 1024 ) {
						__RE_LOG_DATA__.put( "ANSWER_A" , __VAR_2.substring(0,1024) );
					}
					else {
						__RE_LOG_DATA__.put( "ANSWER_A" , __VAR_2 );
					}
					
					__RE_LOG_DATA__.put( "ANSWER_A_CNT" , "1" );
					__RE_LOG_DATA__.put( "ANSWER_B_CNT" , "0" );
					__RE_LOG_DATA__.put( "ANSWER_B" , "ZZZZZ" );
				}
				else {
					__RE_LOG_DATA__.put( "ANSWER_A" , "" );
					__RE_LOG_DATA__.put( "ANSWER_A_CNT" , "0" );
					__RE_LOG_DATA__.put( "ANSWER_B_CNT" , "1" );
					__RE_LOG_DATA__.put( "ANSWER_B" , __VAR_2 );
				}
				
				// 61번 테이블에 인서트를 한다.
				executeUpdate( QUERY_INSERT_ANSWER_LIST , __RE_LOG_DATA__  );
				insertcount++;
			}
			
			/**삭제 레코드가 없고 삽입 카운트가 있다면 설문참여한 사람 수이기 때문에 설문 응답수를 증가시킨다.
			 */
			if( delete_cnt == 0 && insertcount > 0 ){
				// 20테이블의 참여를 업데이트 한다.
				executeUpdate( QUERY_UPDATE_SCHEDULE_Q_PART , __RE_LOG_DATA__ );
				executeUpdate( QUERY_UPDATE_LIST_TABLE_Q_PART , __RE_LOG_DATA__ );
			}
		}
		catch( Exception e) {
			log.error(getName(), e );
			return "ERROR";
		}
		finally {
			try{
				if(rs != null) rs.close();	
				
				}catch(Exception e){
					log.error("Exception", e);
				}
		}
		
		return "SUCCESS";
	}
}
