/*
 * @(#)ResearchMainLogUpdator.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.research.updator;

import java.util.Iterator;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import mars.research.parser.AutoResearchLogParser;
import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;
import pluto.db.eMsResultSet;
import pluto.util.eMsStringTokenizer;
import pluto.util.convert.DelimConvertor;

/**
 * 설문 응답 결과를 DB에 업데이트 하는 로직을 정의한다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class AutoResearchMainLogUpdator extends LogUpdatorImpl  {
	
	private static String QUERY_DELETE_ANSWER_LIST = null;
	private static String QUERY_INSERT_ANSWER_LIST = null;
	private static String QUERY_SELECT_FIRST_CHECK = null;
	private static String QUERY_INSERT_SCHEDULE_Q_PART = null;
	private static String QUERY_UPDATE_SCHEDULE_Q_PART = null;
	
	static {
		QUERY_DELETE_ANSWER_LIST = SqlManager.getQuery( "WINDFORCE_AUTO_RESEARCH" , "QUERY_DELETE_ANSWER_LIST" );
		QUERY_INSERT_ANSWER_LIST = SqlManager.getQuery( "WINDFORCE_AUTO_RESEARCH" , "QUERY_INSERT_ANSWER_LIST" );
		
		QUERY_SELECT_FIRST_CHECK = SqlManager.getQuery( "WINDFORCE_AUTO_RESEARCH" , "QUERY_SELECT_FIRST_CHECK" );
		QUERY_INSERT_SCHEDULE_Q_PART  = SqlManager.getQuery( "WINDFORCE_AUTO_RESEARCH" , "QUERY_INSERT_SCHEDULE_Q_PART" );
		QUERY_UPDATE_SCHEDULE_Q_PART = SqlManager.getQuery( "WINDFORCE_AUTO_RESEARCH" , "QUERY_UPDATE_SCHEDULE_Q_PART" );
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	protected eMsStringTokenizer __TOKEN = new eMsStringTokenizer();
	
	/** Creates a new instance of ResearchMainLogUpdater */
	public AutoResearchMainLogUpdator() {
	}
	
	/** 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object src) throws Exception {
		AutoResearchLogParser __RE_LOG_DATA__ = ( AutoResearchLogParser )src;
		
		//TODO 이지수(2020.05.28) 
		// rs에 대한 정의 혹은 삭제가 필요합니다.
		
		//eMsResultSet rs = null;
		eMsResultSet first_check = null;
	
		try {
			// 61 테이블의 기존 설문을 삭제한다.
			// 삭제된 레코드가 있다면 이미 설문을 참여한거다...
			int delete_cnt = executeUpdate( QUERY_DELETE_ANSWER_LIST , __RE_LOG_DATA__ );
						
			int insertcount = 0;
			
			List __ANSWER_LIST__ = __RE_LOG_DATA__.getAnswerList();
			
			String __VAR_0 = null;
			String __VAR_1 = null;
			String __VAR_2 = null;
			
			for( Iterator iter = __ANSWER_LIST__.iterator(); iter.hasNext() ;  ) {
				String __ELM = iter.next().toString();
				__TOKEN.parse( __ELM , "|" );
				__VAR_0 = DelimConvertor.decode( __TOKEN.nextToken() );
				__VAR_1 = DelimConvertor.decode( __TOKEN.nextToken() );
				__VAR_2 = DelimConvertor.decode( __TOKEN.nextToken() );
				
				__RE_LOG_DATA__.put( "ANS01" , __VAR_0 );
				__RE_LOG_DATA__.put( "ANS02" , __VAR_1 );
				__RE_LOG_DATA__.put( "ANS03" , __VAR_2 );
			
				// 61번 테이블에 인서트를 한다.
				executeUpdate( QUERY_INSERT_ANSWER_LIST , __RE_LOG_DATA__  );
				insertcount++;
			}
			
			/**삭제 레코드가 없고 삽입 카운트가 있다면 설문참여한 사람 수이기 때문에 설문 응답수를 증가시킨다.
			 */
			if( delete_cnt == 0 && insertcount > 0 ){
				// 20테이블의 참여를 업데이트 한다.
				// 최초면 INSERT, 최초가 아니면 update
				first_check = executeQuery(QUERY_SELECT_FIRST_CHECK, __RE_LOG_DATA__);
				if(first_check.next()) {
					executeUpdate( QUERY_UPDATE_SCHEDULE_Q_PART , __RE_LOG_DATA__ );
				} else {
					executeUpdate( QUERY_INSERT_SCHEDULE_Q_PART , __RE_LOG_DATA__ );
				}
			}
		}
		catch( Exception e) {
			log.error("update error", e );
			return "ERROR";
		}
		finally {
			/*
			try{
				if(rs != null) rs.close();							
			}catch(Exception e){
				log.error("Exception", e);
			}
			*/
			
			try {
				if(first_check != null) first_check.close();			
			}catch(Exception e) {
				log.error("Exception", e);
			}
		}
		
		return "SUCCESS";
	}
}
