/*
 * @(#)ResearchLogParser.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package mars.research.parser;

import java.util.Hashtable;
import java.util.List;

import pluto.log.LogParser;
import pluto.log.LogProcessor;
import pluto.util.PlutoLinkedList;
import pluto.util.StringUtil;
import pluto.util.eMsStringTokenizer;
import pluto.util.convert.TrackingInfoConvertor;
/**
 * Log 스트링을 파싱하여 hashtable에 담는 룰을 정의한다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
public class ResearchLogParser extends Hashtable implements LogParser {
	
	//Vector RESEARCH_VARIABLES = new Vector();
	List RESEARCH_VARIABLES = new PlutoLinkedList();
	
	
	
	/** Creates a new instance of ResearchLogParser */
	public ResearchLogParser() {
		super();
		super.put( LOG_TR_RESEARCH_VARIABLES , RESEARCH_VARIABLES );
	}
	
	public String getAsString( String key ){
		return (String)super.get( key );
	}

	public List getAnswerList(){
		return this.RESEARCH_VARIABLES;
	}
	
	/** 로그를 파싱해서 결과를 반환한다.<br>
	 * 결과는 다양한 타입을 지원하기 위하여 Object로 한다.
	 * @param src 로그 String
	 * @throws Exception 파싱하면서 에러나면
	 * @return 파싱결과
	 */
//	private List LOG_ELEMENTS = new PlutoLinkedList();
	private eMsStringTokenizer __TOKEN_MAIN = new eMsStringTokenizer();
	
	private eMsStringTokenizer __TOKEN_SUB = new eMsStringTokenizer();

	public synchronized Object parse(String src) throws Exception {
		
		if( src == null ) return null;

		RESEARCH_VARIABLES.clear();
		
		__TOKEN_MAIN.parse( src , "<DELIM>" );
		
		if( !__TOKEN_MAIN.hasMoreTokens() ) return "POOR INFO";
		
		__TOKEN_SUB.parse( __TOKEN_MAIN.nextToken() , "|" );
		
		super.put( LOG_TR_KIND , "RESEARCH" );
		super.put( LOG_MAIL_ID , StringUtil.trimNull( __TOKEN_SUB.nextToken() ) );
		super.put( LOG_MEMBER_ID ,  getDecode( StringUtil.trimNull( __TOKEN_SUB.nextToken() ) ) );
		super.put( LOG_TOKEN_ID ,  StringUtil.trimNull( __TOKEN_SUB.nextToken() ) );
		super.put( LOG_T_DATE ,  StringUtil.trimNull( __TOKEN_SUB.nextToken() ) );
		super.put( LOG_TR_CLOSE ,  StringUtil.trimNull( __TOKEN_SUB.nextToken() ) );
		
		String SEND_TYPE = StringUtil.trimNull( __TOKEN_SUB.nextToken() );
		String SEND_STATE = StringUtil.trimNull( __TOKEN_SUB.nextToken() );
		
		super.put( LOG_SEND_TYPE ,  SEND_STATE.equalsIgnoreCase( "TEST")?"MTEST":SEND_TYPE );
		super.put( LOG_LIST_TABLE ,  StringUtil.trimNull( __TOKEN_SUB.nextToken() ) );
		String CLOSE_DATE = super.get( LOG_TR_CLOSE).toString();
		String TDATE = (String)super.get( LOG_T_DATE );
		try{
			if( Integer.parseInt( TDATE.substring( 0 , 8 ) ) > Integer.parseInt( CLOSE_DATE ) ){
				return "OUT OF DATE";
			}
		}
		catch( Exception e ){
		}
		
		while( __TOKEN_MAIN.hasMoreTokens() ) {
			RESEARCH_VARIABLES.add( __TOKEN_MAIN.nextToken() );
		}
		
		return this;
	}
	
	private String getDecode(String value) {
		if( value == null ) return "";
		
		String returnValue = null;
		
		try {
			String StartValue = TrackingInfoConvertor.decode(value);
			if( StartValue.indexOf( "=" ) > 0 ) returnValue = StartValue.substring( StartValue.indexOf( "=" ) + 1 );
		}
		catch( Exception e ) {
		}
		
		return returnValue==null?"":returnValue;
	}
	
	/** 포그를 파싱하면서 추가로 작업을 해야할 LogProcessor를 지정한다.
	 */
	public void setExternalLogProcessor(LogProcessor tmp) throws Exception {
		// 할게 없다.
	}
	
	/** 파싱룰을 정의한다.
	 * @param tmp 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	public void setParsingRules(Object tmp) throws Exception {
		// 할게 없다.
	}
	
}
