/*
 * Created on 2005. 4. 11.
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package mars.monitor.parser;

import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

import kr.co.amail.LiveEMS.Common.DataUtil;
import kr.co.amail.LiveEMS.Data.Bean.MonitorInfoBean;
import kr.co.amail.LiveEMS.Monitor.MonitorInfoWriter;
import lombok.extern.slf4j.Slf4j;
import pluto.log.LogParser;
import pluto.log.LogProcessor;

/**
 * @author L2club
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
@Slf4j
public class MonitorLogParser extends Properties implements LogParser {

	private static boolean			OUT_DEBUG			= true;

	public static String			MONITOR_INFO_DIR	= "";

	public static String			MONITOR_HTML		= "LiveEMSCatcher.html?";

	public static String			LOWER_MONITOR_HTML	= "";

	/** IP 뒷부분 * */
	public static final String		IP_END				= " -";

	/** Date 내용을 감싸는 괄호의 앞 부분 */
	public static final String		DATE_START			= "[";

	/** Date 내용을 감싸는 괄호의 뒷 부분 */
	public static final String		DATE_END			= "]";

	/** Date 내용을 감싸는 괄호의 중간 부분 (?) */
	public static final String		DATE_MIDDLE			= " ";

	/** Monitor Key * */

	private static Hashtable		__MONTH_MAP__;

	static {
		__MONTH_MAP__ = new Hashtable();
		__MONTH_MAP__.put("jan", "01");
		__MONTH_MAP__.put("feb", "02");
		__MONTH_MAP__.put("mar", "03");
		__MONTH_MAP__.put("apr", "04");
		__MONTH_MAP__.put("may", "05");
		__MONTH_MAP__.put("jun", "06");
		__MONTH_MAP__.put("jul", "07");
		__MONTH_MAP__.put("aug", "08");
		__MONTH_MAP__.put("sep", "09");
		__MONTH_MAP__.put("oct", "10");
		__MONTH_MAP__.put("nov", "11");
		__MONTH_MAP__.put("dec", "12");
	}

	protected StringBuffer			__TMP_BUFFER		= new StringBuffer(128);

	/*
	 * (non-Javadoc)
	 * 
	 * @see pluto.log.LogParser#setParsingRules(java.lang.Object)
	 */
	public void setParsingRules(Object tmp) throws Exception {

		Properties prop = (Properties) tmp;
		MONITOR_HTML = prop.getProperty("script.index", MONITOR_HTML);
		OUT_DEBUG = prop.getProperty("check.debug", "false").equals("true");
		MONITOR_INFO_DIR = prop.getProperty("monitor.info.path", ".");
		// MonitorInfoWriter를 세팅해줌
		MonitorInfoWriter.setMonitorInfoPath(MONITOR_INFO_DIR);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pluto.log.LogParser#setExternalLogProcessor(pluto.log.LogProcessor)
	 */
	public void setExternalLogProcessor(LogProcessor tmp) throws Exception {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pluto.log.LogParser#parse(java.lang.String)
	 */
	public Object parse(String src) throws Exception {

		this.clear();

		String tmpStr = null;

		int idx1 = 0;
		int idx2 = 0;
		int idx3 = 0;

		// get ip
		idx1 = src.indexOf(IP_END);

		if( idx1 < 0 ) {
			if( OUT_DEBUG )
				log.debug("no ip end");
			return null;
		}

		tmpStr = src.substring(0, idx1 - 1);
		if( tmpStr.length() < 7 || tmpStr.length() > 15 ) {
			if( OUT_DEBUG )
				log.debug("no ip address");
			return null;
		}
		setProperty(LOG_IP, tmpStr);

		idx1 = src.indexOf(DATE_START);

		if( idx1 < 0 ) {
			if( OUT_DEBUG )
				log.debug("no date start");
			return null;
		}

		idx2 = src.indexOf(DATE_END);

		if( idx2 < 0 ) {
			if( OUT_DEBUG )
				log.debug("no date end");
			return null;
		}

		idx3 = src.indexOf(DATE_MIDDLE, idx1);

		if( idx3 < 0 ) {
			if( OUT_DEBUG )
				log.debug("no date middle");
			return null;
		}

		if( idx3 > idx2 ) {
			if( OUT_DEBUG )
				log.debug("date start and end sequence");
			return null;
		}

		// 시간 파싱
		parse_date(src.substring(idx1 + DATE_START.length(), idx3));

		idx1 = src.indexOf(MONITOR_HTML);

		if( idx1 < 0 ) {
			idx1 = src.toLowerCase().indexOf(MONITOR_HTML.toLowerCase());
			if( OUT_DEBUG )
				log.debug("no script index");
			if( idx1 < 0 )
				return null;
		}

		// 각 MonitorInfo 데이터
		idx1 = idx1 + MONITOR_HTML.length();
		idx2 = src.indexOf(" HTTP", idx1);

		tmpStr = src.substring(idx1, idx2);

		if( !parse_monitorInfo(tmpStr) )
			return null;

		return this;
	}

	private boolean parse_date(String src) {

		try {
			String year = null;
			String month = null;
			String day = null;
			String time = null;
			int idx1 = src.indexOf("/");
			day = src.substring(0, idx1);
			int idx2 = src.indexOf("/", idx1 + 1);
			month = (String) __MONTH_MAP__.get(src.substring(idx1 + 1, idx2).toLowerCase());
			idx1 = idx2 + 1;
			idx2 = src.indexOf(":", idx1);
			year = src.substring(idx1, idx2);
			time = src.substring(idx2 + 1);
			__TMP_BUFFER.setLength(0);
			setProperty(LOG_TR_LOG_DATE, __TMP_BUFFER.append(year).append(month).append(day).toString());
			__TMP_BUFFER.setLength(0);
			setProperty(LOG_T_DATE, __TMP_BUFFER.append(year).append("-").append(month).append("-").append(day).append(" ").append(time).toString());

		}
		catch(Exception e) {
			if( OUT_DEBUG )
				log.debug("date parsing error", e);
			return false;
		}
		return true;
	}

	public boolean parse_monitorInfo(String rowData) {

		String sTmp = "";
		int nIdx = 0;
		MonitorInfoBean bean;
		String sCustCode = "";
		String sProjCode = "";
		String sDevSeq = "";
		String sDemnSeq = "";
		StringTokenizer token;

		try {

			/*
			 * MonitorID 부터 추출 CUST_CODE : 13 PROJ_CODE : 3 DEV_SEQ : 2 DEMN_SEQ :
			 * 2
			 */

			nIdx = rowData.indexOf("|");
			sTmp = rowData.substring(0, nIdx);
			if( sTmp.length() != 20 ) {
				return false;
			}

			bean = (MonitorInfoBean) DataUtil.ConvertCSVToBean(null, rowData + "|" + this.getProperty(LOG_T_DATE), "|");

			if( bean == null ) {
				return false;
			}

			sCustCode = rowData.substring(0, 13);
			sProjCode = rowData.substring(13, 16);
			sDevSeq = rowData.substring(16, 18);
			sDemnSeq = rowData.substring(18, 20);

			sTmp = sCustCode + "|" + sProjCode + "|" + sDevSeq + "|" + sDemnSeq;

			sTmp = sTmp + rowData.substring(20);

			this.setProperty("CUST_CODE", sCustCode);
			this.setProperty("PROJ_CODE", sProjCode);
			this.setProperty("DEV_SEQ", sDevSeq);
			this.setProperty("DEMN_SEQ", sDemnSeq);
			this.setProperty("MNTR_TYPE", "00");
			this.setProperty("DEMN_TYPE", bean.getDemonType());
			this.setProperty("SMTP_IP_ADDR", bean.getSMTPIPAddress());
			this.setProperty("ROOT_PATH", bean.getRootPath());
			this.setProperty("TRKG_URL", bean.getTrackingURL());
			this.setProperty("WORK_STATUS", "00");
			this.setProperty("DEMN_START_TIME", bean.getDemonStartTime());
			this.setProperty("DEMN_STATUS", bean.getDemonStatus());
			this.setProperty("CNT_PUSH", String.valueOf(bean.getCntPush()));
			this.setProperty("CNT_PUSH_FAIL", String.valueOf(bean.getCntPushFail()));
			this.setProperty("CNT_UPT", String.valueOf(bean.getCntUpdate()));
			this.setProperty("CNT_UPT_FAIL", String.valueOf(bean.getCntUpdateFail()));
			this.setProperty("CNT_UPT_OPEN", String.valueOf(bean.getCntUpdateOpen()));
			this.setProperty("CNT_UPT_CLICK", String.valueOf(bean.getCntUpdateClick()));
			this.setProperty("CNT_UPT_RCH", String.valueOf(bean.getCntUpdateResearch()));
			this.setProperty("CNT_DB_ERR", String.valueOf(bean.getCntDBConError()));

			this.setProperty("DISK_TOTAL", bean.getSIDiskTotal());
			this.setProperty("DISK_USED", bean.getSIDiskUsed());
			this.setProperty("MEM_TOTAL", bean.getSIMemoryTotal());
			this.setProperty("MEM_USED", bean.getSIMemoryUsed());
			this.setProperty("CPU_USED", bean.getSICPUUsed());
			this.setProperty("NET_RECV", bean.getSINetworkReceived());
			this.setProperty("NET_SEND", bean.getSINetworkSent());
			this.setProperty("IP_ADDR", bean.getSIIPAddress());
			this.setProperty("LOG_IP_ADDR", "");
			this.setProperty("LOG_TIME", this.getProperty(LOG_T_DATE));

			// Domain
			String sDomainList = bean.getDomainList();
			String sDomainCntPushList = bean.getDomainCntList();
			String sDomainCntFailList = bean.getDomainCntFailList();

			for (int i = 0; i < 10; i++) {
				this.setProperty("DOMAIN_".concat(String.valueOf(i)), "");
				this.setProperty("DOMAIN_".concat(String.valueOf(i)).concat("_PUSH"), "0");
				this.setProperty("DOMAIN_".concat(String.valueOf(i)).concat("_FAIL"), "0");
			}

			if( !sDomainList.equals("") && !sDomainList.equals("_") ) {

				token = new StringTokenizer(sDomainList, ",");
				int i = 0;
				while (token.hasMoreTokens()) {
					this.setProperty("DOMAIN_".concat(String.valueOf(i)), token.nextToken().trim());
					i++;
				}
				token = null;
				token = new StringTokenizer(sDomainCntPushList, ",");
				i = 0;
				while (token.hasMoreTokens()) {
					this.setProperty("DOMAIN_".concat(String.valueOf(i)).concat("_PUSH"), token.nextToken());
					i++;
				}
				token = null;
				token = new StringTokenizer(sDomainCntFailList, ",");
				i = 0;
				while (token.hasMoreTokens()) {
					this.setProperty("DOMAIN_".concat(String.valueOf(i)).concat("_FAIL"), token.nextToken());
					i++;
				}
			}

		}
		catch(Exception e) {
			if( OUT_DEBUG )
				log.debug("monitorInfo parsing error", e);
			return false;
		}

		/*
		 * MonitorInfoWriter 를 이용하여 파일데이터를 만든다.
		 */
		MonitorInfoWriter.setMonitorInfo(rowData + "|" + this.getProperty(LOG_T_DATE));

		return true;
	}

	public static void main(String[] args) {
	}
}
