/*
 * @(#)HttpReporter.java            2004. 12. 18.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.reporter;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.reporter.Reporter;
import pluto.util.convert.URLConvertor;
/**
 * 특정 URL의 CGI를 호출하여 에러사항을 알린다.
 * 
 * @version		
 * @author 		lena
 *
 */
@Slf4j
public class HttpReporter extends Reporter {
	HttpURLConnection ht_conn = null;
	URL url = null;
	
	public static String name = "HttpReporter";
	/** 이름을 반환
	 * @return 이름
	 */
	public static String getName() {
		return name;
	}
	
	/** Creates new HttpReporter */
	public HttpReporter() {
		super();
	}
	
	/** 초기화 한다. 파라미터는 Properties로 받는다.<br>
	 * report.url : 리포트를 전송할 URL을 지정한다.
	 * @param prop 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	public void inner_init(Properties prop) throws Exception {
		String base_dir = prop.getProperty( "report.url" );
		if(  base_dir == null ) throw new RuntimeException( "var.. name : report.url parameter is not set ");
		this.url =  new URL( base_dir );
	}
	
	/** 지정된 URL로 메세지를 전송한다.
	 * @param POST_ID 메일 아아디
	 * @param Agent 실행 Instance 이름
	 * @param CODE 에러 코드
	 * @param message 메세지
	 * @return 성공여부
	 */
	public String push(String POST_ID, String Agent, String CODE, String message) {
		try {
			this.ht_conn = (HttpURLConnection)this.url.openConnection();
			
			this.ht_conn.setRequestMethod("POST");
			StringBuffer __TMP_STRING_BUFFER__ = new StringBuffer();
			
			__TMP_STRING_BUFFER__.append("post_id=");
			__TMP_STRING_BUFFER__.append(POST_ID);
			
			__TMP_STRING_BUFFER__.append("&");
			
			__TMP_STRING_BUFFER__.append("agent=");
			__TMP_STRING_BUFFER__.append(Agent);
			__TMP_STRING_BUFFER__.append("&");
			
			__TMP_STRING_BUFFER__.append("code=");
			__TMP_STRING_BUFFER__.append(CODE);
			__TMP_STRING_BUFFER__.append("&");
			
			__TMP_STRING_BUFFER__.append("message=");
			__TMP_STRING_BUFFER__.append(URLConvertor.encode( message ));
			
			String query_string = __TMP_STRING_BUFFER__.toString();
			
			__TMP_STRING_BUFFER__ = null;
			
			this.ht_conn.setRequestProperty("Content-length", "" + query_string.length());
			this.ht_conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
			this.ht_conn.setDoOutput(true);
			this.ht_conn.setDoInput(true);
			
			PrintWriter out = new PrintWriter(this.ht_conn.getOutputStream());
			out.print(query_string);
			out.flush();
			out.close();
			
			
			BufferedReader reader = new BufferedReader( new InputStreamReader( this.ht_conn.getInputStream() ) );
			
			String returnValue = null;
			
			if( reader.ready() ) {
				returnValue = reader.readLine();
			}
			else {
				returnValue = this.ht_conn.getResponseMessage();
			}
			
			try{ reader.close(); }catch( Exception e ){}
			
			this.ht_conn.disconnect();
			
			return returnValue;
		}
		catch( Exception e) {
			log.error( getName() , e );
			return "Error";
		}
		finally {
			try{ this.ht_conn.disconnect(); } catch( Exception e ){}
		}
	}
	
	public String push(Properties prop, String message) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
}
