/*
 * @(#)FileReporter.java            2004. 12. 18.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.reporter;

import java.util.Properties;

import pluto.io.eMsFileWriter;
import lombok.extern.slf4j.Slf4j;
import pluto.reporter.Reporter;
import pluto.util.Cal;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class FileReporter extends Reporter {
	
	public static String name = "FileReporter";
	/** 이름을 반환
	 * @return 이름
	 */
	public static String getName() {
		return name;
	}
	
	String base_dir = null;
	
	/** Creates new FileReporter */
	public FileReporter() {
		super();
	}
	
	/** 초기화 한다. 파라미터는 Properties로 받는다.<br>
	 * report.url : 리포트 파일을 작성할 기본 디렉토리를 지정
	 * @param prop 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	public void inner_init(Properties prop) throws Exception {
		this.base_dir = prop.getProperty( "report.url" );
		if( this.base_dir == null ) throw new RuntimeException( "var.. name : report.url  parameter is not set ");
	}
	
	public String push(String POST_ID, String Agent, String CODE, String message) {
		try {
			eMsFileWriter writer = new eMsFileWriter( this.base_dir + "/" + POST_ID + ".report" , true );
			
			writer.println("####################################################################");
			writer.println( "DATE: " + Cal.getDate() );
			writer.write( "Agent  : " );
			writer.println( Agent );
			writer.println();
			
			writer.write( "CODE  : " );
			writer.println( CODE );
			writer.println();
			
			writer.write( "MESSAGE  : " );
			writer.println( message );
			writer.println();
			writer.println();
			writer.println();
			
			writer.flush();
			writer.close();
			
			return "Success";
		}
		catch( Exception e) {
			log.error( getName() , e );
			return "Error";
		}
		finally {
		}
	}
	
	public String push(Properties prop, String message) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
}
