/*
 * @(#)EmailReporter.java            2004. 12. 18.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.reporter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

import jupiter.common.communicator.StandAloneSmtpCommunicator;
import pluto.config.eMsSystem;
import pluto.io.eMsFileWriter;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsStringBuffer;
import pluto.reporter.Reporter;
import pluto.util.Cal;
import pluto.util.StringUtil;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class EmailReporter extends Reporter {
	StandAloneSmtpCommunicator sender = null;
	List emails = null;
	String return_path = null;
	String header = null;
	String store_base = null;
	
	/** Creates new EmailReporter */
	public EmailReporter() throws Exception {
	}
	
	public void inner_init(Properties prop) throws Exception {
		String email = prop.getProperty( "send.email" );
		if( email == null ) throw new RuntimeException( "var.. name : [send.email]  parameter is not set ");
		
		this.return_path = prop.getProperty( "return.path" );
		if( this.return_path == null ) throw new RuntimeException( "var.. name : [return.path]  parameter is not set ");
		
		this.emails = StringUtil.toStringList( email , "," , new LinkedList() );
		
		this.header = eMsSystem.getProperty("error.mail.header");
		if( this.header == null ) throw new RuntimeException( "var.. name : [header.file]  parameter is not set ");
		
		this.store_base = prop.getProperty( "store.url" );
		if( this.store_base == null ) throw new RuntimeException( "var.. name : [store.url]  parameter is not set ");
		
		this.sender = new StandAloneSmtpCommunicator("Reporter");
	}
	
	public String push(String POST_ID, String Agent, String CODE, String message) {
		return push( this.emails , POST_ID , Agent , CODE , message );
	}
	protected String push( List target_email , String POST_ID, String Agent, String CODE, String message) {
		
		StringBuffer buffer = new StringBuffer(512);
		
		try {
			String body = null;

			buffer.setLength( 0 );
			buffer.append( this.header );
			buffer.append( "\r\n" );
				
			buffer.append("####################################################################");
			buffer.append( "\r\n" );
			buffer.append( "DATE: " );
			buffer.append(Cal.getDate() );
			buffer.append( "\r\n" );
				
			buffer.append( "POST_ID  : " );
			buffer.append( POST_ID );
			buffer.append( "\r\n" );
				
			buffer.append( "Agent  : " );
			buffer.append( Agent );
			buffer.append( "\r\n" );
				
			buffer.append( "CODE  : " );
			buffer.append( CODE );
			buffer.append( "\r\n" );
				
			buffer.append( "MESSAGE  : " );
			buffer.append( message );
			buffer.append( "\r\n" );
				
			body = buffer.toString();
			///////////////////////////////////////////////////////////

			
			String tmp_domain = "__";
			String target_domain = null;
			
			this.sender.setMailFrom(this.return_path);
			this.sender.setData( body );
			
			String report_result_message = "";
			
			for( Iterator iter = target_email.iterator() ; iter.hasNext() ; ) {
				String __EMAIL__ = iter.next().toString();
				
				target_domain = StringUtil.getDomain( __EMAIL__ );
				
				if( !target_domain.equals( tmp_domain ) ) {
					this.sender.setDomain( tmp_domain );
					
					Vector result = this.sender.execute();

					buffer.setLength( 0 );
					buffer.append( report_result_message );
						for( int j = 0 ; j < result.size() ; j++ ) {
							String[] pr = ( String[] )result.get( j );
							
							buffer.append( pr[0] );
							buffer.append(  "|" );
							buffer.append( pr[1] );
							buffer.append( "|" );
							buffer.append( pr[2] );
							buffer.append( "\r\n" );
						}
						
						report_result_message = buffer.toString();
					
					tmp_domain = target_domain;
				}
				
				this.sender.setRcptTo( __EMAIL__ );
			}
			
			this.sender.setDomain( tmp_domain );
			
			Vector result = this.sender.execute();
			
			buffer.setLength( 0 );
			buffer.append( report_result_message );
				for( int i = 0 ; i < result.size() ; i++ ) {
					String[] pr = ( String[] )result.get( i );
					
					buffer.append( pr[0] );
					buffer.append(  "|" );
					buffer.append( pr[1] );
					buffer.append( "|" );
					buffer.append( pr[2] );
					buffer.append( "\r\n" );
				}
				report_result_message = buffer.toString();
			
			try {
				eMsFileWriter fwriter = new eMsFileWriter( this.store_base + "/" + POST_ID + ".report" , true );
				fwriter.write( body );
				fwriter.flush();
				fwriter.close();
			}
			catch( Exception e ) {

					buffer.setLength( 0 );
					buffer.append( report_result_message );
					buffer.append(" file writer fail : " + e.toString() );
					
					report_result_message = buffer.toString();

			}
			
			return report_result_message;
		}
		catch( Exception e) {
			log.error( "eMailReporter" , e );
			return "Error";
		}
		finally {
		}
	}
	
	public String push(Properties prop, String message) {
		throw new RuntimeException( "NOT IMPLEMENTS" );
	}
	
}

