package jupiter.mass.send.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.constrants.CommonColumn;

import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.CommonStepMailSendTask;
import jupiter.mass.send.basic.SendStopException;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.log.ErrorSpoolLogger;
import pluto.panopticon.filter.RejectFilter;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.convert.StringConvert;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;
import venus.spool.common.task.SpoolControlTask;

@Slf4j
public class SmsPersonalResendTask extends CommonStepMailSendTask {
	
	// Use Encrypt
	private static final String ENC_YN = eMsSystem.getProperty("member.info.encrypt.yn","N");
	private static final String ENC_KEY = eMsSystem.getProperty("member.info.encrypt.key","");
	
	/*
	 * Query 
	 */
	private static String QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = null;
	private static String QUERY_UPDATE_LIST_STATE_QUERY = null;
	private static String QUERY_SELECT_LIST_LOAD_QUERY = null;
	private static String QUERY_SELECT_RESEND_TABLE_INFO = null;
	private static String instance_QUERY_TARGET_TABLE_INFO = null;
	private static String QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO = null;
	private static String QUERY_CHECK_SMS_TYPE = null;
	
	/*
	 * 복수 개의 스풀 정보를 저장
	 */ 
	public ArrayList SPOOLINFO_LIST = new ArrayList();
	
	private Properties PROP = null;
	
	static {
		try {
			QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_PERSONAL_RESEND_WORK_INFO" );
			QUERY_UPDATE_LIST_STATE_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_LIST_STATE_QUERY" );
			QUERY_SELECT_LIST_LOAD_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_LIST_LOAD_QUERY" );
			QUERY_SELECT_RESEND_TABLE_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_RESEND_TABLE_INFO" );
			QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO" );
			QUERY_CHECK_SMS_TYPE    = SqlManager.getQuery("COMMON","QUERY_CHECK_SMS_TYPE");
		} catch(Exception e) {
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	
	public SmsPersonalResendTask() throws Exception {

		super(TYPE_INTERVAL, 1);
		this.setName("SmsPersonalResendTask");
		this.setTaskID("SmsPersonalResendTask");

		//setTaskProperty(null);

		if (log.isDebugEnabled()) {
			log.debug("PERSONAL RESEND Instance Create...");
		}
	}

	
	public static void init(Object tmp) throws Exception {

		Properties prop = (Properties) tmp;

		if (log.isDebugEnabled()) {
			log.debug("PERSONAL RESEND INIT...");
		}
	}
	

	public void setTaskProperty(Properties prop) {
	}

	
	
	public void doErrorProcess(Throwable thr) {

	}

	protected void execute_ListMake() throws Exception {
		// TODO Auto-generated method stub
		//super.execute_ListMake();
	}

	protected void execute_ContentLoad() throws Exception {

	}


	public void execute_initiate() throws Exception {

		super.execute_initiate();
		this.WORK_FILE_ID = "personal_resend_".concat(Cal.getSerialDate());
		this.SPOOL_ANALYZER.setLimitDate(Cal.getDayDate());
		this.SPOOL_ANALYZER.setStep(0);
		if (log.isDebugEnabled()) {
			log.debug("REAL TIME Instance Initiate...");
		} 
	}

	public void release_Resource() {
		// TODO Auto-generated method stub
		super.release_Resource();
	}

	protected void updateTaskState(String __TYPE__, String __STATE__, String __STATE_MSG__) {
	}
	
	protected synchronized void execute_ListLoad() throws Exception {

		// 기존 리스트가 있으면 초기화 하여준다.
		this.SPOOLINFO_LIST.clear();

		SpoolInfo spInfo = null;
		Vector v = null;

		// 실시간 검색 메일에 대해서 스풀과 스풀 정보 파일 생성합니다.
		eMsConnection  conn = null;
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		eMsResultSet rs = null;
		
		String sPostId = "";

		try {
			conn = ConnectionPool.getConnection();
			__EMS_EXEC_STATEMENT__ = conn.createStatement();
			rs = __EMS_EXEC_STATEMENT__.executeQuery(QUERY_SELECT_PERSONAL_RESEND_WORK_INFO);
			PROP = new Properties();

			while (rs.next()) {
				PROP.clear();
				rs.putToMap(PROP, false);

				PROP.setProperty("MAPPINGHEADER", SpoolInfoManager.getSpoolInfo(PROP.getProperty("POST_ID") ).getMappingHeader());
				
				// 정보가 생성되었으면 스풀을 만들자
				SpoolControlTask targetTask = (SpoolControlTask) InstanceFactory.getInstance(PROP, eMsTypes.SPOOLTASK_INSTANCE);

				// 메일 정보를 셋팅한다. 실행해야만 쿼리도 초기화된다.
				targetTask.setTaskProperty(PROP);

				// 매핑 헤더 정보를 셋팅한다. ( List Make에서 만든 매핑 헤더 정보가 닮겨있다. )
				//targetTask.setMAPPING_HEADER_INFO(this.MAPPING_HEADER_INFO);

				// 부자연스러운 호출이지만 일단 Go. [ 추후에 변경 요망 ]
				targetTask.internal_execute();

				// Spool에 대한 정보를 빼내자.
				spInfo = targetTask.getSpoolInfo();
				SpoolInfoManager.registSpoolInfo(spInfo,  spInfo.getID() + "_" + spInfo.getSendState() + Cal.getSerialDate() );

				// SpoolInfo List에 셋팅한다.
				v = spInfo.getSpoolFilesInfo();
				if( v != null && v.size() > 0 ) {
					this.SPOOLINFO_LIST.add(spInfo);
				}

				try {
					// 이렇게 해서 2개 이상의 실시간 검색 메일의
					// spool 파일이 동일하게 생성되는 것을 방지한다.
					//Thread.currentThread().sleep(1000);
					this.wait(1000);
				}
				catch(Exception ex) {
				}
			}
		}
		catch(Exception e) {
			log.error(getName(), e);
			// e.printStackTrace();
			
			try {
				Properties oProp = new Properties();
				oProp.setProperty("POST_ID",sPostId);
				if (log.isDebugEnabled()) {
					log.debug("QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO : "  + QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO);
					log.debug("oProp : " + oProp);
					log.debug("__EMS_EXEC_STATEMENT__ :  " + __EMS_EXEC_STATEMENT__);
				}
				__EMS_EXEC_STATEMENT__.executeUpdate(StringConvertUtil.ConvertString(QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO, oProp, "${", "}", false, false));

			} catch(Exception e2) {
				log.error(getName(), e2);
			}
			
		}
		finally {
			
			if( rs != null ) {
				try {
					rs.close();
				} catch(Exception e) {}
			}
			
			__EMS_EXEC_STATEMENT__.close();
			conn.recycle();
		}

	}

	protected void execute_Startup() throws Exception {
		// TODO Auto-generated method stub

	}

	protected void execute_Finish() throws Exception {
		// TODO Auto-generated method stub

	}

	
	protected synchronized void execute_ListSend() throws Exception {

		// 실시간 검색 메일에 대해서만 발송한다.
		if( this.SPOOLINFO_LIST == null ) {
			log.debug( " No Real Data.... So Skip ");
		}

		if(this.SPOOLINFO_LIST != null) {
			for (Iterator it = this.SPOOLINFO_LIST.iterator(); it.hasNext();) {
				this.mailSpoolInfo = (SpoolInfo) it.next();
				
	//			super.execute_MassResend_ListSend();
				
				//sms개별재발송으로 전환
				if( this.mailSpoolInfo != null ) {
					SPOOL_POPPER = Popper.getInstance();
	
					/*
					 * 주기발송이나 수시발송의 경우 List쿼리의 결과가 없으면 41로 상태가 바뀐다. 여기서 Spool정보 XML파일의
					 * 정보를 미리가져와서 Vector가 비었는지 체크 필
					 */
					if( this.mailSpoolInfo.getSpoolFilesInfo().isEmpty() ) {
						//if (log.isDebugEnabled())
						log.debug( "No Real Data.... So Skip");
	
						return;
					}
	
					try{
						SPOOL_POPPER.setTaskProp(PROP);
						SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
					}catch(Exception ex){
						log.error("spool popper error", ex);
					}
				}
				else {
					log.debug( "SMS SPOOL INFO IS NULL SO SKIP..");
					return;
				}
	
				if( this.SPOOL_POPPER == null ) {
					log.error("No Real Data.... So Skip");
					return;
				}
	
				if( execute_StopCheck() ) {
					throw new SendStopException(getName() + " receive stop signal");
				}
				
				RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.PROP);
	
				String nextSpool = null;
				String domain = null;
				int spoolPatchCount = 0;
				BufferedAgentPool pool = null;
				
				String email_str = null;
				String email_en  = null;
				String ori_Spool = null;
				
				StringBuffer strBuffer = new StringBuffer(1024);
				int email_en_len = 0;
				/* 
				 * 
				 * SMS TYPE(SMS/LMS/MMS) 을 도메인으로 본다.
				 * SMS/LMS/MMS 각각의 Agent pool 을 생성해놨기 때문에
				 * 해당되는 TYPE을 domain 에 할당한다. 
				 * 
				 */
				domain = this.PROP.getProperty("SMS_TYPE").toLowerCase();
				if("".equals(domain)){
					domain = getSmstype();
				}
				
				//동보일 경우 SMS는 SMSD 로 LMS는 LMSD로 SMS_TYPE 변경
				if("SMS".equalsIgnoreCase(this.PROP.getProperty("SMS_TYPE")) || "LMS".equalsIgnoreCase(this.PROP.getProperty("SMS_TYPE"))){
					if(this.PROP.getProperty("DONGBO_YN").equals("Y")){				
						domain = domain+"d";					
					}
				}
	
				while ((nextSpool = (String) this.SPOOL_POPPER.next()) != null) {
	
					if( nextSpool == null || nextSpool.length() < 1 )
						continue;
	
					if( spoolPatchCount++ % instance_STOP_CHECK_RECYCLE == 0 ) {
						if( execute_StopCheck() ) {
							throw new SendStopException(getName() + " receive stop signal");
						}
					}
					
					String phoneEn = null;
					String phoneStr = null;
					
					try {
						ori_Spool = nextSpool;
						
						if (ENC_YN.equals("Y")) {
							phoneEn = getSecureSms(nextSpool);
							
							if (!ChannelType.PUSH.getCode().equals(this.TASK_PROPERTY.getProperty(CommonColumn.CHANNEL_TYPE.getCode()))) {
								if (ENC_KEY.equals("")) {
									phoneStr = CryptoUtil.decrypt(phoneEn, CryptoUtil.TEL_NUM);
								} else {
									phoneStr = CryptoUtil.decrypt(phoneEn, CryptoUtil.TEL_NUM, ENC_KEY);
								}
							} else {
								phoneStr = phoneEn;
							}
							
							strBuffer.setLength(0);
							strBuffer.append(phoneEn)
								.append(CryptoUtil.TMS_DECRYPT_TAG)
								.append(phoneStr)
								.append(nextSpool.substring(phoneEn.length()));
							
							nextSpool = strBuffer.toString();
						}
						
						if( domain == null ) {
							processSyntaxErrorSpool(nextSpool);
							continue;
						}
	
						// Spool의 내용에서 필터링을 적용하여 보내지 않을 대상인지를 판별한다.
						if( instanceRejectFilter != null ) {
	
							this.SPOOL_ANALYZER.parse(nextSpool);
	
							if( instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER) ) {
								continue;
							}
	
							nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
						}
						
						
						
						pool = this.getBufferedObjectPool(domain);
						pool.registSpool(domain, nextSpool);
					}
					catch(OutOfMemoryError outError) {
						log.error("OOM error", outError);
						System.gc();
	
						try {
							wait(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
						}
						catch(Exception ignore) {
						}
	
						try {
							//뜻하지 않은 에러이므로 재발송 스풀 생성을 담당하는 SpoolingManager에 넣어준다.
							//SpoolingManager.registSpool(nextSpool);
							SpoolingManager.registSpool(ori_Spool);
						}
						catch(Exception ignore) {
						}
	
						continue;
					}
					catch(Throwable err) {
						log.error("error", err);
						ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
						continue;
					}
				}//end of while
	
				if (log.isDebugEnabled()) 
					log.debug("EXEC BufferedAgentPool.flushAll()");
	
				BufferedAgentPool.flushAll();
	
				if (log.isDebugEnabled()) 
					log.debug("EXEC execute_ListSend [OK]");
	
				//TODO 'Refactor the synchronisation mechanism to not use a Thread instance as a monitor'
				wait_thread(100);
//				try {
//					Thread.currentThread().wait(100);
//				}
//				catch(Exception ex_sub) {
//				}
			}
		}

		BufferedAgentPool.flushAll();
	}


	/**
	 * 지정된 도메인의 BufferedPool을 반환한다. BufferedAgentPool.getBufferedObjectPool( domain );
	 */
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		return BufferedAgentPool.getBufferedObjectPool("single", domain);
	}
	
	/** 
	 * domain에 SMS_TYPE이 잡히지 않을때
	 */
	private String getSmstype() throws Exception {
		
		eMsConnection emsConnection 		= null;
		try{
			emsConnection 			= ConnectionPool.getConnection();
			StringBuffer buffer = new StringBuffer(256);
			StringConvert.ConvertStringUseMap(buffer, QUERY_CHECK_SMS_TYPE, this.PROP, "${", "}", false, true);					    
			Properties m = new Properties();
			emsConnection.putSingleResultToMap(buffer.toString(), m);
			return m.getProperty("SMS_TYPE");
		}
		catch( Exception e ){
			log.error( getName() , e );
			throw new Exception(e);
		}finally{
			if(emsConnection != null) {
				emsConnection.recycle();
			}
		}
	}
	
	//TODO 'Refactor the synchronisation mechanism to not use a Thread instance as a monitor'
	private synchronized void wait_thread(long time) throws InterruptedException {
		try {
			wait(time);	
		} catch (Exception e) {
			// TODO: handle exception
		}
	}
}
