/*
 * @(#)SingleTestSendTask.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.mass.send.task;

import java.util.Properties;

import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.basic.InstanceFactory;
import mercury.contents.common.producer.ContentPD;

import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.AbstractDBMailSendTask;
import pluto.config.SqlManager;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsTypes;
import pluto.util.Cal;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.parallel.task.SpoolControlTask;
/**
 * 원투원 테스트 메일 발송 구현의 로직을 구현한다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class SingleTestSendTask extends AbstractDBMailSendTask {
	
	
	public static String QUERY_TEST_LIST_SAMPLING_QUERY = null;
	
	static {
		try {
			QUERY_TEST_LIST_SAMPLING_QUERY = SqlManager.getQuery("WINDFORCE_COMMON","QUERY_TEST_LIST_SAMPLING_QUERY");
		}
		catch( Exception e ) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}
	
	/** Tracer의 debugging에 표시할지 말지 여부 */
	
	
	/** Creates a new instance of SingleTestSendTask */
	public SingleTestSendTask() throws Exception{
		super();
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	public void setTaskProperty(Properties prop) {
		
		this.TASK_PROPERTY = prop;
		
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_real_test_").concat( Cal.getSerialDate() );
		this.setTaskID( this.POST_ID.concat("_TEST") );
		this.setName( this.POST_ID + "_SingleTestSendTask" );
	}

	/**
	 * CONTENTS_CONF 위치를 읽어들이고 Xml을 ContentInfo로 변환하여 Manager에 등록한다. setTaskProperty()가 호출된 이후에 실행되어야 된다.
	 */
	protected void execute_ContentLoad() throws Exception {

		// 2008.04.02 by keidao
		// 컨텐츠를 생성하는 부분이다.
		// package kr.co.amail.ems.module.mercury.ContentGenerator의 내용을 갖고 왔다.
//		updateTaskState("91", "91", "Start ContentMake");
		this.TASK_PROPERTY.setProperty("TASK_ID",this.TASK_PROPERTY.getProperty("POST_ID") + "_CONTENTS");
		
		String send_state = this.TASK_PROPERTY.getProperty("SEND_STATE");
		String send_type = this.TASK_PROPERTY.getProperty("SEND_TYPE");
		ContentPD targetContentPD = (ContentPD) InstanceFactory.getInstance(send_type, send_state, eMsTypes.CONTENTPD_INSTANCE);
		targetContentPD.process(this.TASK_PROPERTY);
		ContentInfo sendContentInfo = targetContentPD.getContentInfo();

		/* xml 파일을 생성한다. */
		ContentInfoManager.registContentInfo(sendContentInfo);
		ContentInfoManager.putContentInfo(sendContentInfo, false);

		if (log.isDebugEnabled()) {
			log.debug("call execute_ContentLoad");
		}
	
		/* 2008.04.02 by keidao 
		 * 파일을 직접 복사하므로 카피할 필요가 없다.	
 
 		String contentInfoConfig = TASK_PROPERTY.getProperty("CONTENT_CONF");
		this.SEND_CONTENT_INFO = ContentInfo.XmlToContentInfo(contentInfoConfig);
		ContentInfoManager.putContentInfo(this.SEND_CONTENT_INFO, false);

		// content info를 발송서버로 옮긴다. 이는 나중에 큐발송을 위해 하는 것이다.
		String newFile = contentInfoConfig.substring(contentInfoConfig.lastIndexOf("/") + 1);

		File f = new File(FileElement.CheckSubDirectory(eMsSystem.getProperty("content.info.save.dir"), newFile.substring(0, 8)) + File.separator + newFile);

		if( !f.exists() ) {
			FileElement fe = FileElement.getFileElement(contentInfoConfig);
			InputStream is = fe.getStream();

			FileOutputStream fos = null;
			try {
				fos = new FileOutputStream(f);
				byte[] b = new byte[2 << 6];

				int i;
				while (true) {
					i = is.read(b);
					if( i <= 0 )
						break;
					fos.write(b, 0, i);
					fos.flush();
				}
			}
			finally {
				try {
					fos.close();
				}
				catch(Exception e) {
					// foo
				}
			}
		}
*/	}	
	
	/**
	 * 추가 리스트 가져올 것을 구현한다.  
	 */
	protected void execute_ListMake() throws Exception {
	}

	/**
	 * SPOOL_CONF 위치를 읽어들이고 Xml을 SpoolInfo로 변환하여 Manager에 등록한다. setTaskProperty()가 호출된 이후에 실행되어야 된다.
	 */
	protected void execute_ListLoad() throws Exception {

		// 2008.04.02 by keidao
		// 스풀 생성
		this.TASK_PROPERTY.setProperty("TASK_NAME" , this.TASK_PROPERTY + "_SPOOLING");
		
		SpoolControlTask task = ( SpoolControlTask )venus.spool.common.basic.InstanceFactory.getInstance( 
				this.TASK_PROPERTY , eMsTypes.SPOOLTASK_INSTANCE );
	
		task.setTaskProperty(this.TASK_PROPERTY);
		task.setParallelInfo(false,"서버 설정값");		//	엔진별로 병렬발송 정보 셋팅 하도록 설정
		try {
			task.internal_execute();
		}
		catch (Throwable error) {
			log.error( getName() , error );
			// error.printStackTrace();
		}
		// END 스풀 생성
		
		this.mailSpoolInfo = task.getSpoolInfo();
		SpoolInfoManager.putSpoolInfo(this.mailSpoolInfo, false);
		
	}	
	
	/**
	 * 리스트를 다 뿌리고 할 일을 구현한다. 
	 */
	protected void execute_Finish() throws Exception {
	}
	
	/** 
	 * 작업의 제일 초기에 실행
	 */
	protected void execute_Startup() throws Exception {
	}
	
	/** 
	 * 발송 정지 상태를 점검하고 정지되었다면 로그를 작성한다.
	 */
	protected boolean execute_StopCheck() {
		return false;
	}
	
	/** 
	 * 지정된 도메인의 BufferedPool을 반환한다.
	 * BufferedAgentPool.getBufferedObjectPool( domain );
	 */
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		return BufferedAgentPool.getBufferedObjectPool( "single" , domain );
	}
	
	/** 
	 * Syntax Error 스풀을 처리한다.
	 * 실발송과는 달리 log에 적지 않고 Tracer에만 찍는다.
	 */
	protected void processSyntaxErrorSpool(String spool) throws Exception {
		log.error( "TEST SPOOL SYNTAX ERROR" , spool );
	}
	
	/** 
	 * Lookup결과 도메인이 표시되지 않은 경우 스풀을 처리한다.
	 * 실발송과는 달리 log에 적지 않고 Tracer에만 찍는다.
	 */
	protected void passDomainNotFound(String spool , Throwable e ) throws Exception {
		log.error( "TEST SPOOL DOMAIN INVALID" , spool.concat( "=>").concat( e.toString() ) );
	}
	
	/** 
	 * Lookup결과 도메인이 표시되지 않은 경우 스풀을 처리한다.
	 * 실발송과는 달리 log에 적지 않고 Tracer에만 찍는다.
	 */
	protected void passRejectDomain(String spool ) throws Exception{
		log.error( "TEST SPOOL DOMAIN REJECTED" , spool );
	}
}
