/*
 * @(#)SingleErrorSendTask.java            2004. 12. 4.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.send.task;

import java.util.List;
import java.util.Properties;

import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.basic.InstanceFactory;
import mercury.contents.common.producer.ContentPD;

import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsTypes;
import pluto.util.Cal;

/**
 * 대량 메일 에러 매일 재발송의 로직을 구현한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class SingleErrorSendTask extends SingleBaseSendTask {

	protected static List	QUERY_UPDATE_STATE_QUE_RETRY_START	= null;

	protected static List	QUERY_UPDATE_STATE_QUE_RETRY_END	= null;

	static {
		try {
			QUERY_UPDATE_STATE_QUE_RETRY_START = SqlManager.getMultiQuery("WINDFORCE_COMMON", "QUERY_UPDATE_STATE_QUE_RETRY_START");
			QUERY_UPDATE_STATE_QUE_RETRY_END = SqlManager.getMultiQuery("WINDFORCE_COMMON", "QUERY_UPDATE_STATE_QUE_RETRY_END");
		}
		catch(Exception ignore) {
			log.error(ignore.getMessage());
		}
	}

	/** Creates a new instance of SingleErrorSendTask */
	public SingleErrorSendTask() throws Exception {
		super();
	}

	public void setTaskProperty(Properties prop) {

		this.TASK_PROPERTY = prop;

		this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");

		this.setTaskID(this.POST_ID);
		this.setName(this.POST_ID + "_SingleErrorSendTask");
		this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat(Cal.getSerialDate());

		// 상위 클래스에서 이거 가지고 업데이트를 해 준다.
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
	}

	/**
	 * 리스트를 뿌리러 들어갈때 실행
	 */
	protected void execute_Startup() throws Exception {
		updateTaskState("95", "46");
		eMsConnection emsConnection = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			emsConnection.executeUpdateList(QUERY_UPDATE_STATE_QUE_RETRY_START, this.TASK_PROPERTY, "${", "}", false);
		}
		catch(Exception e) {
			log.error(getName(), e);
		}finally{
			if(emsConnection != null) {
				emsConnection.recycle();
			}
		}
	}

	/**
	 * 리스트를 다 뿌리고 나올때 실행
	 */
	protected void execute_Finish() throws Exception {
		updateTaskState("95", "40");
		eMsConnection emsConnection = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			emsConnection.executeUpdateList(QUERY_UPDATE_STATE_QUE_RETRY_END, this.TASK_PROPERTY, "${", "}", false);
		}
		catch(Exception e) {
			log.error(getName(), e);
		}finally{
			if(emsConnection != null) {
				emsConnection.recycle();
			}
		}
	}

	/**
	 */
	protected boolean execute_StopCheck() {
		// 만일 윗동네에서 중지를 감지하면 이건 에러메일 재발송이므로 그냥 스톱으로 가야한다.
		if( super.execute_StopCheck() ) {
			updateTaskState("95", "40");
			try {
				execute_Finish();
			}
			catch(Exception e) {
				log.error("NETWORK ERROR RESEND CHECK ERROR", e);
			}
			return true;
		}

		return false;
	}
	
	/**
	 * CONTENTS_CONF 위치를 읽어들이고 Xml을 ContentInfo로 변환하여 Manager에 등록한다. setTaskProperty()가 호출된 이후에 실행되어야 된다.
	 */
	protected void execute_ContentLoad() throws Exception {
		updateTaskState("44", "44", "Start ContentMake");
		this.TASK_PROPERTY.setProperty("TASK_ID",this.TASK_PROPERTY.getProperty("POST_ID") + "_CONTENTS");
		
		String send_state = this.TASK_PROPERTY.getProperty("SEND_STATE");
		String send_type = this.TASK_PROPERTY.getProperty("SEND_TYPE");
		ContentPD targetContentPD = (ContentPD) InstanceFactory.getInstance(send_type, send_state, eMsTypes.CONTENTPD_INSTANCE);
		targetContentPD.process(this.TASK_PROPERTY);
		ContentInfo sendContentInfo = targetContentPD.getContentInfo();

		ContentInfoManager.registContentInfo(sendContentInfo);
	}
	
}
