
package jupiter.mass.send.task;

import java.util.List;
import java.util.Properties;

import jupiter.common.actor.ListMaker;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.CommonStepMailSendTask;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.basic.InstanceFactory;
import mercury.contents.common.producer.ContentPD;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsTypes;
import pluto.mail.MailSendingInstanceFactory;
import pluto.reporter.Reporter;
import pluto.util.Cal;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.parallel.task.SpoolControlTask;

/**
 * 대량 메일 발송의 로직을 구현한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class SingleBaseSendTask extends CommonStepMailSendTask {

	/**
	 * 스케쥴 테이블 상태값 업데이트
	 */
	protected static List			QUERY_UPDATE_STATE_INFO		= null;

	/**
	 * 시작 업데이트
	 */
	protected static List			QUERY_UPDATE_STATE_START	= null;

	/**
	 * 종료 업데이트
	 */
	protected static List			QUERY_UPDATE_STATE_END		= null;

	/**
	 * 발송정지 상태를 점검한다.
	 */
	protected static String			QUERY_CHECK_STOP_FLAG		= null;

	static {
		try {
			QUERY_UPDATE_STATE_INFO = SqlManager.getMultiQuery("WINDFORCE_COMMON", "QUERY_UPDATE_STATE_INFO");

			QUERY_UPDATE_STATE_START = SqlManager.getMultiQuery("WINDFORCE_COMMON", "QUERY_UPDATE_STATE_START");

			QUERY_UPDATE_STATE_END = SqlManager.getMultiQuery("WINDFORCE_COMMON", "QUERY_UPDATE_STATE_END");

			QUERY_CHECK_STOP_FLAG = SqlManager.getQuery("WINDFORCE_COMMON", "QUERY_CHECK_STOP_FLAG");
		}
		catch(Exception ignore) {
			log.error(ignore.getMessage());
		}
	}

	protected static boolean		PROCESS_ALAM				= false;

	public static final void init(Object tmp) throws Exception {

		Properties prop = (Properties) tmp;
		PROCESS_ALAM = prop.getProperty("process.notify.flag", "false").equalsIgnoreCase("true");
	}

	/** Creates a new instance of SingleBaseSendTask */
	public SingleBaseSendTask() throws Exception {
		super();
	}

	public void setTaskProperty(Properties prop) {

		this.TASK_PROPERTY = prop;

		this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
		this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat(Cal.getSerialDate());
		
		this.setTaskID(this.POST_ID);
		this.setName(this.POST_ID + "_SingleBaseSendTask");

		/**
		 * 상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;

		/**
		 * 정지를 체크해야할 쿼리를 지정( AbstractDBMailSendTask에서 사용 )
		 */
		this.INSTANCE_QUERY_CHECK_STOP_FLAG = QUERY_CHECK_STOP_FLAG;
	}

	/**
	 * 리스트를 뿌리러 들어갈때 실행 log에 기록(90-30)하고, 'QUERY_UPDATE_STATE_START'를 실행한다.
	 */
	protected void execute_Startup() throws Exception {

		if( PROCESS_ALAM ) {
			Reporter.report(this.TASK_PROPERTY, this.TASK_PROPERTY.getProperty("USER_ID") + "/" + this.TASK_PROPERTY.getProperty("POST_NAME") + " Start");
		}
		// 메일 발송이 시작되었음을 로그에 기록한다. 90-30
		updateTaskState("90", "30");
		eMsConnection emsConnection = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			emsConnection.executeUpdateList(QUERY_UPDATE_STATE_START, this.TASK_PROPERTY, "${", "}", false);
		}
		catch(Exception e) {
			log.error(getName(), e);

			// 더이상 작업을 진행하지 못하도록 상위에 Exception 을 넘긴다.
			throw new Exception(e);
		}finally{
			if(emsConnection != null)
				emsConnection.recycle();
		}
	}

	/**
	 * 리스트를 다 뿌리고 나올때 실행 log에 기록 (90-40)하고, 'QUERY_UPDATE_STATE_END'를 실행한다.
	 */
	protected void execute_Finish() throws Exception {

		if( PROCESS_ALAM ) {
			Reporter.report(this.TASK_PROPERTY, this.TASK_PROPERTY.getProperty("USER_ID") + "/" + this.TASK_PROPERTY.getProperty("POST_NAME") + " End");
		}
		updateTaskState("90", "40");
		eMsConnection emsConnection = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			emsConnection.executeUpdateList(QUERY_UPDATE_STATE_END, this.TASK_PROPERTY, "${", "}", false);
		}
		catch(Exception e) {
			log.error(getName(), e);
		}finally{
			if(emsConnection != null)
				emsConnection.recycle();
		}
	}

	/**
	 * 지정된 도메인의 BufferedPool을 반환한다. BufferedAgentPool.getBufferedObjectPool( domain );
	 */
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {

		return BufferedAgentPool.getBufferedObjectPool("single", domain);
	}

	protected void execute_ListMake() throws Exception {

		ListMaker targetMaker = (ListMaker) MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, eMsTypes.LISTMAKER_INSTANCE);
		targetMaker.process(this.TASK_PROPERTY);
	}
	
	/**
	 * SPOOL_CONF 위치를 읽어들이고 Xml을 SpoolInfo로 변환하여 Manager에 등록한다. setTaskProperty()가 호출된 이후에 실행되어야 된다.
	 */
	protected void execute_ListLoad() throws Exception {

		this.TASK_PROPERTY.setProperty("TASK_ID",this.TASK_PROPERTY.getProperty("POST_ID") + "_SPOOLING");
		this.TASK_PROPERTY.setProperty("TASK_NAME",this.TASK_PROPERTY.getProperty("POST_ID") + "_SPOOLING");
		
		SpoolControlTask task = ( SpoolControlTask )venus.spool.common.basic.InstanceFactory.getInstance( this.TASK_PROPERTY , eMsTypes.SPOOLTASK_INSTANCE );
	
		task.setTaskProperty(this.TASK_PROPERTY);
		// 병렬발송은 타겟팅에서 설정하게 바뀌었다.
		try {
			task.internal_execute();
		}
		catch (Throwable error) {
			log.error( getName() , error );
			// error.printStackTrace();
		}
		// END 스풀 생성
		
		this.mailSpoolInfo = task.getSpoolInfo();
		SpoolInfoManager.putSpoolInfo(this.mailSpoolInfo, false);
	}

	/**
	 * CONTENTS_CONF 위치를 읽어들이고 Xml을 ContentInfo로 변환하여 Manager에 등록한다. setTaskProperty()가 호출된 이후에 실행되어야 된다.
	 */
	protected void execute_ContentLoad() throws Exception {

		updateTaskState("91", "91", "Start ContentMake");
		this.TASK_PROPERTY.setProperty("TASK_ID",  this.TASK_PROPERTY.getProperty("POST_ID") + "_CONTENTS");
		this.TASK_PROPERTY.setProperty("TASK_NAME",this.TASK_PROPERTY.getProperty("POST_ID") + "_CONTENTS");
		
		String send_state = this.TASK_PROPERTY.getProperty("SEND_STATE");
		String send_type = this.TASK_PROPERTY.getProperty("SEND_TYPE");
		ContentPD targetContentPD = (ContentPD) InstanceFactory.getInstance(send_type, send_state, eMsTypes.CONTENTPD_INSTANCE);
		targetContentPD.process(this.TASK_PROPERTY);
		ContentInfo sendContentInfo = targetContentPD.getContentInfo();

		/* xml 파일을 생성한다. */
		ContentInfoManager.registContentInfo(sendContentInfo);

		if (log.isDebugEnabled()) {
			log.debug("call execute_ContentLoad");
		}
	
	}
}
