/*
 * @(#)BulkTestSendTask.java            2004. 12. 4.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.mass.send.task;

import java.util.Enumeration;
import java.util.Properties;

import jupiter.common.pool.BufferedAgentPool;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.mail.DomainFullException;
import pluto.mail.MultiRcptDomainGroupingManager;
import pluto.mail.MultiRcptInfo;
import pluto.mail.mx.LookupCacheManager;
import pluto.util.Cal;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;
/**
 * 동보 테스트 발송의 로직을 구현한다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class BulkTestSendTask extends SingleTestSendTask {
	
	
	
	
	/** Creates a new instance of BulkTestSendTask */
	public BulkTestSendTask() throws Exception{
		super();
	}
	
	public void setTaskProperty(Properties prop){
		
		this.TASK_PROPERTY = prop;
		
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		
		this.setTaskID( this.POST_ID.concat("_TEST") );
		this.setName( this.POST_ID + "_BulkTestSendTask" );
		
		this.WORK_FILE_ID = this.POST_ID.concat("_bulk_test_").concat( Cal.getSerialDate() );
				
		this.SPOOL_ANALYZER.setSendType( "MTEST" );// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate( "N" );// spool attach
		this.SPOOL_ANALYZER.setLimitDate( "19000101" );
		this.SPOOL_ANALYZER.setPostID( this.POST_ID );
		this.SPOOL_ANALYZER.setListTable( this.LIST_TABLE );
		this.SPOOL_ANALYZER.setStep( 0 );
		
	}
	
	/** 지정된 도메인의 BufferedPool을 반환한다.
	 * BufferedAgentPool.getBufferedObjectPool( domain );
	 */
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		return BufferedAgentPool.getBufferedObjectPool( "bulk" , domain );
	}


	/**
	 * 리스트 로드
	 */
	protected synchronized void execute_ListSend() throws Exception {
		
		
		// Popper의 Instance는 xml의 POPPER FACTORY에 정의되어 있다.
		// 보낼 대상이 등록되어 있으면 그것으로 SPOOL_POPPER를 초기화한다.  
		if( this.mailSpoolInfo != null ) {
			SPOOL_POPPER = Popper.getInstance();
			SPOOL_POPPER.init( this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo() );
		}
		
		if( this.SPOOL_POPPER == null ) {
			if (log.isDebugEnabled()) 
					log.debug( "No Test Data.... So Skip" );
			return;
		}
		
		//도메인별 소팅할 녀석을 준비
		MultiRcptDomainGroupingManager _DOMAIN_MANAGER_ = 
				new MultiRcptDomainGroupingManager();
		
		String _NEXT_SPOOL_ = null;
		
		MultiRcptInfo _RCPT_TARGET_LIST_ = null;
		
		// int _SEND_COUNT_ = 0;
		
		while( (_NEXT_SPOOL_ = (String)this.SPOOL_POPPER.next() ) != null ) {
			if (log.isDebugEnabled())  log.debug( "READ SPOOL", _NEXT_SPOOL_ );
			if( _NEXT_SPOOL_.trim().length() < 1 ) continue;
			
		
			try {
				String domain = this.SPOOL_ANALYZER.pickupDomain( _NEXT_SPOOL_ );
				
				/**도메인이 널이면
				 */
				if( domain == null ){
					if (log.isDebugEnabled())  log.debug( "DOMAIN ERROR", _NEXT_SPOOL_ );
					processSyntaxErrorSpool( _NEXT_SPOOL_ );
					continue;
				}

				
				DOMAIN_NOT_FOUND_EXCEPTION = LookupCacheManager.isInvalidDomain( domain );
				if( DOMAIN_NOT_FOUND_EXCEPTION != null ){
					passDomainNotFound( _NEXT_SPOOL_ , DOMAIN_NOT_FOUND_EXCEPTION );
					continue;
				}
				
				try {
					_RCPT_TARGET_LIST_ = _DOMAIN_MANAGER_.addMultipleRcptElement( _NEXT_SPOOL_ , domain );
				}
				catch( DomainFullException e ) {
					for(  Enumeration myEnum = _DOMAIN_MANAGER_.elements(); myEnum.hasMoreElements();  ) {
						_RCPT_TARGET_LIST_ = ( MultiRcptInfo )myEnum.nextElement();
						
						String result = null;
						if( ( result =_RCPT_TARGET_LIST_.getResult() ) == null ){
							_DOMAIN_MANAGER_.remove( _RCPT_TARGET_LIST_.getDomain() );
						}
						else{
							BufferedAgentPool pool = this.getBufferedObjectPool( _RCPT_TARGET_LIST_.getDomain() );
							pool.push( result );
						}
					}
					continue;
				}
				
				if( _RCPT_TARGET_LIST_ == null ) {
					//TODO 'A "NullPointerException" could be thrown; "_RCPT_TARGET_LIST_" is nullable here.'
					// if (log.isDebugEnabled())  log.debug( _RCPT_TARGET_LIST_.getDomain() + " is keep into Manager" );
					continue;
				}
				
				if (log.isDebugEnabled())  log.debug( _RCPT_TARGET_LIST_.getDomain() + " is sending" );
				
				/**그동안 모은 녀석들을 집어넣는다.
				 */
				BufferedAgentPool pool = this.getBufferedObjectPool( _RCPT_TARGET_LIST_.getDomain() );
				pool.push( _RCPT_TARGET_LIST_.getResult() );
			}
			catch( OutOfMemoryError outError ) {
				log.error("OOM error", outError);
				/**OutOfMemoryError 가 발생하면 일단 쉬고 지금 읽은 스풀은 Que로 보내고 쉰다.
				 */
				// garbage collector를 호출한다.
				System.gc();
				
				
				//TODO 'Refactor the synchronisation mechanism to not use a Thread instance as a monitor'
				wait_thread(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
				//try{ Thread.currentThread().sleep( eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL ); }catch( Exception ignore ){}
				
				
				try{ SpoolingManager.registSpool( _NEXT_SPOOL_ ); } catch( Exception ignore ){}
				continue;
			}
			catch( Throwable err ) {
				log.error("error", err );
				ErrorSpoolLogger.put( _NEXT_SPOOL_ );
				continue;
			}
		}
		
		for(  Enumeration myEnum = _DOMAIN_MANAGER_.elements(); myEnum.hasMoreElements();  ) {
			_RCPT_TARGET_LIST_ = ( MultiRcptInfo )myEnum.nextElement();
			
			String result = null;
			if( ( result =_RCPT_TARGET_LIST_.getResult() ) == null ){
				_DOMAIN_MANAGER_.remove( _RCPT_TARGET_LIST_.getDomain() );
			}
			else{
				BufferedAgentPool pool = this.getBufferedObjectPool( _RCPT_TARGET_LIST_.getDomain() );
				pool.push( result );
			}
		}
		
		_DOMAIN_MANAGER_.clear();
		
		if (log.isDebugEnabled())  log.debug( "EXEC BufferedAgentPool.flushAll()" );
		
		BufferedAgentPool.flushAll();
		
		if (log.isDebugEnabled())  log.debug( "EXEC execute_ListSend [OK]" );
	}

	//TODO 'Refactor the synchronisation mechanism to not use a Thread instance as a monitor'
	private synchronized void wait_thread(long time) throws InterruptedException {
		try {
			wait(time);	
		} catch (Exception e) {
			// TODO: handle exception
		}
	}
}

