/*
 * @(#)BulkFailOverSendTask.java            2004. 12. 4.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.mass.send.task;

import java.util.List;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;

/**
 * 동보 메일 큐발송의 로직을 구현한다. 
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class BulkFailOverSendTask extends BulkBaseSendTask {
	
	
	protected static List QUERY_UPDATE_STATE_RETRY_START = null;
	
	static {
		try {
			QUERY_UPDATE_STATE_RETRY_START = SqlManager.getMultiQuery("WINDFORCE_COMMON","QUERY_UPDATE_STATE_RETRY_START");
		}
		catch( Exception ignore ) {
			log.error(ignore.getMessage());
		}
	}
	
	
	
	/** Creates a new instance of BulkFailOverSendTask */
	public BulkFailOverSendTask() throws Exception {
		super();
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	public void setTaskProperty(Properties prop){
		this.TASK_PROPERTY = prop;
		
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_real_re_bulk_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_BulkErrorResendTask" );
		
		// 상위 클래스에서 이거 가지고 업데이트를 해 준다.
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
	}
	
	/** 리스트를 뿌리러 들어갈때 실행
	 */
	protected void execute_Startup() throws Exception {
		updateTaskState( "90" , "36" );
		eMsConnection emsConnection = null;
		try{
			emsConnection = ConnectionPool.getConnection();
			emsConnection.executeUpdateList( QUERY_UPDATE_STATE_RETRY_START , this.TASK_PROPERTY , "${" , "}" , false  );
		}
		catch( Exception e ){
			log.error( getName() , e );
		}finally{
			if(emsConnection != null)
				emsConnection.recycle();
		}
	}
}
