/*
 * @(#)BulkErrorSendTask.java            2004. 12. 4.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.send.task;

import java.util.List;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;

/**
 * 동보 에러 매일 재발송의 로직을 구현한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class BulkErrorSendTask extends BulkBaseSendTask {

	protected static List			QUERY_UPDATE_STATE_QUE_RETRY_START	= null;

	protected static List			QUERY_UPDATE_STATE_QUE_RETRY_END	= null;

	static {
		try {
			QUERY_UPDATE_STATE_QUE_RETRY_START = SqlManager.getMultiQuery("WINDFORCE_COMMON", "QUERY_UPDATE_STATE_QUE_RETRY_START");
			QUERY_UPDATE_STATE_QUE_RETRY_END = SqlManager.getMultiQuery("WINDFORCE_COMMON", "QUERY_UPDATE_STATE_QUE_RETRY_END");
		}
		catch(Exception ignore) {
			log.error(ignore.getMessage());
		}
	}

	

	/** Creates a new instance of BulkErrorSendTask */
	public BulkErrorSendTask() throws Exception {
		super();
		if (log.isDebugEnabled()) {
			// foo
		}
	}

	public void setTaskProperty(Properties prop) {

		this.TASK_PROPERTY = prop;

		this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
		this.WORK_FILE_ID = this.POST_ID.concat("_real_bulk_").concat(Cal.getSerialDate());

		this.setTaskID(this.POST_ID);
		this.setName(this.POST_ID + "_BulkNetworkErrorReSendTask");

		// 상위 클래스에서 이거 가지고 업데이트를 해 준다.
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
	}

	/**
	 * 리스트를 뿌리러 들어갈때 실행
	 */
	protected void execute_Startup() throws Exception {

		updateTaskState("95", "46");
		eMsConnection emsConnection = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			emsConnection.executeUpdateList(QUERY_UPDATE_STATE_QUE_RETRY_START, this.TASK_PROPERTY, "${", "}", false);
		}
		catch(Exception e) {
			log.error(getName(), e);
		}finally{
			if(emsConnection != null){
				emsConnection.recycle();
			}
		}
	}

	/**
	 * 리스트를 다 뿌리고 나올때 실행
	 */
	protected void execute_Finish() throws Exception {

		updateTaskState("95", "40");
		eMsConnection emsConnection = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			emsConnection.executeUpdateList(QUERY_UPDATE_STATE_QUE_RETRY_END, this.TASK_PROPERTY, "${", "}", false);
		}
		catch(Exception e) {
			log.error(getName(), e);
		}finally{
			if(emsConnection != null){
				emsConnection.recycle();
			}
		}
	}

	/**
	 */
	protected boolean execute_StopCheck() {

		// 만일 윗동네에서 중지를 감지하면 이건 에러메일 재발송이므로 그냥 스톱으로 가야한다.
		if( super.execute_StopCheck() ) {
			updateTaskState("95", "40");
			try {
				execute_Finish();
			}
			catch(Exception e) {
				log.error("NETWORK ERROR RESEND CHECK ERROR", e);
			}
			return true;
		}

		return false;
	}
}
