/*
 * @(#)BulkBaseSendTask.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.send.task;

import java.util.Enumeration;
import java.util.Properties;

import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.basic.SendStopException;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.mail.DomainFullException;
import pluto.mail.MultiRcptDomainGroupingManager;
import pluto.mail.MultiRcptInfo;
import pluto.mail.mx.LookupCacheManager;
import pluto.mail.mx.exception.NameNotKnownException;
import pluto.util.Cal;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.NoSpoolFileException;
import venus.spool.common.popper.Popper;

/**
 * 동보 대량 메일 발송을 담당하는 녀석
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class BulkBaseSendTask extends SingleBaseSendTask {

	

	/** Creates a new instance of BulkBaseSendTask */
	public BulkBaseSendTask() throws Exception {
		super();
	}

	@Override
	public void setTaskProperty(Properties prop) {

		this.TASK_PROPERTY = prop;

		this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");

		this.setTaskID(this.POST_ID);
		this.setName(this.POST_ID + "_BulkBaseSendTask");
		this.WORK_FILE_ID = this.POST_ID.concat("_real_bulk_").concat(Cal.getSerialDate());

		// 상위 클래스에서 이거 가지고 업데이트를 해 준다.
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
	}

	protected synchronized void execute_ListSend() throws Exception {

		// Popper의 Instance는 xml의 POPPER FACTORY에 정의되어 있다.
		// 보낼 대상이 등록되어 있으면 그것으로 SPOOL_POPPER를 초기화한다.
		if( this.mailSpoolInfo != null ) {
			SPOOL_POPPER = Popper.getInstance();
			try {
				SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
			}
			catch(NoSpoolFileException thw) {
				// 스풀파일이 없으면 그냥 돌아간다.
				return;
			}
		}

		if( this.SPOOL_POPPER == null ) {
			if (log.isDebugEnabled()) 
				log.debug("No Real Data.... So Skip");
			return;
		}

		//도메인별 소팅할 녀석을 준비
		MultiRcptDomainGroupingManager _DOMAIN_MANAGER_ = new MultiRcptDomainGroupingManager();

		String _NEXT_SPOOL_ = null;

		MultiRcptInfo _RCPT_TARGET_LIST_ = null;

		int _SEND_COUNT_ = 0;

		while ((_NEXT_SPOOL_ = (String) this.SPOOL_POPPER.next()) != null) {
			if (log.isDebugEnabled()) {
				log.debug("READ SPOOL:" + _NEXT_SPOOL_);
			}

			if( _NEXT_SPOOL_.trim().length() < 1 ) {
				if (log.isDebugEnabled()) {
					log.debug("SKIP LENGTH 0 SPOOL:" + _NEXT_SPOOL_);
				}
				continue;
			}

			if( _SEND_COUNT_++ > STOP_CHECK_RECYCLE ) {
				if( execute_StopCheck() ) {
					throw new SendStopException(getName() + " receive stop signal");
				}
				_SEND_COUNT_ = 0;
			}

			try {
				String domain = this.SPOOL_ANALYZER.pickupDomain(_NEXT_SPOOL_);

				// 도메인이 널이면
				if( domain == null ) {
					if (log.isDebugEnabled()) {
						log.debug("SKIP DOMAIN ERROR:" + _NEXT_SPOOL_);
					}
					processSyntaxErrorSpool(_NEXT_SPOOL_);
					continue;
				}

				// 제끼고 가야하는 도메인이라면?
				if( pluto.panopticon.monitor.MailSendDomainFilter.isFilterPresent() && pluto.panopticon.monitor.MailSendDomainFilter.isTargetDomain(domain) ) {
					passRejectDomain(_NEXT_SPOOL_);
					if (log.isDebugEnabled()) {
						log.debug("MailSendDomainFilter Reject:" + _NEXT_SPOOL_);
					}
					continue;
				}

				DOMAIN_NOT_FOUND_EXCEPTION = LookupCacheManager.isInvalidDomain(domain);
				if( DOMAIN_NOT_FOUND_EXCEPTION != null && DOMAIN_NOT_FOUND_EXCEPTION instanceof NameNotKnownException ) {
					passDomainNotFound(_NEXT_SPOOL_, DOMAIN_NOT_FOUND_EXCEPTION);
					if (log.isDebugEnabled()) {
						log.debug("DOMAIN_NOT_FOUND_EXCEPTION SKIP:" + _NEXT_SPOOL_);
					}
					continue;
				}

				try {
					_RCPT_TARGET_LIST_ = _DOMAIN_MANAGER_.addMultipleRcptElement(_NEXT_SPOOL_, domain);
				}
				catch(DomainFullException e) {
					if (log.isDebugEnabled()) {
						log.debug("DomainFullException !!!");
					}
					for (Enumeration myEnum = _DOMAIN_MANAGER_.elements(); myEnum.hasMoreElements();) {
						_RCPT_TARGET_LIST_ = (MultiRcptInfo) myEnum.nextElement();

						String result = null;
						if( (result = _RCPT_TARGET_LIST_.getResult()) == null ) {
							_DOMAIN_MANAGER_.remove(_RCPT_TARGET_LIST_.getDomain());
						}
						else {
							BufferedAgentPool pool = this.getBufferedObjectPool(_RCPT_TARGET_LIST_.getDomain());
							if (log.isDebugEnabled()) {
								log.debug("regist:" + result);
							}
							pool.push(result);
						}
					}
					continue;
				}

				if( _RCPT_TARGET_LIST_ == null ) {
					if (log.isDebugEnabled()) {
						log.debug("REGIST DOMAIN CONTINUE:" + _NEXT_SPOOL_);
					}
					continue;
				}

				// 그동안 모은 녀석들을 집어넣는다.
				BufferedAgentPool pool = this.getBufferedObjectPool(_RCPT_TARGET_LIST_.getDomain());
				if (log.isDebugEnabled()) {
					log.debug("regist:" + _RCPT_TARGET_LIST_.getResult());
				}
				pool.push(_RCPT_TARGET_LIST_.getResult());
			}
			catch(OutOfMemoryError outError) {
				if (log.isDebugEnabled()) {
					log.debug("outof memory..!!!!");
				}
				log.error("OOM error", outError);
				// OutOfMemoryError 가 발생하면 일단 쉬고 지금 읽은 스풀은 Que로 보내고 쉰다.
				// garbage collector를 호출한다.
				System.gc();

				//TODO 
				wait_thread(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
//				try {
//					Thread.currentThread().sleep(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
//				}
//				catch(Exception ignore) {
//				}

				try {
					SpoolingManager.registSpool(_NEXT_SPOOL_);
				}
				catch(Exception ignore) {
				}
				continue;
			}
			catch(Throwable err) {
				log.error("error", err);
				ErrorSpoolLogger.put(_NEXT_SPOOL_);
				continue;
			}
		}

		for (Enumeration myEnum = _DOMAIN_MANAGER_.elements(); myEnum.hasMoreElements();) {
			_RCPT_TARGET_LIST_ = (MultiRcptInfo) myEnum.nextElement();

			String result = null;
			if( (result = _RCPT_TARGET_LIST_.getResult()) == null ) {
				_DOMAIN_MANAGER_.remove(_RCPT_TARGET_LIST_.getDomain());
			}
			else {
				BufferedAgentPool pool = this.getBufferedObjectPool(_RCPT_TARGET_LIST_.getDomain());
				if (log.isDebugEnabled()) {
					log.debug("regist:" + result);
				}
				pool.push(result);
			}
		}

		_DOMAIN_MANAGER_.clear();

		if (log.isDebugEnabled()) {
			log.debug("EXEC BufferedAgentPool.flushAll()");
		}

		BufferedAgentPool.flushAll();

		if (log.isDebugEnabled()) {
			log.debug("EXEC execute_ListSend [OK]");
		}
	}

	/**
	 * <br>
	 * 지정된 도메인의 BufferedPool을 반환한다. <br>
	 * BufferedAgentPool.getBufferedObjectPool( domain );
	 */
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		return BufferedAgentPool.getBufferedObjectPool("bulk", domain);
	}
	
	//TODO 'Refactor the synchronisation mechanism to not use a Thread instance as a monitor'
	private synchronized void wait_thread(long time) throws InterruptedException {
		try {
			wait(time);	
		} catch (Exception e) {
			// TODO: handle exception
		}
	}
}
