package jupiter.mass.log.updator.sync;

import java.util.Properties;


/**
 * @FileName  	: TableInfo.java
 * @Project     : TMS_1.0_DEV
 * @Date        : 2014. 8. 26. 
 * @Actor      	: pioneer
 * @modify 		:
 * @comment 	: Table 정보 (추가 확장  DB 접속 정보)
 */

public class TableInfo {
	
	private final String columnName = "CODE2";

	private final String codeCode ;
	
	private final String columnFreeStateValue ;
	
	private final String columnRunStateValue ;
	
	private static final String FREE_STATE = "00";
	
	public TableInfo(String columnName, String freeState, String runState, String key){
		this.columnFreeStateValue = freeState;
		this.columnRunStateValue = runState;
		this.codeCode = key;
	}
	
	public TableInfo(String runState, String key){
		this.columnFreeStateValue = FREE_STATE;
		this.columnRunStateValue = runState;
		this.codeCode = key;
	}
	
	public String getCodeCode() {
		return codeCode;
	}

	public String getColumnName() {
		return columnName;
	}


	public String getColumnFreeStateValue() {
		return columnFreeStateValue;
	}


	public String getColumnRunStateValue() {
		return columnRunStateValue;
	}
	
	@Override
	public String toString() {
		return "TableInfo [columnName=" + columnName + ", codeCode=" + codeCode
				+ ", columnFreeStateValue=" + columnFreeStateValue
				+ ", columnRunStateValue=" + columnRunStateValue + "]";
	}
	
}
