package jupiter.mass.log.updator.sync;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @FileName  	: SynchroSwitching.java
 * @Project     : TMS_1.0_DEV
 * @Date        : 2014. 8. 26. 
 * @Actor      	: pioneer
 * @modify 		:
 * @comment 	: Local, DB Sync Switching Service 
 */
@Slf4j
public abstract class SynchroSwitching implements SwitchingService{
	
	private boolean STATE = false;
	
	public void doLock() throws Exception{
		synchronized(this){
			try{
				while(STATE) {
					this.wait();
				}
				while(true){
	    			if(!isRunningState()){
	    				this.wait(5000);
	    				continue;
	    			}
	    			else break;
	    		}
	    		takingState();
	    		STATE = true;
		    }catch(Exception e){
		    	log.error("doLock", e);
		    }
		}
    }
    
    public synchronized void unLock() throws Exception{
    	STATE = false;
    	freeState();
    	this.notifyAll();
    }
    
    public boolean isLock(){
    	return STATE;
    }
    public abstract boolean isRunningState();

    public abstract void takingState();

    public abstract void freeState();
    
}