package jupiter.mass.log.updator.sync;

import java.util.HashMap;
import java.util.Map;

public class SwitchingFactory {
	
	private static final SwitchingFactory switchFactory = new SwitchingFactory();
	
	private final Map<String, SwitchingService> switchList ;

	private SwitchingFactory(){
    	this.switchList = new HashMap<String, SwitchingService>();
    }
	
	public static SwitchingFactory getSwitchingFactory(){
		return switchFactory;
	}
	
	public synchronized SwitchingService getInstance(String key){
		
		if(!switchList.containsKey(key)) switchList.put(key, new LocalSynchroSwitching()); 
		
		return switchList.get(key);
	}
	
	public synchronized SwitchingService getInstance(TableInfo key){
		
		if(!switchList.containsKey(key.getCodeCode())) 
			switchList.put(key.getCodeCode() , new DbSynchroSwithing(key)); 
		
		return switchList.get(key.getCodeCode());
	}
	
	public synchronized void remove(String key){
		if(switchList.containsKey(key)) switchList.remove(key) ;
	}
}
