package jupiter.mass.log.updator.sync;

import java.util.Map;
import java.util.Properties;

import jupiter.mass.log.updator.SmsUpdator;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class EmsDbQuery{
	
	public static void selectExecute(String executeQuery, Object t, Map m){
		eMsConnection	EMS_CONNECTION			= null;
		eMsStatement	__SELECT_STATEMENT		= null;
		eMsResultSet 	__SELECT_RESULT			= null;
		
		try {
			EMS_CONNECTION		= ConnectionPool.getConnection();
			__SELECT_STATEMENT 	= EMS_CONNECTION.createStatement();
			__SELECT_RESULT 	= __SELECT_STATEMENT.executeQuery(executeQuery, t, "${", "}");
			while(__SELECT_RESULT.next()){
				__SELECT_RESULT.putToMap(m, false);
			}
		} catch (Exception e) {
			log.error("error", e);
			
		}finally{
			try {
				if( __SELECT_RESULT != null){
					__SELECT_RESULT.close();
				}
			} catch (Exception e2) {
			}
			try {
				if(__SELECT_STATEMENT != null){
					__SELECT_STATEMENT = null;
				}
			} catch (Exception e2) {
			}
			if(EMS_CONNECTION != null) {
				EMS_CONNECTION.recycle();
			}
		}
	}
	
	public static void updateExecute(String executeQuery, Properties t){
		eMsConnection	EMS_CONNECTION			= null;
		eMsPreparedStatement PSTMT      		= null;
		try {
			EMS_CONNECTION		= ConnectionPool.getConnection();
			
			PSTMT = new eMsPreparedStatement(executeQuery, "${", "}");
			
			PSTMT.connectTo(EMS_CONNECTION);
			
			PSTMT.executeUpdate(t);
			
		} catch (Exception e) {
			log.error("update execute error", e);
		}finally{
			try {
				if(PSTMT != null){
					PSTMT = null;
				}
			} catch (Exception e2) {
			}
			if(EMS_CONNECTION != null) {
				EMS_CONNECTION.recycle();
			}
		}
	}
	
}
