package jupiter.mass.log.updator.sync;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import jupiter.mass.log.updator.SmsUpdator;
import pluto.config.SqlManager;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class DbSynchroSwithing extends Mutex{

	private Properties tableInfo;
	
	private static final String CODE_CODE 	= "CODE_CODE";
	private static final String COLUMN_NAME = "COLUMN_NAME";
	private static final String RUN_STATE 	= "RUN_STATE";
	private static final String FREE_STATE 	= "FREE_STATE";
	private static final String FOR_UPATE 	= "FOR_UPATE";
	
	
	private static String 	 SYNC_PUSH_TABLE_NOW_STATE 	 = null;
	private static String 	 SYNC_PUSH_TABLE_RUN_STATE 	 = null;
	private static String 	 SYNC_PUSH_TABLE_FREE_STATE  = null;
	
	static{
		SYNC_PUSH_TABLE_NOW_STATE 	= SqlManager.getQuery("MASS_UPDATE", "SYNC_PUSH_TABLE_NOW_STATE");
		SYNC_PUSH_TABLE_RUN_STATE 	= SqlManager.getQuery("MASS_UPDATE", "SYNC_PUSH_TABLE_RUN_STATE");
		SYNC_PUSH_TABLE_FREE_STATE  = SqlManager.getQuery("MASS_UPDATE", "SYNC_PUSH_TABLE_FREE_STATE");
	}
	
	public DbSynchroSwithing(TableInfo table){
		super();
		setTableInfo(table);
	}
	
	public DbSynchroSwithing(Properties tableInfo){
		super();
		this.tableInfo = tableInfo;
	}
	
	public void setTableInfo(TableInfo t){
		tableInfo = new Properties();
		tableInfo.setProperty(CODE_CODE,		t.getCodeCode());
		tableInfo.setProperty(COLUMN_NAME,		t.getColumnName());
		tableInfo.setProperty(RUN_STATE,		t.getColumnRunStateValue());
		tableInfo.setProperty(FREE_STATE,		t.getColumnFreeStateValue());
	}
	
	public synchronized void doLock() throws Exception {
        while (STATE) {
            try {
                wait();
            } catch (InterruptedException e) {
            	log.error("Interrupted error", e);
            	
            	//TODO suyongHan '"InterruptedException" should not be ignored'로 인해 추가
            	Thread.currentThread().interrupt();
            }while(true){
    			if(!isRunningState()){
    				wait(5000);
    				continue;
    			}
    			else break;
    		}
        }
        takingState();
		STATE = true;
	}
    
    public synchronized void unLock() throws Exception{
//    	if(!STATE) return;
    	freeState();
    	STATE = false;
    	this.notifyAll();
    }
	
	public boolean isRunningState(){
		tableInfo.setProperty(FOR_UPATE,		FOR_UPATE);
		Map result = new HashMap();
				
		EmsDbQuery.selectExecute(this.SYNC_PUSH_TABLE_NOW_STATE, tableInfo, result);
		
		return(tableInfo.getProperty("FREE_STATE").equals(result.get("STATE").toString()));
	}

	public void takingState() {
		EmsDbQuery.updateExecute(this.SYNC_PUSH_TABLE_RUN_STATE, tableInfo);
	}

	public void freeState() {
		EmsDbQuery.updateExecute(this.SYNC_PUSH_TABLE_FREE_STATE, tableInfo);
	}
	
}
