/*
 * @(#)UpdatorCheckTask.java            2016. 03. 25.
 *
 * Copyright (c) 1998-2011 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.log.updator;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import com.humuson.tms.constrants.ChannelType;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.AlreadyRegistTaskException;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;
import pluto.util.convert.StringConvert;


/**
 * Class description :
 * 
 * @version
 * @author bhkim
 * 
 */
@Slf4j
public class UpdatorCheckTask extends pluto.schedule.Task {
	
	private static final String _USE_OTHER_DB_ = "use.other.db";
	
	private static String MAX_THREAD_SIZE = "3";
	private static String ONE_THREAD_CNT = "1000";
	private static String ONE_INTERVAL_CNT = "1000";
	private static String channelType;
	private static String UPDATE_CLASS_NAME;
	private static String FATIGUE_CHECK_FLAG = "N";
	
	// Module Name
	private static String moduleName = null;
	
	/**
	 * 피로도관련 내용
	 */
	//private static String FATIGUE_CHECK_YN = "N";
	
	private static String querySelectListTableName = null;
	// 업데이트할 대상의 MIN /MAX SEQ를 가져오는 쿼리
	private static String queryListSelectTargetRange = null;
	
	protected eMsConnection emsConnection = null;
	protected eMsStatement selectSearchStatement = null;
	
	// 다른 DB를 사용할 것인지 판단
	private static boolean isUseOtherDb = false;
	private static ConnectInfo moduleConnectionInformation = new ConnectInfo();
	
	/**
	 * 구동에 필요한 기본 static 변수의 초기화
	 */
	static {
		try {
			moduleName = eMsSystem.getProperty("module.name","common_update");
			log.info("Module Name : {}",moduleName);
			querySelectListTableName = SqlManager.getQuery(moduleName.toUpperCase(), "QUERY_SELECT_TARGET_LIST_TABLE");
			queryListSelectTargetRange = SqlManager.getQuery(moduleName.toUpperCase(), "QUERY_SELECT_TARGET_RANGE");
		} catch(Exception e) {
			//e.printStackTrace();
			log.error("ERROR static variable setting.", e);
			System.exit(1);
		}
	}
	
	/** Creates a new instance of RealTimeCheckTask */
	public UpdatorCheckTask() {
		super(TYPE_INTERVAL);
		this.setName("UpdatorCheckTask_at_".concat(Cal.getSerialDate()));
		this.setTaskID("UpdatorCheckTask");
	}
	
	public static void init(Object tmp) throws Exception {
		Properties prop = (Properties) tmp;
		
		ONE_THREAD_CNT = prop.getProperty("one.thread.cnt","1000");//default size 1000.
		MAX_THREAD_SIZE = prop.getProperty("max.thread.size","10");//default size 10.
		ONE_INTERVAL_CNT = prop.getProperty("commit.interval.size","1000");//default size 1000.
		channelType = prop.getProperty("channel.type","");
		UPDATE_CLASS_NAME = prop.getProperty("update.class.name","");
		FATIGUE_CHECK_FLAG = prop.getProperty("fatigue.check.yn","N");
		
		isUseOtherDb = Boolean.parseBoolean(prop.getProperty(_USE_OTHER_DB_,"false"));
		
		if (channelType.equals(ChannelType.SMS.getCode())) {
			moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
			moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("sms.db.url"));
			moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("sms.db.id"));
			moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
			moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
			moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
			moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
			moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
		} else if (channelType.equals(ChannelType.KAKAO.getCode())) {
			moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
			moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
			moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
			moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
			moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
			moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
			moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
			moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
		} else {
			moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("other.db.driver"));
			moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("other.db.url"));
			moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("other.db.id"));
			moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("other.db.pass"));
			moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("other.db.init"));
			moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("other.db.base.charset"));
			moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("other.db.out.charset"));
			moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("other.db.in.charset"));
		}
	}
	
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("UpdatorCheckTask_at_".concat(Cal.getSerialDate()));
		
		log.info("UpdatorCheckTask_START");//for health check
		
		if (isUseOtherDb) {
			emsConnection = ConnectionPool.getConnection(moduleConnectionInformation);
		} else {
			emsConnection = ConnectionPool.getConnection();
		}
		
		try {
			selectSearchStatement = emsConnection.createStatement();
		} catch (Exception e) {
			log.error("create statement error", e);
			throw e;
		} finally {
			emsConnection = ConnectionPool.getConnection();
			selectSearchStatement = emsConnection.createStatement();			
		}
		//TODO suyongHan Exception 발생시 emsConnection 재연결 및 Statement 재생성 시도.
	}

	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error("{} Request Connection Error", getName(), thw);
	}

	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		if (emsConnection != null) {
			emsConnection.recycleStatement(selectSearchStatement);
			emsConnection.recycle();
		}
	}
	
	/**
	 * 실제적인 일을 처리하는 비지니스로직
	 * 
	 * @return true : 성공적인 수행 <br>
	 *         false : 수행 실패
	 */
	public void execute() throws Exception {
		
		// 수행할 쿼리가 없다면 종료한다.
		if (querySelectListTableName.isEmpty() ||
				queryListSelectTargetRange.isEmpty()) return ;
		
		List<String> listTables = new ArrayList<String>();	// 리스트 테이블명을 담는 변수
		Properties result = new Properties();
		
		eMsResultSet rsListTableName = null;
		eMsResultSet rs = null;
		
		try {
			
			rsListTableName = selectSearchStatement.executeQuery(querySelectListTableName);
			if (rsListTableName.next()) {
				String listTableName1 = null;
				String listTableName2 = null;
				
				if("KA".equalsIgnoreCase(channelType)){
					listTableName1 = rsListTableName.getString("LIST_TABLE1") == null ? "" : rsListTableName.getString("LIST_TABLE1");
					listTableName2 = rsListTableName.getString("LIST_TABLE2") == null ? "" : rsListTableName.getString("LIST_TABLE2");
				}else{
					listTableName1 = rsListTableName.getString("SMS_LIST_TABLE1") == null ? "" : rsListTableName.getString("SMS_LIST_TABLE1");
					listTableName2 = rsListTableName.getString("SMS_LIST_TABLE2") == null ? "" : rsListTableName.getString("SMS_LIST_TABLE2");
				}
				
				// 체크할 리스트 테이블명이 없다면 종료함.
				if (listTableName1.isEmpty() && listTableName2.isEmpty()) return ;
				
				if (listTableName1.equals(listTableName2)) {
					listTables.add(listTableName1);
				} else {
					listTables.add(listTableName1);
					listTables.add(listTableName2);
				}
			}
			
			if (listTables.isEmpty()) {
				log.debug("LIST TABLE NAME is empty.");
				return ;
			}

			StringBuffer buffer = new StringBuffer();
			Map<String,Properties> executions = new HashMap<>();
			for (String listTableName : listTables) {
				try {
					buffer.setLength(0);
					StringConvert.ConvertString(buffer, queryListSelectTargetRange, "${SMS_LIST_TABLE}", listTableName);
					
					if (log.isErrorEnabled())
						log.debug("QUERY_SELECT_TARGET_RANGE query: {}", buffer.toString());
					
					rs = selectSearchStatement.executeQuery(buffer.toString());
					if (rs.next()) {
						rs.putToMap(result, false);
					}
					
					if (result.isEmpty()) {
						log.warn("Get Target Range Result is empty.");
						continue ;
					}
					
					int totalCount = Integer.parseInt(result.getProperty("TO_CNT","0"));
					if (totalCount < 1) {
						log.warn("Get Target Range Result is zero.");
						continue ;
					}
					executions.putAll(getThreadInfo(result.getProperty("MIN_ID","0"), result.getProperty("MAX_ID","0"), listTableName));
					if (executions.isEmpty()) {
						log.warn("{} Update Execute Information is null.", getName());
						continue ;
					}
					
				} catch (Exception e) {
					log.error("execute error", e);
				} finally {
					if (rs != null) rs.close();
				}
			}
			log.info("executions size : {}" , executions.size());
			for (Map.Entry<String,Properties> exec : executions.entrySet()) {
				String key = exec.getKey();
				Properties value = exec.getValue();
				
				// 리스트 테이블명 셋팅.
				//value.setProperty("SMS_LIST_TABLE", listTableName);
				
				// 모듈이 다른 다른 디비에 존재할 경우
				value.setProperty("FATIGUE_CHECK_FLAG", FATIGUE_CHECK_FLAG);
				value.setProperty(_USE_OTHER_DB_, String.valueOf(isUseOtherDb));
				
				log.info("{} execute_createTask... KEY: {}, VALUE: {}", getName(), key, value);
				try {
					execute_createTask(value);
				} catch(Exception e) {
					log.error("[ERROR] execute_createTask...", e);
				}
			}
		} catch(Exception e) {
			//e.printStackTrace();
			log.error("[ERROR] Get Target Range.", e);
			throw e;
		} finally {
			if (rsListTableName != null) rsListTableName.close();
		}
		
		log.info("{} START is execute execute_createTask method...[OK]", getName());
	}

	/**
	 * 조건에 걸리는 녀석들을 집어 내어 MakeSendInfoTask 로 만들어 TaskManager에 등록을 한다. step :
	 * START 에서 실행 된다.
	 */
	private synchronized void execute_createTask(Properties info) throws Exception {
		try {
			
			Task make_info = (Task) getInstance(UPDATE_CLASS_NAME);
			/**
			 * 스케쥴을 초기화 한다.
			 */
			
			//전체 thread 완료 후 실행
			make_info.setTaskProperty(info);
			
			TaskManager.executeTask(make_info);
			try {
				wait(500);
			} catch(Exception e) {}
		} catch(AlreadyRegistTaskException e) {
			log.info("AlreadyRegistTaskException is skip {}", e.getMessage());
		} catch (Exception e) {
			log.error("{} executeTask error", UPDATE_CLASS_NAME, e);
		}
	}
	
	private Object getInstance(String className) throws Exception {
		return Class.forName(className).newInstance();
	}
	
	/**
	 * 
	 * 단일 thread로 변경 : 중복 select 가 발생 할 수 있음
	 * 
	 * @param min : 수행할 최소 seq
	 * @param max : 수행할 최대 seq
	 * @return	Hashtable : key - 스래드순번 , value - Properties (해당스래드의 min/max)
	 * @throws Exception
	 */
	private Map<String,Properties> getThreadInfo(String min , String max, String listTable) throws Exception {
		
		int processCountPerThread = Integer.parseInt(ONE_THREAD_CNT);	// 하나의 스래드가 수행할 최대건수
		
		int intervalCnt = Integer.parseInt(ONE_INTERVAL_CNT);
		
		long maxSeq = Long.parseLong(max);
		long minSeq = Long.parseLong(min);
		
		int range =  (int) (maxSeq - minSeq);	// 수행할 건수
		
		Map<String,Properties> selectInfo = new HashMap<String,Properties>();
		
		//남은 건수 
		int remain = range;
		
		//ex ) range(10000) / limitMaxProcessCnt 3000 
		if(remain > processCountPerThread){
			maxSeq = minSeq + processCountPerThread -1;
		}
			
		if (maxSeq != minSeq ) {
			Properties processInfo = new Properties();
			processInfo.setProperty("MAX_ID", Long.toString(maxSeq));
			processInfo.setProperty("MIN_ID", Long.toString(minSeq));
			processInfo.setProperty("CHECK_INTERVAL", Long.toString(intervalCnt));
			processInfo.setProperty("THREAD_ID", listTable);
			processInfo.setProperty("SMS_LIST_TABLE", listTable);
			selectInfo.put(listTable, processInfo);
		}
		return selectInfo;
	}
	
	//나눈 몫을 올림으로 구한다. (10000, 3) = 6
	private int divideCeil(int ramin, int processCount) {
		int val = 0;
		try {
			float leaves = (ramin % processCount);
			
			if (leaves > 0)
				val = (ramin / processCount) + 1;
			else
				val = ramin / processCount;
		} catch(Exception e) {
			return 0;
		}
		return val;
    }
	
	public static void main(String[] args) throws Exception{
		UpdatorCheckTask test = new UpdatorCheckTask();
		Map<String,Properties> executions = test.getThreadInfo("50000","70000","EM_MMS_LOG");
		for (Map.Entry<String,Properties> exec : executions.entrySet()) {
			String key = exec.getKey();
			Properties value = exec.getValue();
			System.out.println(value.toString());
		}
	}
}
