/*
 * Created on 2010. 8. 15.
 */
package jupiter.mass.log.updator;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

import com.humuson.tms.constrants.CommonType;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.Cal;
/**
 * @author  Sms UPDATE
 */
@Slf4j
public class SmsUpdator extends pluto.schedule.Task {
	
	/**
	 * 모듈 로그 테이블 가져온다.
	 */
	private String QUERY_SELECT_TARGET_SMS_LIST_TABLE = null;
	/**
	 *  결과셋을 가져오는 쿼리
	 */
	private String QUERY_TARGET_SMS_RESULT_QUERY = null;
	private String QUERY_TARGET_FATIGUE_RESULT_QUERY = null;
	
	public static String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
	public static String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = null;
	public String UPDATE_TMS_SMS_QUE_LOG = null;
	
	private String THREAD_ID = null;	
	
	private int LIMIT_SMS_UPDATE_CNT = 1000; 
	
	protected Hashtable<String,ScheduleTblBean> CAMP_SCHEDULE_PPT = new Hashtable<String,ScheduleTblBean>();	
	protected Hashtable<String,ScheduleTblBean> AUTO_SCHEDULE_PPT = new Hashtable<String,ScheduleTblBean>();
	
	/**
	 * 자동 SMS 관련 데이터를 담는 곳
	 */
	protected List<Properties> AUTO_TARGETLIST = null;
	//protected Hashtable<String,Properties> AUTO_TARGETLIST = null;
	/**
	 * 대량 SMS 관련 데이터를 담는 곳
	 */
	protected List<Properties> CAMP_TARGETLIST = null;
	/**
	 * 실패시 피로도 테이블 업데이트 로직 추가
	 */
	protected List<Properties> FATIGUE_CHECK_LIST = null;
	
	/**
	 * SMS table 에서 가져온 데이터 중 TMS에 업데이트 완료된 데이터를 담아놓았다가, ETC5의 값을 N->Y로 변경하는 데이터 
	 */
	protected List<Properties> SMS_TARGETLIST = null;
	
	private static ConnectInfo connectInfo = new ConnectInfo();
	
	// Module Name
	private static String moduleName = null;
	
	static {
		moduleName = eMsSystem.getProperty("module.name","common_update");
		connectInfo.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
		connectInfo.setDB_URL(eMsSystem.getProperty("sms.db.url"));
		connectInfo.setDB_UID(eMsSystem.getProperty("sms.db.id"));
		connectInfo.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
		connectInfo.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
		connectInfo.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
		connectInfo.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
		connectInfo.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
	}
	
	public SmsUpdator() {
		super();
		this.QUERY_SELECT_TARGET_SMS_LIST_TABLE = SqlManager.getQuery(moduleName.toUpperCase(), "QUERY_SELECT_TARGET_SMS_LIST_TABLE");
		this.QUERY_TARGET_SMS_RESULT_QUERY = SqlManager.getQuery(moduleName.toUpperCase(), "QUERY_TARGET_SMS_RESULT_QUERY");
		this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
		this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO");
		this.UPDATE_TMS_SMS_QUE_LOG	=SqlManager.getQuery(moduleName.toUpperCase(),"UPDATE_TMS_SMS_QUE_LOG");
		this.QUERY_TARGET_FATIGUE_RESULT_QUERY = SqlManager.getQuery("FATIGUE","QUERY_TARGET_FATIGUE_RESULT_QUERY");
		
		this.AUTO_TARGETLIST = new ArrayList<Properties>();
		this.CAMP_TARGETLIST = new ArrayList<Properties>();
		this.SMS_TARGETLIST = new ArrayList<Properties>();
		//피로도 관련 내용
		this.FATIGUE_CHECK_LIST = new ArrayList<Properties>();
	}
	
	public void setTaskProperty (Properties prop) {
		this.TASK_PROPERTY = prop;
		this.setName("SmsUpdator");
		this.setTaskID("SmsUpdator_" + this.TASK_PROPERTY.getProperty("THREAD_ID"));
		this.THREAD_ID = this.TASK_PROPERTY.getProperty("THREAD_ID");
		this.LIMIT_SMS_UPDATE_CNT = Integer.parseInt(this.TASK_PROPERTY.getProperty("CHECK_INTERVAL"));
	}
	
	/*
	 * @see pluto.push.module.PUSHCall#execute()
	 */
	public void execute() {
		if (log.isDebugEnabled()) {
			log.debug("CALL SmsUpdator===> execute()");
		}
		try {
			this.excute_init();
			// 자원 초기화
			this.execute_main();
		} catch(Throwable thw) {
			log.error("SmsUpdator CALL execute() ERROR", thw);
			//thw.printStackTrace();
		} finally {
			this.releaseResource();
		}
	}
	
	/**
	 * 초기화하면서 사용할 자원을 할당한다.
	 * @throws Throwable
	 *         초기화 에러.
	 */
	protected void excute_init() throws Throwable {
		if (log.isDebugEnabled()) {
			log.debug("CALL SmsUpdator===> execute_init()");
		}
		// DB 접속 Connection
	}

	/**
	 * 종료시 진행중 할당받은 자원을 반한다.
	 */
	protected void releaseResource() {
		if (log.isDebugEnabled()) {
			log.debug("CALL SMSUpdator===> releaseResource()");
		}
	}

	protected void execute_main() throws Throwable {
		if (log.isDebugEnabled()) {
			log.debug("CALL SMSUpdator===> execute_main()");
		}
		// 실제 업데이트 로직 수행.
		update_process(TASK_PROPERTY.getProperty("SMS_LIST_TABLE",""));
	}

	/**
	 * SMS 모듈 데이터를 각자 경우에 따라 분배시켜주는 로직
	 * @param list_table
	 * @throws Exception
	 */
	public void update_process(String list_table) throws Exception {
		
		log.debug("update_process start");
		eMsConnection moduleConnection = null;
		eMsStatement moduleSmsStmt = null;
		eMsResultSet moduleSmsResult = null;
		
		//생성 : auto / camp 관련 업데이트 
		SmsAutoUpdator autoUpt = new SmsAutoUpdator();
		SmsCampUpdator campUpt = new SmsCampUpdator();
		
		Properties resultQueryProp = new Properties();
		resultQueryProp.setProperty("SMS_LIST_TABLE", list_table);
		resultQueryProp.setProperty("MAX_ID", this.TASK_PROPERTY.getProperty("MAX_ID"));
		resultQueryProp.setProperty("MIN_ID", this.TASK_PROPERTY.getProperty("MIN_ID"));
		try {
			moduleConnection = ConnectionPool.getConnection(this.connectInfo);
			moduleSmsStmt = moduleConnection.createStatement();
			QUERY_TARGET_SMS_RESULT_QUERY = ppsParseSQL(QUERY_TARGET_SMS_RESULT_QUERY,"SMS_LIST_TABLE",list_table,"@{","}"); 
			moduleSmsResult = moduleSmsStmt.executeQuery(this.QUERY_TARGET_SMS_RESULT_QUERY, resultQueryProp, "${", "}");
			
			//AUTO 
			String currentList = "";
			String nextList = "";
			
			//CAMP
			String campCurrentList = "";
			String campNextList = "";
			while (moduleSmsResult.next()) {
				Properties smsSendResultValue = new Properties();
				smsSendResultValue.setProperty("SMS_LIST_TABLE", list_table);	
				
				moduleSmsResult.putToMap(smsSendResultValue, false);
				
				String postId = smsSendResultValue.getProperty("POST_ID").trim();
				String memberId = "";
				//Auto
				if (smsSendResultValue.getProperty("CHANNEL_TYPE").equals(CommonType.AUTO.getCode())) {
					// POST_ID => WORKDAY & SEQNO 로 분리
					int posPostId = postId.lastIndexOf("_");
					if (posPostId < 0) continue;
					
					String workDay = postId.substring(0, posPostId);   
					String seqNo = postId.substring(posPostId + 1);
					smsSendResultValue.setProperty("WORKDAY", workDay);
					smsSendResultValue.setProperty("SEQNO", seqNo);
					
					// MEMBER_ID 분리 => MEMBER_ID / MEMBER_ID_SEQ
					String tempMemberId = smsSendResultValue.getProperty("MEMBER_ID").trim();
					int posMemberId = tempMemberId.indexOf("_");
					if (posMemberId < 0) continue;
					if(currentList.equals("")){
						currentList = smsSendResultValue.getProperty("LIST_TABLE","");
					}
					nextList = smsSendResultValue.getProperty("LIST_TABLE","");
					memberId = tempMemberId.substring(0, posMemberId);
					String memberIdSeq = tempMemberId.substring(posMemberId + 1);
					smsSendResultValue.put("M_ID", memberId);
					smsSendResultValue.put("M_ID_SEQ", memberIdSeq);
					if(currentList.equals(nextList)){
						try {
							autoUpt.addTargetData(smsSendResultValue, list_table);
						} catch(Exception e) {
							continue;
						}
					}else{
						if(autoUpt.listTableBatchUpdate(currentList)>0){
						autoUpt.schdSummary();
						currentList = nextList;
						autoUpt.addTargetData(smsSendResultValue, list_table);
						}
					}
					if(autoUpt.getSize() > 0 && autoUpt.getSize()%LIMIT_SMS_UPDATE_CNT == 0){
						log.debug("LIMIT_SMS_UPDATE_CNT : {}", LIMIT_SMS_UPDATE_CNT);
							if(autoUpt.listTableBatchUpdate(currentList)>0){
							autoUpt.schdSummary();
							smsTableBatchUpdate(list_table);
							}
					}
					
				} else {
					if(campCurrentList.equals("")){
						log.debug("LIST_TABLE {}",smsSendResultValue.getProperty("LIST_TABLE",""));
						campCurrentList = smsSendResultValue.getProperty("LIST_TABLE","");
					}
					memberId = smsSendResultValue.getProperty("MEMBER_ID").trim();
					campNextList = smsSendResultValue.getProperty("LIST_TABLE","");
					if(campCurrentList.equals(campNextList)){
						try {
							campUpt.addTargetData(smsSendResultValue, list_table);
						} catch(Exception e) {
							continue;
						}
					}else{
						if(campUpt.listTableBatchUpdate(campCurrentList)>0){
						campUpt.schdSummary();
						smsTableBatchUpdate(list_table);
						campCurrentList = campNextList;
						campUpt.addTargetData(smsSendResultValue, list_table);
						}
					}
					if(campUpt.getSize() > 0 && campUpt.getSize()%LIMIT_SMS_UPDATE_CNT == 0){
						if(campUpt.listTableBatchUpdate(campCurrentList)>0){
						campUpt.schdSummary();
						smsTableBatchUpdate(list_table);
						}
					}
				}
				
				String FATIGUE_USE_YN = eMsSystem.getProperty("fatigue.yn","N");
				if ("Y".equals(FATIGUE_USE_YN)) {
					if(this.TASK_PROPERTY.getProperty("FATIGUE_CHECK_FLAG","N").equals("Y")){
						if(Integer.parseInt(smsSendResultValue.getProperty("FAIL_CNT")) >0){
							smsSendResultValue.setProperty("MEMBER_ID", memberId);
							smsSendResultValue.setProperty("FATIGUE_DATE", postId.substring(0,8));
							FATIGUE_CHECK_LIST.add(smsSendResultValue);
							if(FATIGUE_CHECK_LIST.size()%LIMIT_SMS_UPDATE_CNT == 0){
								fatigueTableBatchUpdate("DAY");
								fatigueTableBatchUpdate("MONTH");
								
							}
						}
					}
				}

				SMS_TARGETLIST.add(smsSendResultValue);
			}
			if(autoUpt.getSize()>0){
				autoUpt.listTableBatchUpdate(currentList);
				autoUpt.schdSummary();
			}
			if(campUpt.getSize()>0){
				campUpt.listTableBatchUpdate(campCurrentList);
				campUpt.schdSummary();
			}
			if(SMS_TARGETLIST.size()>0){
				smsTableBatchUpdate(list_table);
			}
		} catch(Exception e) {
			log.error("[ERROR] SmsUpdator update_process()", e);
		} finally {
			if(moduleSmsResult != null){
				moduleSmsResult.close();
			}
			if(moduleSmsStmt != null){
				moduleSmsStmt.close();
			}
			if(moduleConnection != null){
				moduleConnection.close();
			}
		}
	}
	
	public int smsTableBatchUpdate(String list_table) throws SQLException{
		//SMS pushed CNT = successCnt
		int successCnt = 0;
		eMsConnection emscon = null;
		eMsPreparedStatement batchPstmt = null;
		String query = "";
		try{
			emscon = ConnectionPool.getConnection(this.connectInfo);
			log.debug("UPDATE_TMS_SMS_QUE_LOG : {}", UPDATE_TMS_SMS_QUE_LOG);
			emscon.setAutoCommit(false);
			query =  ppsParseSQL(UPDATE_TMS_SMS_QUE_LOG,"SMS_LIST_TABLE",list_table,"@{","}"); 
			batchPstmt = emscon.prepareStatement(query, "${", "}");
			for(Properties prop : SMS_TARGETLIST){
				batchPstmt.addBatch(prop);
			}
			successCnt = batchPstmt.executeBatch().length;
		}catch(Exception e){
			log.error("batchUpdate error : {}" , e);
			emscon.rollback();
			for(Properties prop : SMS_TARGETLIST){
				try{
					batchPstmt.executeUpdate(prop);
					emscon.commit();
				}catch(Exception ex){
					log.error("batchUpdate oneToOne error : {}", ex);
				}
			}
		}finally{
			if(batchPstmt != null){
				emscon.recycleStatement(batchPstmt);
			}
			if(emscon != null){
				emscon.commit();
				emscon.setAutoCommit(true);
				emscon.recycle();
			}
			SMS_TARGETLIST.clear();
		}
		return successCnt;
	}
	public int fatigueTableBatchUpdate(String dateType) throws SQLException{
		//SMS pushed CNT = successCnt
		int successCnt = 0;
		eMsConnection emscon = null;
		eMsPreparedStatement batchPstmt = null;
		String query = "";
		try{
			emscon = ConnectionPool.getConnection();
			log.info("QUERY_TARGET_FATIGUE_RESULT_QUERY : {}", QUERY_TARGET_FATIGUE_RESULT_QUERY);
			emscon.setAutoCommit(false);
			query =  ppsParseSQL(QUERY_TARGET_FATIGUE_RESULT_QUERY,"FATIGUE_LIST",setFatigueTable(dateType),"@{","}"); 
			log.info("QUERY_TARGET_FATIGUE_RESULT_QUERY : {}", query);
			batchPstmt = emscon.prepareStatement(query, "${", "}");
			for(Properties prop : FATIGUE_CHECK_LIST){
				batchPstmt.addBatch(prop);
			}
			successCnt = batchPstmt.executeBatch().length;
		}catch(Exception e){
			log.error("batchUpdate error : {}" , e);
			emscon.rollback();
			for(Properties prop : FATIGUE_CHECK_LIST){
				try{
					batchPstmt.executeUpdate(prop);
					emscon.commit();
				}catch(Exception ex){
					log.error("batchUpdate oneToOne error : {}", ex);
				}
			}
		}finally{
			if(batchPstmt != null){
				emscon.recycleStatement(batchPstmt);
			}
			if(emscon != null){
				emscon.commit();
				emscon.setAutoCommit(true);
				emscon.recycle();
			}
			FATIGUE_CHECK_LIST.clear();
		}
		return successCnt;
	}
	
	public String setFatigueTable(String dateType){
		if(dateType.equals("DAY")){
			return  "TMS_FATIGUE_SMS_DAY_LIST";
		}else if(dateType.equals("MONTH")){
			return  "TMS_FATIGUE_SMS_MONTH_LIST";
		}
			return  "TMS_FATIGUE_SMS_LIST";
	}
	
	protected String ppsParseSQL(String source, String mapping, String value,String start, String end) {
		if( mapping == null || source == null )
			return source;

		return replace_target(source, start + mapping + end, value);
	}
	
	public static String replace_target(String target, String from, String to) {
		if( target == null || from == null || to == null )
			return null;

		int idx1 = 0;
		int idx2;

		while ((idx2 = target.indexOf(from, idx1)) != -1) {
			target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
			idx1 = idx2 + to.length();
		}
		return target;
	}
	
	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		// 반환할 자원이 없다.
	}
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("SmsUpdator_at_".concat(Cal.getSerialDate()));
	}
	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error("SmsUpdator init error", thw);
	}
	
	protected String getMonthListTableName(String month , String type){
		month = (month.length()==1)? "0"+ month: month;
		if(type.equals("AUTO")){
			return  "TMS_AUTO_SEND_LIST_"+month;
		}else{
			return  "TMS_CAMP_SEND_LIST_"+month;
		}
	}
	
}














