/*
 * Created on 2010. 8. 15.
 */
package jupiter.mass.log.updator;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;
/**
 * @author 에이메일  push UPDATE
 */
@Slf4j
public class SmsCampUpdator extends SmsUpdator {

	
	private static String 	CAMP_LIST_TABLE							= "TMS_CAMP_SEND_LIST_";
	static {
	}
	//리스트테이블 업데이트
	private String UPDATE_TMS_SMS_LIST_N;
	
	public SmsCampUpdator() {
		
		super();
		//LIST TABLE에 결과 값을 업데이트
		this.UPDATE_TMS_SMS_LIST_N 				= SqlManager.getQuery("MASS_UPDATE","UPDATE_TMS_SMS_LIST_N");
	}

	public void addTargetData(Properties smsSendResultValue , String list_table) throws Exception{
			smsSendResultValue.setProperty("CHECK_FLAG", "Y");
			smsSendResultValue.setProperty("SMS_LIST_TABLE", list_table);
			// 실패건수 처리...
			//1-1. TMS_PUSH_LIST ERROR_CODE UPDATE
			CAMP_TARGETLIST.add(smsSendResultValue);
	}
	public int listTableBatchUpdate(String list_table) throws SQLException{
		//SMS pushed CNT = successCnt
		int successCnt = 0;
		eMsConnection emscon = null;
		eMsPreparedStatement batchPstm = null;
		String query = "";
		try{
			emscon = ConnectionPool.getConnection();
			//TARGETLIST_01
			query =  ppsParseSQL(UPDATE_TMS_SMS_LIST_N,"LIST_TABLE",list_table,"@{","}"); 
			log.debug("query {}", query);
			batchPstm = emscon.prepareStatement(query,"${","}");
			emscon.setAutoCommit(false);
			for(Properties prop : CAMP_TARGETLIST){
				addSchdUpdateData(prop.getProperty("POST_ID").trim(),prop);
				batchPstm.addBatch(prop);
			}
			successCnt = batchPstm.executeBatch().length;
		}catch(Exception e){
			log.error("batchUpdate error : {}" , e);
			emscon.rollback();
			CAMP_SCHEDULE_PPT.clear();
			for(Properties prop : CAMP_TARGETLIST){
				try{
					addSchdUpdateData(prop.getProperty("POST_ID").trim(),prop);
					batchPstm.executeUpdate(prop);
					emscon.commit();
				}catch(Exception ex){
					log.error("batchUpdate oneToOne error : {}", ex);
				}
			}
		}finally{
			if(batchPstm != null){
				emscon.recycleStatement(batchPstm);
			}
			if(emscon != null){
				emscon.commit();
				emscon.setAutoCommit(true);
				emscon.recycle();
			}
			CAMP_TARGETLIST.clear();
		}
		log.info("success cnt : {}", successCnt );
		return successCnt;
	}
	
	public void schdSummary(){
		ScheduleTblBean stBean = null;
		StringBuffer buff = new StringBuffer(512);
		int result = 0;
		
		eMsConnection emscon = null;
		eMsStatement stmt = null;
		try{
			emscon = ConnectionPool.getConnection();
			stmt = emscon.createStatement();
			Enumeration e = CAMP_SCHEDULE_PPT.elements();
			while(e.hasMoreElements()){
				result = 0;
				
				stBean = (ScheduleTblBean)e.nextElement();
				buff.setLength(0);
				if (log.isDebugEnabled()) {
					log.debug("[stBean content]\n\t"+stBean.toString());
				}
					StringConvertUtil.ConvertString( buff , QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY , stBean.getElement("CAMP") , "${" , "}" , true , false );
				result = stmt.executeUpdate(buff.toString());
				if(result<	1){
					log.debug("[SCHEDULE SUMMARY FAIL]:"+stBean.getName());
				}
			}
		}catch(Exception e){
			
		}finally{
			if(stmt != null){
				emscon.recycleStatement(stmt);
			}
			if(emscon != null){
				emscon.recycle();
			}
			
			buff.setLength(0);
			buff = null;
			CAMP_SCHEDULE_PPT.clear();
		}
	}
	
	public void addSchdUpdateData(String postId, Properties prop){
		ScheduleTblBean campStBean = super.CAMP_SCHEDULE_PPT.get(postId);
		if (campStBean == null) {
			campStBean = new ScheduleTblBean(postId);
			super.CAMP_SCHEDULE_PPT.put(postId, campStBean);
		}
		int failCnt = Integer.parseInt(prop.getProperty("FAIL_CNT"));
		if (failCnt > 0) {
			campStBean.addFailCnt();
			campStBean.addErrorCnt(prop.getProperty("ERROR_CODE"));
		}	
		campStBean.addPush();
	}
	
	public int getSize(){
		return CAMP_TARGETLIST.size();
	}
	
}// end class
