/*
 * Created on 2010. 8. 15.
 */
package jupiter.mass.log.updator;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;
/**
 * @author 에이메일  push UPDATE
 */
@Slf4j
public class SmsAutoUpdator extends SmsUpdator {

	
	private static String 	AUTO_LIST_TABLE							= "TMS_AUTO_SEND_LIST_";
	//private static ConnectInfo	TARGET_CONNECT_INFO					= null;

	static {
	}
	//private eMsPreparedStatement 	SMS_QUE_LOG_PSTMT  					= null;
	
	//리스트테이블 업데이트
	/**
	 *	list table 결과값 업데이트
	 */
	private String UPDATE_TMS_SMS_LIST_N;
	
	public SmsAutoUpdator() {
		super();
		this.UPDATE_TMS_SMS_LIST_N 				= SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_SMS_LIST_N");
	}

	public int listTableBatchUpdate(String list_table) throws SQLException{
		//SMS pushed CNT = successCnt
		int successCnt = 0;
		eMsConnection emscon = null;
		eMsPreparedStatement batchPstm = null;
		String query = "";
		try{
			emscon = ConnectionPool.getConnection();
			//TARGETLIST_01
			query =  ppsParseSQL(UPDATE_TMS_SMS_LIST_N,"LIST_TABLE",list_table,"@{","}"); 
			log.debug("query {}", query);
			batchPstm = emscon.prepareStatement(query,"${","}");
			emscon.setAutoCommit(false);
			for(Properties prop : AUTO_TARGETLIST){
				addSchdUpdateData(prop.getProperty("POST_ID").trim(),prop);
				batchPstm.addBatch(prop);
			}
			successCnt = batchPstm.executeBatch().length;
		}catch(Exception e){
			log.error("batchUpdate error : {}" , e);
			emscon.rollback();
			AUTO_SCHEDULE_PPT.clear();
			for(Properties prop : AUTO_TARGETLIST){
				try{
					addSchdUpdateData(prop.getProperty("POST_ID").trim(),prop);
					batchPstm.executeUpdate(prop);
					emscon.commit();
				}catch(Exception ex){
					log.error("batchUpdate oneToOne error : {}", ex);
				}
			}
		}finally{
			if(batchPstm != null){
				emscon.recycleStatement(batchPstm);
			}
			if(emscon != null){
				emscon.commit();
				emscon.setAutoCommit(true);
				emscon.recycle();
			}
			AUTO_TARGETLIST.clear();
		}
		log.info("success cnt : {}", successCnt );
		return successCnt;
	}
	
	public void addSchdUpdateData(String postId, Properties prop){
		ScheduleTblBean autoStBean = super.AUTO_SCHEDULE_PPT.get(postId);
		if (autoStBean == null) {
			autoStBean = new ScheduleTblBean(postId);
			super.AUTO_SCHEDULE_PPT.put(postId, autoStBean);
		}
		int failCnt = Integer.parseInt(prop.getProperty("FAIL_CNT"));
		if (failCnt > 0) {
			autoStBean.addFailCnt();
			autoStBean.addErrorCnt(prop.getProperty("ERROR_CODE"));
		}	
		autoStBean.addPush();
	}
	
	public int getSize(){
		return AUTO_TARGETLIST.size();
	}
	
	public void addTargetData(Properties smsSendResultValue , String list_table) throws Exception{
			String postId = smsSendResultValue.getProperty("POST_ID");
			String memberId = smsSendResultValue.getProperty("MEMBER_ID");
			smsSendResultValue.setProperty("CHECK_FLAG", "Y");
			smsSendResultValue.setProperty("SMS_LIST_TABLE", list_table);
			postId = smsSendResultValue.getProperty("POST_ID");
			//POST_ID => WORKDAY & SEQNO 로 분리
			int posPostid = postId.lastIndexOf("_");
			String workDay = postId.substring(0, posPostid);
			String seqNo = postId.substring(posPostid+1);
			smsSendResultValue.setProperty("WORKDAY", workDay);
			smsSendResultValue.setProperty("SEQNO", seqNo);
			
			// member_id에 ^가 있을 경우 재발송
			if(memberId.lastIndexOf("*") > 0){
				// M_ID & WORK_SEQ 분리 M_ID=10234567^2  
				int pos = memberId.lastIndexOf("*");
				int pos2 = memberId.lastIndexOf("_");
				
				String mId = memberId.substring(0, pos2);
				String mIdSeq = memberId.substring(pos2+1, pos);
				String workSeq = memberId.substring(pos+1);
				
				smsSendResultValue.setProperty("M_ID", mId);
				smsSendResultValue.setProperty("WORK_SEQ", workSeq);
				smsSendResultValue.setProperty("M_ID_SEQ", mIdSeq);
				//resend 부분
			}else{
				int pos = memberId.lastIndexOf("_");
				String mId = memberId.substring(0, pos);
				String mIdSeq = memberId.substring(pos+1);
				smsSendResultValue.setProperty("M_ID", mId);
				smsSendResultValue.setProperty("M_ID_SEQ", mIdSeq);
			}
			AUTO_TARGETLIST.add(smsSendResultValue);
	}
	
	public void schdSummary(){
		ScheduleTblBean stBean = null;
		StringBuffer buff = new StringBuffer(512);
		int result = 0;
		
		eMsConnection emscon = null;
		eMsStatement stmt = null;
		try{
			emscon = ConnectionPool.getConnection();
			stmt = emscon.createStatement();
			Enumeration e = AUTO_SCHEDULE_PPT.elements();
			while(e.hasMoreElements()){
				result = 0;
				
				stBean = (ScheduleTblBean)e.nextElement();
				buff.setLength(0);
				if (log.isDebugEnabled()) {
					log.debug("[stBean content]\n\t"+stBean.toString());
				}
					StringConvertUtil.ConvertString( buff , QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO , stBean.getElement("AUTO") , "${" , "}" , true , false );
				result = stmt.executeUpdate(buff.toString());
				if(result<	1){
					log.debug("[SCHEDULE SUMMARY FAIL]:"+stBean.getName());
				}
			}
		}catch(Exception e){
			
		}finally{
			if(stmt != null){
				emscon.recycleStatement(stmt);
			}
			if(emscon != null){
				emscon.recycle();
			}
			
			buff.setLength(0);
			buff = null;
			AUTO_SCHEDULE_PPT.clear();
		}
	}
	
}// end class
