package jupiter.mass.log.updator;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ScheduleTblBean {
	
	public String 	POST_ID = "";
	public int 		PUSHED_CNT	= 0;
	
	public int 		FAIL_CNT	= 0;
	public int 		OPEN_CNT	= 0;
	public int 		CLICK_CNT	= 0;
	
	public int 		TYPE_05_ERROR =0;
	public int 		TYPE_10_ERROR =0;
	public int 		TYPE_15_ERROR =0;	
	public int 		TYPE_20_ERROR =0;
	public int 		TYPE_25_ERROR =0;
	public int 		TYPE_30_ERROR =0;
	public int 		TYPE_35_ERROR =0;
	public int 		TYPE_40_ERROR =0;
	public int 		TYPE_45_ERROR =0;
	public int 		TYPE_50_ERROR =0;
	public int 		TYPE_55_ERROR =0;
	public int 		TYPE_60_ERROR =0;
	public int 		TYPE_65_ERROR =0;
	public int 		TYPE_70_ERROR =0;
	public int 		TYPE_75_ERROR =0;
	public int 		TYPE_80_ERROR =0;
	public int 		TYPE_85_ERROR =0;
	public int 		TYPE_90_ERROR =0;
	public int 		TYPE_95_ERROR =0;
	public int 		TYPE_99_ERROR =0;
	
	//SMS
	public int TYPE_01_ERROR =0;
	public int TYPE_02_ERROR =0;
	public int TYPE_03_ERROR =0;
	public int TYPE_04_ERROR =0;
	
	public int TYPE_06_ERROR =0;
	public int TYPE_07_ERROR =0;
	public int TYPE_08_ERROR =0;
	public int TYPE_09_ERROR =0;
	
	public int TYPE_11_ERROR =0;
	public int TYPE_12_ERROR =0;
	public int TYPE_13_ERROR =0;
	public int TYPE_14_ERROR =0;
	
	public int TYPE_16_ERROR =0;
	public int TYPE_17_ERROR =0;
	public int TYPE_18_ERROR =0;
	public int TYPE_19_ERROR =0;
	
	public int TYPE_21_ERROR =0;
	public int TYPE_22_ERROR =0;
	public int TYPE_23_ERROR =0;
	public int TYPE_24_ERROR =0;

	public int TYPE_26_ERROR =0;
	public int TYPE_27_ERROR =0;
	public int TYPE_28_ERROR =0;
	public int TYPE_29_ERROR =0;
	
	private int switchedCnt = 0;
	// 2019.01.02 알림톡 업데이트 문자전환실패 카운터 추가로 인한 수정  by kwj
	private int switchedFailCnt = 0;
	
	public String toString(){
		return "["+POST_ID+"] PUSHED_CNT:"+PUSHED_CNT+",FAIL_CNT:"+FAIL_CNT+"\n"
				+",TYPE_05_ERROR:"+TYPE_05_ERROR+",TYPE_10_ERROR:"+TYPE_10_ERROR+"\n"
				+",TYPE_15_ERROR:"+TYPE_15_ERROR+",TYPE_20_ERROR:"+TYPE_20_ERROR+"\n"
				+",TYPE_25_ERROR:"+TYPE_25_ERROR+",TYPE_30_ERROR:"+TYPE_30_ERROR+"\n"
				+",TYPE_35_ERROR:"+TYPE_35_ERROR+",TYPE_40_ERROR:"+TYPE_40_ERROR+"\n"
				+",TYPE_45_ERROR:"+TYPE_45_ERROR+",TYPE_50_ERROR:"+TYPE_50_ERROR+"\n"
				+",TYPE_55_ERROR:"+TYPE_55_ERROR+",TYPE_60_ERROR:"+TYPE_60_ERROR+"\n"
				+",TYPE_65_ERROR:"+TYPE_65_ERROR+",TYPE_70_ERROR:"+TYPE_70_ERROR+"\n"
				+",TYPE_75_ERROR:"+TYPE_75_ERROR+",TYPE_80_ERROR:"+TYPE_80_ERROR+"\n"
				+",TYPE_85_ERROR:"+TYPE_85_ERROR+",TYPE_90_ERROR:"+TYPE_90_ERROR+"\n"
				+",TYPE_95_ERROR:"+TYPE_95_ERROR+",TYPE_99_ERROR:"+TYPE_99_ERROR+"\n"
				+",SWITCHED_CNT:"+switchedCnt+"\n";
				
	}
	
	public ScheduleTblBean(String post_id){
		this.POST_ID = post_id;
	}
	
	public String getName(){
		return POST_ID;
	}
	
	
	public Properties getElement(String engine_type){
		Properties ppt = new Properties();
		
		if(engine_type.equals("AUTO")){
			ppt.setProperty("WORKDAY", POST_ID.substring(0, 8));
			ppt.setProperty("SEQNO", POST_ID.substring(9, POST_ID.length()));
			
		}
		ppt.setProperty("POST_ID", POST_ID);
		ppt.setProperty("PUSHED_CNT", ""+PUSHED_CNT);
		ppt.setProperty("FAIL_CNT", ""+FAIL_CNT);
		ppt.setProperty("OPEN_CNT", ""+OPEN_CNT);
		ppt.setProperty("CLICK_CNT", ""+CLICK_CNT);
		ppt.setProperty("SWITCHED_CNT", String.valueOf(switchedCnt));
		ppt.setProperty("SWITCHED_FAIL_CNT", String.valueOf(switchedFailCnt));
		ppt.setProperty("ERROR_05_CNT", ""+TYPE_05_ERROR);
		ppt.setProperty("ERROR_10_CNT", ""+TYPE_10_ERROR);
		ppt.setProperty("ERROR_15_CNT", ""+TYPE_15_ERROR);
		ppt.setProperty("ERROR_20_CNT", ""+TYPE_20_ERROR);
		ppt.setProperty("ERROR_25_CNT", ""+TYPE_25_ERROR);
		ppt.setProperty("ERROR_30_CNT", ""+TYPE_30_ERROR);
		ppt.setProperty("ERROR_35_CNT", ""+TYPE_35_ERROR);
		ppt.setProperty("ERROR_40_CNT", ""+TYPE_40_ERROR);
		ppt.setProperty("ERROR_45_CNT", ""+TYPE_45_ERROR);
		ppt.setProperty("ERROR_50_CNT", ""+TYPE_50_ERROR);
		ppt.setProperty("ERROR_55_CNT", ""+TYPE_55_ERROR);
		ppt.setProperty("ERROR_60_CNT", ""+TYPE_60_ERROR);
		ppt.setProperty("ERROR_65_CNT", ""+TYPE_65_ERROR);
		ppt.setProperty("ERROR_70_CNT", ""+TYPE_70_ERROR);
		ppt.setProperty("ERROR_75_CNT", ""+TYPE_75_ERROR);
		ppt.setProperty("ERROR_80_CNT", ""+TYPE_80_ERROR);
		ppt.setProperty("ERROR_85_CNT", ""+TYPE_85_ERROR);
		ppt.setProperty("ERROR_90_CNT", ""+TYPE_90_ERROR);
		ppt.setProperty("ERROR_95_CNT", ""+TYPE_95_ERROR);
		ppt.setProperty("ERROR_99_CNT", ""+TYPE_99_ERROR);
		
		ppt.setProperty("ERROR_01_CNT", ""+TYPE_01_ERROR);
		ppt.setProperty("ERROR_02_CNT", ""+TYPE_02_ERROR);
		ppt.setProperty("ERROR_03_CNT", ""+TYPE_03_ERROR);
		ppt.setProperty("ERROR_04_CNT", ""+TYPE_04_ERROR);
		
		ppt.setProperty("ERROR_06_CNT", ""+TYPE_06_ERROR);
		ppt.setProperty("ERROR_07_CNT", ""+TYPE_07_ERROR);
		ppt.setProperty("ERROR_08_CNT", ""+TYPE_08_ERROR);
		ppt.setProperty("ERROR_09_CNT", ""+TYPE_09_ERROR);
		
		ppt.setProperty("ERROR_11_CNT", ""+TYPE_11_ERROR);
		ppt.setProperty("ERROR_12_CNT", ""+TYPE_12_ERROR);
		ppt.setProperty("ERROR_13_CNT", ""+TYPE_13_ERROR);
		ppt.setProperty("ERROR_14_CNT", ""+TYPE_14_ERROR);

		ppt.setProperty("ERROR_16_CNT", ""+TYPE_16_ERROR);
		ppt.setProperty("ERROR_17_CNT", ""+TYPE_17_ERROR);
		ppt.setProperty("ERROR_18_CNT", ""+TYPE_18_ERROR);
		ppt.setProperty("ERROR_19_CNT", ""+TYPE_19_ERROR);
		
		ppt.setProperty("ERROR_21_CNT", ""+TYPE_21_ERROR);
		ppt.setProperty("ERROR_22_CNT", ""+TYPE_22_ERROR);
		ppt.setProperty("ERROR_23_CNT", ""+TYPE_23_ERROR);
		ppt.setProperty("ERROR_24_CNT", ""+TYPE_24_ERROR);

		ppt.setProperty("ERROR_26_CNT", ""+TYPE_26_ERROR);
		ppt.setProperty("ERROR_27_CNT", ""+TYPE_27_ERROR);
		ppt.setProperty("ERROR_28_CNT", ""+TYPE_28_ERROR);
		ppt.setProperty("ERROR_29_CNT", ""+TYPE_29_ERROR);
		return ppt;
	}
	
	
	public void addPush(){
		if(log.isDebugEnabled()){log.debug("["+this.getName()+"  add push cnt]");}
		PUSHED_CNT++;
	}
	
	public void addFailCnt(){
		if(log.isDebugEnabled()){log.debug("["+this.getName()+"  add fail cnt]");}
		FAIL_CNT++;
	}
	
	public void addOpenCnt(){
		if(log.isDebugEnabled()){log.debug("["+this.getName()+"  add open cnt]");}
		OPEN_CNT++;
	}
	
	public void addClickCnt(){
		if(log.isDebugEnabled()){log.debug("["+this.getName()+"  add click cnt]");}
		CLICK_CNT++;
	}
	
	public void addErrorCnt(String t_code){
		if(log.isDebugEnabled()){log.debug("["+this.getName()+"  add error cnt] code:"+t_code);}
		
		int code = Integer.parseInt(t_code);
		switch (code){ 
			case 05: TYPE_05_ERROR ++; break;
			case 10: TYPE_10_ERROR ++; break;
			case 15: TYPE_15_ERROR ++; break;
			case 20: TYPE_20_ERROR ++; break;
			case 25: TYPE_25_ERROR ++; break;
			case 30: TYPE_30_ERROR ++; break;
			case 35: TYPE_35_ERROR ++; break;
			case 40: TYPE_40_ERROR ++; break;
			case 45: TYPE_45_ERROR ++; break;
			case 50: TYPE_50_ERROR ++; break;
			case 55: TYPE_55_ERROR ++; break;
			case 60: TYPE_60_ERROR ++; break;
			case 65: TYPE_65_ERROR ++; break;
			case 70: TYPE_70_ERROR ++; break;
			case 75: TYPE_75_ERROR ++; break;
			case 80: TYPE_80_ERROR ++; break;
			case 85: TYPE_85_ERROR ++; break;
			case 90: TYPE_90_ERROR ++; break;
			case 95: TYPE_95_ERROR ++; break;
			case 99: TYPE_99_ERROR ++; break;	
			
			case 1: TYPE_01_ERROR ++; break;
			case 2: TYPE_02_ERROR ++; break;
			case 3: TYPE_03_ERROR ++; break;
			case 4: TYPE_04_ERROR ++; break;
	
			case 6: TYPE_06_ERROR ++; break;
			case 7: TYPE_07_ERROR ++; break;
			case 8: TYPE_08_ERROR ++; break;
			case 9: TYPE_09_ERROR ++; break;
			
			case 11: TYPE_11_ERROR ++; break;
			case 12: TYPE_12_ERROR ++; break;
			case 13: TYPE_13_ERROR ++; break;
			case 14: TYPE_14_ERROR ++; break;
			
			case 16: TYPE_16_ERROR ++; break;
			case 17: TYPE_17_ERROR ++; break;
			case 18: TYPE_18_ERROR ++; break;
			case 19: TYPE_19_ERROR ++; break;
			
			case 21: TYPE_21_ERROR ++; break;
			case 22: TYPE_22_ERROR ++; break;
			case 23: TYPE_23_ERROR ++; break;
			case 24: TYPE_24_ERROR ++; break;
			
			case 26: TYPE_26_ERROR ++; break;
			case 27: TYPE_27_ERROR ++; break;
			case 28: TYPE_28_ERROR ++; break;
			case 29: TYPE_29_ERROR ++; break;
			
			default: TYPE_99_ERROR ++; break;	
		}			
	}
	
	public void minusErrorCnt(String t_code){
		if(log.isDebugEnabled()){log.debug("["+this.getName()+"  minus error cnt] code:"+t_code);}
		
		int code = Integer.parseInt(t_code);
		switch (code){ 
		case 05: TYPE_05_ERROR --; break;
		case 10: TYPE_10_ERROR --; break;
		case 15: TYPE_15_ERROR --; break;
		case 20: TYPE_20_ERROR --; break;
		case 25: TYPE_25_ERROR --; break;
		case 30: TYPE_30_ERROR --; break;
		case 35: TYPE_35_ERROR --; break;
		case 40: TYPE_40_ERROR --; break;
		case 45: TYPE_45_ERROR --; break;
		case 50: TYPE_50_ERROR --; break;
		case 55: TYPE_55_ERROR --; break;
		case 60: TYPE_60_ERROR --; break;
		case 65: TYPE_65_ERROR --; break;
		case 70: TYPE_70_ERROR --; break;
		case 75: TYPE_75_ERROR --; break;
		case 80: TYPE_80_ERROR --; break;
		case 85: TYPE_85_ERROR --; break;
		case 90: TYPE_90_ERROR --; break;
		case 95: TYPE_95_ERROR --; break;
		case 99: TYPE_99_ERROR --; break;	
		
		case 1: TYPE_01_ERROR --; break;
		case 2: TYPE_02_ERROR --; break;
		case 3: TYPE_03_ERROR --; break;
		case 4: TYPE_04_ERROR --; break;

		case 6: TYPE_06_ERROR --; break;
		case 7: TYPE_07_ERROR --; break;
		case 8: TYPE_08_ERROR --; break;
		case 9: TYPE_09_ERROR --; break;
		
		case 11: TYPE_11_ERROR --; break;
		case 12: TYPE_12_ERROR --; break;
		case 13: TYPE_13_ERROR --; break;
		case 14: TYPE_14_ERROR --; break;
	
		case 16: TYPE_16_ERROR --; break;
		case 17: TYPE_17_ERROR --; break;
		case 18: TYPE_18_ERROR --; break;
		case 19: TYPE_19_ERROR --; break;
		
		case 21: TYPE_21_ERROR --; break;
		case 22: TYPE_22_ERROR --; break;
		case 23: TYPE_23_ERROR --; break;
		case 24: TYPE_24_ERROR --; break;
		
		case 26: TYPE_26_ERROR --; break;
		case 27: TYPE_27_ERROR --; break;
		case 28: TYPE_28_ERROR --; break;
		case 29: TYPE_29_ERROR --; break;
		
		default: TYPE_99_ERROR --; break;
		}			
	}	
	
	public void minusFailCnt(){
		if(log.isDebugEnabled()){log.debug("["+this.getName()+"  add fail cnt]");}
		FAIL_CNT--;			
	}
	
	public void compErrorCnt(String minus_code, String add_code){
		minusErrorCnt(minus_code);
		addErrorCnt(add_code);			
	}
	
	public void addSwitchedCnt() {
		this.switchedCnt++;
	}
	
	public void addSwitchedFailCnt() {
		this.switchedFailCnt++;
	}
}
