/*
 * @(#)ResendLogUpdator.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.mass.log.updator;

import java.util.List;
import java.util.Properties;

import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;
import lombok.extern.slf4j.Slf4j;
/**
 * Class description :
 * 
 * @version		
 * @author 		lena
 *
 */
@Slf4j
public class ResendLogUpdator extends LogUpdatorImpl  {
	
	
	protected static List QUERY_UPDATE_START = null;
	

	protected static List QUERY_UPDATE_SUCCESS = null;
	
	protected static List QUERY_UPDATE_FAIL = null;
	
	static{
		try{
			/**기본 업데이트하는 녀석들 */
			QUERY_UPDATE_START = SqlManager.getMultiQuery("PERSONAL_RESEND","QUERY_UPDATE_START");
			
			QUERY_UPDATE_SUCCESS = SqlManager.getMultiQuery("PERSONAL_RESEND","QUERY_UPDATE_SUCCESS");
			
			QUERY_UPDATE_FAIL = SqlManager.getMultiQuery("PERSONAL_RESEND","QUERY_UPDATE_FAIL");
		} catch (Exception e){
			log.error("query error", e.getMessage());
			System.exit(1);
		}
	}
	
	
	
	/** Creates a new instance of ResendLogUpdator */
	public ResendLogUpdator() {
		setName( "ResendLogUpdator" );
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	/** 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object obj) throws Exception {
		Properties __LOG_DATA__ = ( Properties )obj;
		
		String __T_TYPE__ = __LOG_DATA__.getProperty( LOG_T_TYPE );
		String __T_CODE__ = __LOG_DATA__.getProperty( LOG_T_CODE );
		
		// M_ID & WORK_SEQ 분리 M_ID=10234567^2  
		__LOG_DATA__.setProperty("M_ID", __LOG_DATA__.getProperty("M_ID"));
		__LOG_DATA__.setProperty("WORK_SEQ", __LOG_DATA__.getProperty("WORK_SEQ"));
		
		/**54-00 메일발송시작 업데이트
		 */
		if(__T_TYPE__.equals("54") && __T_CODE__.equals("--") ) {
			executeUpdateList( QUERY_UPDATE_START , __LOG_DATA__ );
			
			return "START";
		}
		
		
		/**54-10 발송성공에 대한 업데이트
		 */
		if(__T_TYPE__.equals("54") && __T_CODE__.equals("00") ) {
			/**성공에 대한 업데이트
			 */
			executeUpdateList( QUERY_UPDATE_SUCCESS , __LOG_DATA__ );
			
			return "SUCCESS OK";
		}
		
		/** 자 ... 에러가 발생을 했습니다.
		 */
		if(__T_TYPE__.equals("55")) {
			/**실패에 대한 업데이트
			 */
			executeUpdateList( QUERY_UPDATE_FAIL , obj );
			
			return "ERROR OK";
		}
		return "NO UPDATE";
	}
}

