/*
 * Created on 2010. 8. 15.
 */
package jupiter.mass.log.updator;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
/**
 * @author  push UPDATE
 */
@Slf4j
public class PushUpdator extends pluto.schedule.Task {

	static {
	}

	private eMsConnection			SOURCE_CONNECTION								= null;

	private eMsStatement			TMS_PUSH_SELECT_STMT							= null;
	private eMsStatement			MODULE_PUSH_SELECT_STMT							= null;	
	private eMsStatement			MODULE_PUSH_UPDATE_STMT							= null;
	/**
	 * 모듈 로그 테이블 가져온다.
	 */
	private String					QUERY_SELECT_TARGET_PUSH_LIST_TABLE 			= null;
	/**
	 *  결과셋을 가져오는 쿼리
	 */
	private String					QUERY_TARGET_PUSH_RESULT_QUERY					= null;
	
	private String					QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY		= null;
	private String					QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO	= null;
	
	private String					THREAD_ID										= null;	
	
	private Hashtable 				CAMP_SCHEDULE_PPT 								= new Hashtable();	
	private Hashtable 				AUTO_SCHEDULE_PPT 								= new Hashtable();
	private Hashtable 				PPS_LIST 										= new Hashtable();
	
	
	public static final String OPEN_TYPE 		= "R";
	public static final String CLICK_TYPE 		= "C";
	
	public PushUpdator() {
		super();
		this.QUERY_SELECT_TARGET_PUSH_LIST_TABLE 			= SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_PUSH_LIST_TABLE");
		this.QUERY_TARGET_PUSH_RESULT_QUERY 				= SqlManager.getQuery("COMMON_UPDATE", "QUERY_TARGET_PUSH_RESULT_QUERY");
		this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY 		= SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
		this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO 	= SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO");
		
	
	}

	public void setTaskProperty( Properties prop ) {
		this.TASK_PROPERTY = prop;
		this.setName("PushUpdator" );
		this.setTaskID("PushUpdator_"+this.TASK_PROPERTY.getProperty("THREAD_ID") );
		this.THREAD_ID = this.TASK_PROPERTY.getProperty("THREAD_ID");	
	}
	
	/*
	 * @see pluto.push.module.PUSHCall#execute()
	 */
	public void execute() {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushUpdator===> execute()");
		}
		try {
			// 자원 초기화
			this.execute_init();
			// 메인 프로세스
			this.execute_main();
		}
		catch(Throwable thw) {
			log.error("PushUpdator", "CALL execute() ERROR", thw);
		}
		finally {
			// 자원반환.
			this.releaseResource();
		}
	}
	
	protected String getMonthListTableName(String month , String type){
		month = (month.length()==1)? "0"+ month: month;
		if("AUTO".equals(type)){
			return  "TMS_AUTO_SEND_LIST_"+month;
		}else{
			return  "TMS_CAMP_SEND_LIST_"+month;
		}
	}
	
	/**
	 * 초기화하면서 사용할 자원을 할당한다.
	 * @throws Throwable
	 *         초기화 에러.
	 */
	protected void execute_init() throws Throwable {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushUpdator===> execute_init()");
		}
		//eMs DB 접속 Connection
		this.SOURCE_CONNECTION = ConnectionPool.getConnection();		
		
		CAMP_SCHEDULE_PPT.clear();	
		AUTO_SCHEDULE_PPT.clear();

		this.TMS_PUSH_SELECT_STMT      	  = this.SOURCE_CONNECTION.createStatement();
		this.MODULE_PUSH_SELECT_STMT      = this.SOURCE_CONNECTION.createStatement();
		this.MODULE_PUSH_UPDATE_STMT      = this.SOURCE_CONNECTION.createStatement();
		
			
	}

	/**
	 * 종료시 진행중 할당받은 자원을 반한다.
	 */
	protected void releaseResource() {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushUpdator===> releaseResource()");
		}
		// TMS 대상 연결을 반환한다.
		if( this.SOURCE_CONNECTION != null ) {
			this.SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_SELECT_STMT);
			this.SOURCE_CONNECTION.recycleStatement(this.MODULE_PUSH_SELECT_STMT);
			this.SOURCE_CONNECTION.recycleStatement(this.MODULE_PUSH_UPDATE_STMT);
			
			this.SOURCE_CONNECTION.recycle();
		}
	}

	protected void execute_main() throws Throwable {
		
		if (log.isDebugEnabled()) {
			log.debug("CALL PushUpdator===> execute_main()");
		}
		// push_send_conf.xml에서 정의된 db설정
		eMsResultSet pushListTableResult  = null;
		
		
		Properties tValue = new Properties();	
		
		try{			
			pushListTableResult =  this.TMS_PUSH_SELECT_STMT.executeQuery(this.QUERY_SELECT_TARGET_PUSH_LIST_TABLE); 		
			while(pushListTableResult.next()){			
				if(pushListTableResult.getString("LIST_TABLE1").equals(pushListTableResult.getString("LIST_TABLE2"))){
					tValue.setProperty("LIST_TABLE",pushListTableResult.getString("LIST_TABLE1").toString());
				}else{
					pushListTableResult.putToMap(tValue, false);					
				}
			}		
			if(pushListTableResult != null){
				pushListTableResult.close();
			}	
			for (Iterator iter = tValue.values().iterator(); iter.hasNext();) {
				String pushListTable = iter.next().toString();
				if(!pushListTable.equals("") && pushListTable != null){
					// real update !!!!!!!!!!!!!!!!!!!!!!!!
					update_process(pushListTable);
				}else{
					log.debug("TARGET TABLE null ", this.QUERY_SELECT_TARGET_PUSH_LIST_TABLE);
				}
			}
		}catch(Exception e){
			log.error("PushUpdator", "execute_main", e);
		}finally{
			if(pushListTableResult != null){
				pushListTableResult.close();
			}
		}
	}

	public void update_process(String list_table) throws Exception{
		
		eMsResultSet modulePushResult  	= null;	
		Properties pushSendResultValue 	= new Properties();	
		ScheduleTblBean stBean 			= null;	
		ScheduleTblBean autoStBean 		= null;
		
		String postId 	= "";
		int posPostid 	= 0;
		String workDay 	= "";
		String seqNo 	= "";
		
		String maxId = "";
		String minId = "";
		
		PushAutoUpdator autoUpt = new PushAutoUpdator();
		PushCampUpdator campUpt = new PushCampUpdator();
		
		try{
			
			maxId = this.TASK_PROPERTY.getProperty("MAX_ID");
			minId = this.TASK_PROPERTY.getProperty("MIN_ID");
			
			pushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
			pushSendResultValue.setProperty("MAX_ID", maxId);
			pushSendResultValue.setProperty("MIN_ID", minId);
			modulePushResult = this.MODULE_PUSH_SELECT_STMT.executeQuery(this.QUERY_TARGET_PUSH_RESULT_QUERY ,pushSendResultValue, "${", "}");

			campUpt.init_con(list_table);
			autoUpt.init_con(list_table);
			
			while(modulePushResult.next()){
				pushSendResultValue.clear();
				pushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);	
				
				modulePushResult.putToMap(pushSendResultValue, false);
				postId = pushSendResultValue.getProperty("POST_ID").trim();
				
				if(pushSendResultValue.getProperty("REQ_UID").startsWith("A")){
					//POST_ID => WORKDAY & SEQNO 로 분리
					posPostid = postId.indexOf('_');
					workDay = postId.substring(0, posPostid);
					seqNo = postId.substring(posPostid+1);
					pushSendResultValue.setProperty("WORKDAY", workDay);
					pushSendResultValue.setProperty("SEQNO", seqNo);
					
					try{
						autoUpt.update(pushSendResultValue,list_table);
					}catch(Exception e){
						continue;
					}
					
					autoStBean = (ScheduleTblBean)AUTO_SCHEDULE_PPT.get(postId);
					
					if(autoStBean == null){
						autoStBean = new ScheduleTblBean(postId);
						AUTO_SCHEDULE_PPT.put(postId, autoStBean);
					}
					
					if("S".equals(pushSendResultValue.getProperty("RTN_TYPE"))){ // 성공,실패
						if(Integer.parseInt(pushSendResultValue.getProperty("FAIL_CNT")) > 0){
							autoStBean.addFailCnt();
							autoStBean.addErrorCnt(pushSendResultValue.getProperty("ERROR_CODE"));
						}					
					}else if(pushSendResultValue.getProperty("RTN_TYPE").equals("R")){	// OPEN
						if(!pushSendResultValue.getProperty("DELIVER_TIME").equals("")){
							autoStBean.addOpenCnt();
						}
					}else if(pushSendResultValue.getProperty("RTN_TYPE").equals("C")){	// CLICK
						if(!pushSendResultValue.getProperty("DELIVER_TIME").equals("")){
							autoStBean.addClickCnt();
						}
					}
					//TODO stBean이 null일경우 stBean.addPush()에서 NullPointException이 발생할수 있음.
					if(stBean != null)
						stBean.addPush();
					
				}else{
					try{
						campUpt.update(pushSendResultValue,list_table );
					}catch(Exception e){
						continue;
					}
					stBean = (ScheduleTblBean)CAMP_SCHEDULE_PPT.get(postId);
					if(stBean==null){
						stBean = new ScheduleTblBean(postId);
						CAMP_SCHEDULE_PPT.put(postId, stBean);
					}
					
					if(pushSendResultValue.getProperty("RTN_TYPE").equals("S")){ // 성공,실패
						stBean.addPush();
						if(Integer.parseInt(pushSendResultValue.getProperty("FAIL_CNT")) > 0){
							stBean.addFailCnt();
							stBean.addErrorCnt(pushSendResultValue.getProperty("ERROR_CODE"));
						}
					}else if(pushSendResultValue.getProperty("RTN_TYPE").equals("R")){	// OPEN
						if(!pushSendResultValue.getProperty("DELIVER_TIME").equals("")){
							stBean.addOpenCnt();
						}
					}else if(pushSendResultValue.getProperty("RTN_TYPE").equals("C")){	// CLICK
						if(!pushSendResultValue.getProperty("DELIVER_TIME").equals("")){
							stBean.addClickCnt();
						}
					}	
					
				}
				
				
				
				
			}		
			if(CAMP_SCHEDULE_PPT.size() > 0){
				schdSummary(CAMP_SCHEDULE_PPT,"MASS");
			}
			
			if(AUTO_SCHEDULE_PPT.size() > 0){
				schdSummary(AUTO_SCHEDULE_PPT,"AUTO");
			}				
		
		}catch(Exception e){
			log.error("PushUpdator", "execute_main", e);
		}finally{
			if(modulePushResult != null){
				modulePushResult.close();
			}
			campUpt.release();
			autoUpt.release();
		}
	}
	
	public void schdSummary(Hashtable schdMap, String type){
			ScheduleTblBean stBean = null;
			StringBuffer buff = new StringBuffer(512);
			int result = 0;
			int summaryCnt = 0;
			
			try{
				Enumeration e = schdMap.elements();
				while(e.hasMoreElements()){
					result = 0;
					
					stBean = (ScheduleTblBean)e.nextElement();
					buff.setLength(0);
					if(log.isDebugEnabled()){log.debug("[stBean content]\n\t"+stBean.toString());}
					if(type.equals("AUTO")){
						StringConvertUtil.ConvertString( buff , QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO , stBean.getElement(type) , "${" , "}" , true , false );
					}else{
						StringConvertUtil.ConvertString( buff , QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY , stBean.getElement(type) , "${" , "}" , true , false );
					}
					result = this.MODULE_PUSH_UPDATE_STMT.executeUpdate(buff.toString());
					if(result<	1){
						log.debug("[SCHEDULE SUMMARY FAIL]:"+stBean.getName());
					}else{
						summaryCnt++;
					}
				}
			}catch(Exception e){
				
			}finally{
				buff.setLength(0);
				buff = null;
				schdMap.clear();
			}
			
		
	}
	
	protected String ppsParseSQL(String source, String mapping, String value,String start, String end) {

		if( mapping == null || source == null )
			return source;

		return replace_target(source, start + mapping + end, value);
	}
	
	public static String replace_target(String target, String from, String to) {
		if( target == null || from == null || to == null )
			return null;

		int idx1 = 0;
		int idx2;

		while ((idx2 = target.indexOf(from, idx1)) != -1) {
			target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
			idx1 = idx2 + to.length();
		}
		return target;
	}
	
	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		// 반환할 자원이 없다.
	}
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("PushUpdator_at_".concat(Cal.getSerialDate()));
	}
	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error("PushUpdator", "init error", thw);
	}
}// end class
