/*
 * Created on 2010. 8. 15.
 */
package jupiter.mass.log.updator;

import java.sql.Statement;
import java.util.Properties;

import jupiter.mass.log.updator.sync.SwitchingFactory;
import jupiter.mass.log.updator.sync.SwitchingService;
import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.Cal;

/**
 * @FileName  	: PushToTmsTransfer.java
 * @Project     : TMS_1.0_DEV
 * @Date        : 2014. 7. 23. 
 * @Actor      	: 
 * @modify 		: pioneer
 * @comment 	: 주기적으로 PUSH TB_SEND_QUE_LOG(외부) 데이터를 TMS PUSH_SEND_QUE_LOG(Local) 테이블로 이전
 */
@Slf4j
public class PushToTmsTransfer extends pluto.schedule.Task {

	

	private static ConnectInfo	TARGET_CONNECT_INFO					= null;

	static {
		TARGET_CONNECT_INFO = new ConnectInfo();
		TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("push.db.driver"));
		TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("push.db.url"));
		TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("push.db.id"));
		TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("push.db.pass"));
		TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("push.db.init"));
		TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("push.db.base.charset"));
		TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("push.db.out.charset"));
		TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("push.db.in.charset"));
	}
	
	private eMsPreparedStatement PSTMT = null;
	/**
	 * push 디비 접속(SOURCE)
	 */
	protected eMsConnection			LOCAL_CONNECTION					= null;
	/**
	 * push 디비 접속 (TARGET ---> TBL_ORG_SM_TRAN, TBL_SM_TRAN, TBL_SM_QUEUE)
	 */
	private eMsConnection			EX_PUSH_CONNECTION					= null;	
	/**
	 * TMS DB SELECT
	 */
	private eMsStatement			MODULE_PUSH_SELECT_STMT				= null;
	/**
	 * 결과셋을 가져오는 쿼리
	 */
	private String				QUERY_TARGET_PUSH_RESULT_QUERY			= null;
	
	/**
	 * PUSH TEMP TABLE INSERT:TB_SEND_QUE_LOG
	 */
	private String 				INSERT_TMS_SENDED_LOG  					    = null;
	
	
	private String              LOCAL_MAX_PUSH_LOG_ID                       = null;
	
	private String              EXTERNAL_MAX_PUSH_LOG_ID                       = null;
	
	
	private int preExternalMaxValue = 0;
	
	private int intervalCount = 5 ;
	
	/**
	 * PUSH DB 작업 결과 일괄 업데이트 처리[TB_SEND_QUE_LOG.CHECK_FLAG='-' TO 'Y'] 
	 */
	
	public PushToTmsTransfer() {
		
		super(TYPE_INTERVAL,2);
		this.setName("PushToTmsTransfer");
		this.setTaskID("PushToTmsTransfer");
		
		this.LOCAL_MAX_PUSH_LOG_ID 					= SqlManager.getQuery("MASS_UPDATE", "LOCAL_MAX_PUSH_LOG_ID");		
		this.EXTERNAL_MAX_PUSH_LOG_ID 				= SqlManager.getQuery("MASS_UPDATE", "EXTERNAL_MAX_PUSH_LOG_ID");		
		this.QUERY_TARGET_PUSH_RESULT_QUERY 		= SqlManager.getQuery("MASS_UPDATE", "QUERY_TARGET_PUSH_RESULT_QUERY");
		this.INSERT_TMS_SENDED_LOG 					= SqlManager.getQuery("MASS_UPDATE", "INSERT_TMS_SENDED_LOG");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pluto.push.module.PUSHCall#execute()
	 */
	public void execute() {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushToTmsTransfer===> execute()");
		}
		try {
			// 자원 초기화
			this.execute_init();
			// 메인 프로세스
			this.execute_main();
		}
		catch(Throwable thw) {
			log.error("CALL execute() ERROR", thw);
			///thw.printStackTrace();
		}
		finally {
			// 자원반환.
			this.releaseResource();
		}
	}

	/**
	 * 초기화하면서 사용할 자원을 할당한다.
	 * @throws Throwable
	 *         초기화 에러.
	 */
	protected void execute_init() throws Throwable {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushToTmsTransfer===> execute_init()");
		}
		
		this.LOCAL_CONNECTION 		= ConnectionPool.getConnection();
		
		this.EX_PUSH_CONNECTION 		= ConnectionPool.getConnection(TARGET_CONNECT_INFO);
		
		this.MODULE_PUSH_SELECT_STMT   = this.EX_PUSH_CONNECTION.createStatement();
		
	}

	/**
	 * 종료시 진행중 할당받은 자원을 반한다.
	 */
	protected void releaseResource() {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushToTmsTransfer===> releaseResource()");
		}
		// TMS 대상 연결을 반환한다.
		if( this.LOCAL_CONNECTION != null ) {
			this.LOCAL_CONNECTION.recycle();
		}
		// push 대상 연결을 반환한다.		
		if( this.EX_PUSH_CONNECTION != null ) {			
			this.EX_PUSH_CONNECTION.close();
		}
		
	}

	protected void execute_main() throws Throwable {
		try{
			if (log.isDebugEnabled()) {
				log.debug("CALL PushToTmsTransfer===> execute_main()");
			}
			update_process("TB_SEND_QUE_LOG");
		}catch(Exception e){
			log.error("execute_main", e);
		}
	}// end execute_main()

	
	public synchronized int singlePushSendLogToTmsRepository(eMsResultSet rs) throws Exception{
		int insertedCount = 0;
		try {
			this.PSTMT 	= LOCAL_CONNECTION.prepareStatement(INSERT_TMS_SENDED_LOG,"${","}");
			int count 	= 0;
			
			while(rs.next()){
				try {
					Properties p = new Properties();
					rs.putToMap(p, false);
					this.PSTMT.executeQuery(p);
				}catch (Exception e) {
					log.error("pushSendLogToTmsRepository", e);
					return 0;
				}
			    count++;
			}
		}catch(Exception e){
			log.error("pushSendLogToTmsRepository_finish ", e);
		}finally{
			try {
				if(rs != null) rs.close();
			}catch (Exception e2) {
			}
			try {
				if(PSTMT != null) PSTMT.close();
			} catch (Exception e2) {
			}
		}
		return insertedCount;
	}

	
	
	public synchronized int pushSendLogToTmsRepository(eMsResultSet rs) throws Exception{
		int insertedCount = 0;
		try {
			this.LOCAL_CONNECTION.setAutoCommit(false);
			this.PSTMT 	= LOCAL_CONNECTION.prepareStatement(INSERT_TMS_SENDED_LOG,"${","}");
			int count 	= 0;
			
			while(rs.next()){
				try {
					Properties p = new Properties();
					rs.putToMap(p, false);
					this.PSTMT.addBatchLong(p);
				}catch (Exception e) {
					log.error("pushSendLogToTmsRepository", e);
					//e.printStackTrace();
					return 0;
				}
			    count++;
			}
			// 나머지를 한번 더 실행
			insertedCount = insertedCount + getBatchResultCnt(this.PSTMT.executeBatch());
			log.debug("External Push select Count["+count+"] Local Insert Count ["+insertedCount+"]");
		}catch(Exception e){
			LOCAL_CONNECTION.rollback();
			log.error("pushSendLogToTmsRepository_finish ", e);
			throw e;
		}finally{
			if(rs != null) rs.close();
			if(PSTMT != null) PSTMT.close();
			//TODO finally 부분에서 throw를 실행할수 없어 변경
//			try {
//				if(rs != null) rs.close();
//				if(PSTMT != null) PSTMT.close();
//				
//			}catch (Exception e2) {
//				log.error("pushSendLogToTmsRepository_finally ", e2);
//				throw e2;
//			}
			this.LOCAL_CONNECTION.commit();
			this.LOCAL_CONNECTION.setAutoCommit(true);
		}
		return insertedCount;
	}
	
	private static int getBatchResultCnt(int[] updates){
	    int tmpCnt = 0;
	    for(int i=0; i < updates.length; i++){
	        if( updates[i] == Statement.SUCCESS_NO_INFO ){         //처리는 되었으나 갱신건수를 알수 없을때 (-2)
	            tmpCnt = tmpCnt + 1;
	        }else if( updates[i] == Statement.EXECUTE_FAILED){     //처리안됨.
	        	log.error("Push Result Insert Fail Position["+i+"]");
	        	log.debug("Push Result Insert Fail Position["+i+"]");
	        	continue;
	        }else{
	            tmpCnt = tmpCnt + updates[i];
	        }
	    }
	    return tmpCnt;
	}
	
	/**
	 * push 발송 결과[PUSH.TB_SEND_QUE_LOG --> TMS.PUSH_SEND_QUE_LOG] 트랜스포머 ㅎㅎㅎ
	 * @param list_table  (TB_SEND_QUE_LOG)
	 * @throws Exception
	 */
	public void update_process(String list_table) throws Exception{
		eMsResultSet modulePushResult     = null;
		Properties prePushSendResultValue = new Properties();
		try{
			prePushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
			String localMax ="";
			String externalMax ="";
			SwitchingService switching = SwitchingFactory.getSwitchingFactory().getInstance("push");

			switching.doLock();
			
			for (int i = 0; i < 20; i++) {
				//SET SELECT LOCAL_MAX_VALUE
				localMax = getLocalPushLogMaxId();
				prePushSendResultValue.setProperty("ID", localMax);
				
				externalMax=getExternalPushLogMaxId();
				prePushSendResultValue.setProperty("MAX_ID", externalMax);
				
				if(Long.parseLong(localMax)-1 == Long.parseLong(externalMax)){
					log.debug("external Push data(MAX_ID="+externalMax+") --> local push log(MAX_ID="+ (Long.parseLong(localMax)-1) +")");
					switching.unLock();
					return;
				}
				
				//PMS DB의 실시간 ResultSet의 결과 정보가 정확하지 않아 싱크를 맞추기 위해 약 3~5초 대기
				//if(waiting( (Integer.parseInt(localMax)-1) , Integer.parseInt(externalMax) )) { Thread.sleep(2000);  continue; }
				
				//SELECT EXTERNAL PUSH LOG
				modulePushResult = this.MODULE_PUSH_SELECT_STMT.executeQuery(this.QUERY_TARGET_PUSH_RESULT_QUERY , prePushSendResultValue, "${", "}");
				
				//INSERT LOCAL PUSH LOG 
				pushSendLogToTmsRepository(modulePushResult);
				
			}
			switching.unLock();
			log.debug("external Push data(MAX_ID="+externalMax+") --> local push log(MAX_ID="+localMax+"-1 )");			
		
		}catch(Exception e){
			//e.printStackTrace();
			log.debug("Exception external Push data --> local push log ="+e.toString());
			log.error("execute_main", e);
		}finally{
			try {
				prePushSendResultValue.clear();
				if(modulePushResult != null){
					modulePushResult.close();
				}	
				if(MODULE_PUSH_SELECT_STMT != null){
					MODULE_PUSH_SELECT_STMT.close();
				}
//				this.SOURCE_CONNECTION.commit();
				if(this.LOCAL_CONNECTION != null){
					this.LOCAL_CONNECTION.setAutoCommit(true);
				}
			} catch (Exception e2) {
				log.error("execute_main", e2);
			}
		}
	}
	
	private boolean waiting(int localMax, int externalMax){
		if(externalMax - this.preExternalMaxValue < 2) { 
			this.intervalCount--;
			return (this.intervalCount == 0 ) ? false : true;
		}
		return (externalMax - localMax > 10000) ? false : true ;
	}
	
	
	/**
	 * Local PUSH_SEND_QUE_LOG Table의 MAX+1 ID 값을 불러온다.
	 * @return
	 * @throws Exception
	 */
	private String getLocalPushLogMaxId() throws Exception{
		eMsStatement statement			  = null;
		statement          =  this.LOCAL_CONNECTION.createStatement();
		return getPushLogMaxId(statement, LOCAL_MAX_PUSH_LOG_ID);
	}
	
	private String getExternalPushLogMaxId() throws Exception{
		eMsStatement statement			  = null;
		statement          =  this.EX_PUSH_CONNECTION.createStatement();
		return getPushLogMaxId(statement, EXTERNAL_MAX_PUSH_LOG_ID);
	}

	private String getPushLogMaxId(eMsStatement statement, String sql) throws Exception {
		eMsResultSet localResultSet   = null;
		String id = "1";
		try {
			localResultSet     =  statement.executeQuery(sql);
			if(localResultSet.next())
				id = localResultSet.getString("ID");
			return id ;
		} catch (Exception e) {
			log.error(getName(), e);
			throw e;
		}finally{
			try{
				if(localResultSet != null){
					localResultSet.close();
				}	
			} catch (Exception e2) {
			}
			
			try {
				if(statement != null){
					statement.close();
				}
			} catch (Exception e2) {
			}
		}
	}
	
	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		// 반환할 자원이 없다.
	}
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("PushToTmsTransfer_at_".concat(Cal.getSerialDate()));
	}
	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error("init error", thw);
	}
}// end class
