package jupiter.mass.log.updator;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import jupiter.mass.log.updator.sync.SwitchingFactory;
import jupiter.mass.log.updator.sync.SwitchingService;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;

/**
 * @FileName  	: PushFinishedDelete.java
 * @Project     : TMS_1.0_DEV
 * @Date        : 2014. 7. 23. 
 * @Actor      	: pioneer
 * @modify 		:
 * @comment 	: PUSH TB_SEND_QUE_LOG.CHECK_FLAG = 'Y' 인 데이터 삭제 (주기성 프로세스)  
 */
@Slf4j
public abstract class PushFinishedDelete extends pluto.schedule.Task {

	private eMsPreparedStatement	PSTATEMENT					= null;
	
	private eMsStatement			TMS_PUSH_SELECT_STMT		= null;
	
	protected String				DELETE_PUSH_SENDED_LOG		= null;
	
	protected String				SELECT_PUSH_SENDED_LOG_POST_ID		= null;
	
	private static String			deleteHour					= null;
	
	public PushFinishedDelete(String name, String id){
		super(TYPE_INTERVAL,2);
		this.setName(name);
		this.setTaskID(id);
	}
	
	public synchronized static void init(Object prop) throws Exception {
		Properties tmp = (Properties) prop;
		
		deleteHour = tmp.getProperty("delete.hour","01");
	}
	/**
	 * 주기적으로 PUSH LOG Data 삭제
	 */
	@Override
	public void execute() throws Exception {
		eMsConnection			SOURCE_CONNECTION	= null;
		eMsResultSet eMsRs  = null;
		if(deleteHour.equals(Cal.getHour())){
			if (log.isDebugEnabled()) {
				log.debug("CALL PushFinishedDelete===> execute()");
			}
			
			SwitchingService switching = null;
			
			
			try {
				
				switching = SwitchingFactory.getSwitchingFactory().getInstance("push");
				switching.doLock();
				
				if (log.isDebugEnabled()) {
					log.debug("=========================== PUSH_SEND_QUE_LOG DELETE START ==============================");
				}
				
				this.PSTATEMENT = new eMsPreparedStatement(DELETE_PUSH_SENDED_LOG, "${", "}");
	
				this.PSTATEMENT.connectTo(getConnection());
				
				this.TMS_PUSH_SELECT_STMT      = getConnection().createStatement();
				
				eMsRs = this.TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_PUSH_SENDED_LOG_POST_ID ,new Properties(), "${", "}");
				
				List<Properties> pushPostIdList = fromResultSetToList(eMsRs, "");

				if(pushPostIdList.isEmpty()) {
					return;
				}
				
				int cnt = 0;
				
				for (Properties pushPostIdValue : pushPostIdList) {
					cnt = this.PSTATEMENT.executeUpdate(pushPostIdValue);
					if (log.isDebugEnabled()) {
						log.debug("PUSH_SEND_QUE_LOG DELETE POST_ID:"+pushPostIdValue.getProperty("POST_ID")+" CNT :"+ cnt);
					}
				}
				if (log.isDebugEnabled()) {
					log.debug("=========================== PUSH_SEND_QUE_LOG DELETE END ==============================");
				}
				
				switching.unLock();
			}
			catch(Throwable thw) {
				log.error("CALL execute() ERROR", thw);
			}
			finally {
				try {
					if(PSTATEMENT !=null) {
						PSTATEMENT.close();
					}
				} catch (Exception e) {
				}
				try {
					if(TMS_PUSH_SELECT_STMT !=null) {
						TMS_PUSH_SELECT_STMT.close();
					}
				} catch (Exception e) {
				}
			}
		}
		if(SOURCE_CONNECTION != null){
				close(SOURCE_CONNECTION);
		}
	}
	
	public List fromResultSetToList(eMsResultSet rs, String tableName) throws Exception{
		List<Properties> pushResult = new ArrayList<Properties>();
		while(rs.next()){
			Properties pushSendResultValue = new Properties();
			pushSendResultValue.setProperty("PUSH_LIST_TABLE", tableName);
			rs.putToMap(pushSendResultValue, false);
			pushResult.add(pushSendResultValue);
		}
		return pushResult;
	}

	@Override
	public void execute_initiateError(Throwable thw) {
		// TODO Auto-generated method stub
	}

	@Override
	public void release_Resource() {
		// TODO Auto-generated method stub
	}
	
	//Connection
	public abstract eMsConnection getConnection() throws Exception;
	
	public abstract void close(eMsConnection conn) ;
}
