/*
 * Created on 2010. 8. 15.
 */
package jupiter.mass.log.updator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.Cal;
import pluto.util.StringUtil;
/**
 * @author 에이메일  push UPDATE
 */
@Slf4j
public class PushCampSendListUpdator extends pluto.schedule.Task {

	

	private eMsPreparedStatement PSTMT = null;
	
	private eMsPreparedStatement OPEN_PSTMT = null;
	
	private eMsPreparedStatement CHECK_PSTMT = null;
	/**
	 * push 디비 접속(SOURCE)
	 */
	protected eMsConnection			SOURCE_CONNECTION					= null;
	/**
	 * push 디비 접속 (TARGET ---> TBL_ORG_SM_TRAN, TBL_SM_TRAN, TBL_SM_QUEUE)
	 */
	/**
	 * TMS DB SELECT
	 */
	private eMsStatement			TMS_PUSH_SELECT_STMT				= null;
	/**
	 * 모듈 로그 테이블 가져온다~~~
	 */
	private String				SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE 	= null;
	/**
	 * 결과셋을 가져오는 쿼리
	 */
	private String				QUERY_TARGET_PUSH_POST_ID_QUERY			= null;
	/**
	 * 리스트테이블 TMS_SCHD_INFO 결과 업데이트
	 */
	private String				UPDATE_SCHEDULE_INFO_SUMMARY_QUERY= null;
	/**
	 * 리스트테이블 TMS_SCHD_INFO OPEN 건수 업데이트
	 */
	
	private String 				UPDATE_PUSH_CHECK_FLAG_QUERY					= null;

	private String				SELECT_PUSH_SEND_QUE_LOG			= null;
	
	/**
	 * PUSH DB 작업 결과 일괄 업데이트 처리[TB_SEND_QUE_LOG.CHECK_FLAG='-' TO 'Y'] 
	 */
	private String 				UPDATE_PUSH_CHECK_FLAG_FINAL				= null;
	
	private String 				SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY		= null;
	
	private String 				UPDATE_TMS_PUSH_LIST						= null;
	
	private String 				UPDATE_TMS_CAMP_SEND_OPEN						= null;
	
	private String 				UPDATE_TMS_CAMP_SEND_CLICK						= null;
	
	public PushCampSendListUpdator() {
		
		super(TYPE_INTERVAL,2);
		this.setName("PushCampSendListUpdator");
		this.setTaskID("PushCampSendListUpdator");
		
		this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE = SqlManager.getQuery("MASS_UPDATE", "SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE");
		
		this.QUERY_TARGET_PUSH_POST_ID_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_TARGET_PUSH_POST_ID_QUERY");
		this.UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
		this.UPDATE_PUSH_CHECK_FLAG_QUERY = SqlManager.getQuery("MASS_UPDATE", "UPDATE_PUSH_CHECK_FLAG_QUERY");
		this.SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "UPDATE_TARGET_PUSH_COUNT_SUMMARY_QUERY");
		
		this.UPDATE_PUSH_CHECK_FLAG_FINAL = SqlManager.getQuery("MASS_UPDATE","UPDATE_PUSH_CHECK_FLAG_FINAL");		// TMS_CAMP_SEND_CLICK
		
		this.UPDATE_TMS_PUSH_LIST = SqlManager.getQuery("MASS_UPDATE","UPDATE_TMS_PUSH_LIST");
		this.UPDATE_TMS_CAMP_SEND_OPEN = SqlManager.getQuery("MASS_UPDATE","UPDATE_TMS_CAMP_SEND_OPEN");
		this.UPDATE_TMS_CAMP_SEND_CLICK = SqlManager.getQuery("MASS_UPDATE","UPDATE_TMS_CAMP_SEND_CLICK");
		this.SELECT_PUSH_SEND_QUE_LOG = SqlManager.getQuery("MASS_UPDATE","SELECT_PUSH_SEND_QUE_LOG");
	}

	public void execute() {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushCampSendListUpdator===> execute()");
		}
		try {
			// 자원 초기화
			this.execute_init();
			// 메인 프로세스
			this.execute_main();
		}
		catch(Throwable thw) {
			log.error("PushCampSendListUpdator", "CALL execute() ERROR", thw);
		}
		finally {
			// 자원반환.
			this.releaseResource();
		}
	}

	/**
	 * 초기화하면서 사용할 자원을 할당한다.
	 * @throws Throwable
	 *         초기화 에러.
	 */
	protected void execute_init() throws Throwable {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushCampSendListUpdator===> execute_init()");
		}
		
		this.SOURCE_CONNECTION = ConnectionPool.getConnection();
		
		this.TMS_PUSH_SELECT_STMT      = this.SOURCE_CONNECTION.createStatement();
	}

	/**
	 * 종료시 진행중 할당받은 자원을 반한다.
	 */
	protected void releaseResource() {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushCampSendListUpdator===> releaseResource()");
		}
		// TMS 대상 연결을 반환한다.
		if( this.SOURCE_CONNECTION != null ) {
			this.SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_SELECT_STMT);
			this.SOURCE_CONNECTION.recycle();
		}
	
	}

	protected void execute_main() throws Throwable {
		
		if (log.isDebugEnabled()) {
			log.debug("CALL PushCampSendListUpdator===> execute_main()");
		}
		// push_send_conf.xml에서 정의된 db설정
		eMsResultSet pushListTableResult  = null;
		
		
		Properties tValue = new Properties();	
		
		try{
			
			this.TMS_PUSH_SELECT_STMT      = this.SOURCE_CONNECTION.createStatement();
			
			pushListTableResult =  this.TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE); 
			
			while(pushListTableResult.next()){
				
				if(pushListTableResult.getString("LIST_TABLE1").equals(pushListTableResult.getString("LIST_TABLE2"))){
					tValue.setProperty("LIST_TABLE",pushListTableResult.getString("LIST_TABLE1").toString());
				}else{
					pushListTableResult.putToMap(tValue, false);
				}
			}
			
			if(pushListTableResult != null){
				pushListTableResult.close();
			}
			
			for (Iterator iter = tValue.values().iterator(); iter.hasNext();) {
				String pushListTable = iter.next().toString();
				if(!pushListTable.equals("") && pushListTable != null){
					
					update_process(pushListTable);
				
				
				}else{
					log.debug("TARGET TABLE null ", this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE);
				}
					
			}
			
		}catch(Exception e){
			log.error("PushCampSendListUpdator", "execute_main", e);
		}finally{
			
			/*if( SOURCE_CONNECTION != null ) {
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_SELECT_STMT);
				SOURCE_CONNECTION.recycle();
			}*/
			
			if(pushListTableResult != null){
				pushListTableResult.close();
				pushListTableResult = null;
			}
			
		}
	}// end execute_main()

	
	public List fromResultSetToList(eMsResultSet rs, String tableName) throws Exception{
		List<Properties> pushResult = new ArrayList<Properties>();
		while(rs.next()){
			Properties pushSendResultValue = new Properties();
			pushSendResultValue.setProperty("PUSH_LIST_TABLE", tableName);
			rs.putToMap(pushSendResultValue, false);
			pushResult.add(pushSendResultValue);
		}
		return pushResult;
	}
	
	
	public void update_process(String list_table) throws Exception{
		
		log.debug("PushCampSendListUpdator", "update_process", "=========================== MASS SEND LIST UPDATE START ==============================");
		
		eMsResultSet PushPostIdResult  = null;
		eMsResultSet eMsRs  = null;
		Properties prePushSendResultValue = new Properties();
		ScheduleTblBean stBean = null;
		int result=0;
		boolean updateFlag = false;
		StringBuffer buff = new StringBuffer(512);
		
		try{
			prePushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
			
			this.SOURCE_CONNECTION.setAutoCommit(false);
			
			//업데이트 칠 POST_ID를 가져 온다.
			PushPostIdResult = this.TMS_PUSH_SELECT_STMT.executeQuery(this.QUERY_TARGET_PUSH_POST_ID_QUERY ,prePushSendResultValue, "${", "}");
			
			List<Properties> pushPostIdList = fromResultSetToList(PushPostIdResult, list_table);
			
			if(pushPostIdList.isEmpty()) {
				return;
			}

			int cnt = 0;
			
			this.SOURCE_CONNECTION.setAutoCommit(false);
			for (Properties pushPostIdValue : pushPostIdList) {
				
				String post_id = pushPostIdValue.getProperty("POST_ID");
						
				String push_table =	StringUtil.getPushTable(post_id);
				
				pushPostIdValue.setProperty("PUSH_TABLE", push_table);
				
				UPDATE_TMS_PUSH_LIST = UPDATE_TMS_PUSH_LIST.replaceAll("\\$\\{PUSH_TABLE}", push_table);
				
				this.PSTMT 	= SOURCE_CONNECTION.prepareStatement(UPDATE_TMS_PUSH_LIST,"${","}");
				
				this.OPEN_PSTMT 	= SOURCE_CONNECTION.prepareStatement(UPDATE_TMS_CAMP_SEND_OPEN,"${","}");
				
				this.CHECK_PSTMT 	= SOURCE_CONNECTION.prepareStatement(UPDATE_PUSH_CHECK_FLAG_FINAL,"${","}");
				
				try{
					//가져온 POST_ID 기준 으로 TMS_PUSH_LIST 테이블에 성공여부, 오픈, 클릭 건수 정보를 업데이트 한다.					
					
					eMsRs = this.TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_PUSH_SEND_QUE_LOG ,pushPostIdValue, "${", "}");
					int listCnt = 0;
					int openCnt = 0;
					
					while(eMsRs.next()){
						Properties p = new Properties();
						eMsRs.putToMap(p, false);
						p.setProperty("PUSH_TABLE", push_table);
						listCnt += PSTMT.executeUpdateLong(p);
						
						//가져온 POST_ID 기준 으로 TMS_CAMP_SEND_OPEN 테이블에 오픈 정보를 업데이트 한다.					
						
						if(!p.getProperty("OPEN_CNT", "0").equals("0")){
							openCnt += OPEN_PSTMT.executeUpdateLong(p);
						}
						//가져온 POST_ID 기준 으로 TMS_CAMP_SEND_CLICK 테이블에 클릭 정보를 업데이트 한다.
						//OPEN_CNT 값이 있을 경우에만 TMS_AUTO_SEND_OPEN에 업데이트 한다.
						
						cnt += CHECK_PSTMT.executeUpdateLong(p);
						
						
						if(listCnt % 5000 == 0){
							log.error("PushCampSendListUpdator", "POST_ID :"+post_id+ " TMS_CAMP_SEND_LIST_ :"+listCnt+" TMS_CAMP_SEND_OPEN :"+openCnt);
							
							this.SOURCE_CONNECTION.commit();
						}
					}
					
					log.error("PushCampSendListUpdator", "POST_ID :"+post_id+ " TMS_CAMP_SEND_LIST_ :"+listCnt+" TMS_CAMP_SEND_OPEN :"+openCnt);
					
					this.SOURCE_CONNECTION.commit();
					
				} catch(Exception e) {
					log.error("PushCampSendListUpdator", "update_process", e);
				}
			}
			
			this.SOURCE_CONNECTION.commit();
			
			this.SOURCE_CONNECTION.setAutoCommit(true);

			
			
			log.debug("PushCampSendListUpdator", "UPDATE_PUSH_CHECK_FLAG_QUERY", "CHECK_FLAG = '-' -> 'Y' : "+cnt);
			
			log.debug("PushCampSendListUpdator", "update_process", "=========================== MASS SEND LIST UPDATE END ==============================");
		}catch(Exception e){
			// e.printStackTrace();
			log.error("PushCampSendListUpdator", "update_process", e);
		}finally{
			
			/*if( SOURCE_CONNECTION != null ) {
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_SELECT_STMT);
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_UPDATE_STMT);
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_FLAG_STMT);
				SOURCE_CONNECTION.recycle();
			}*/
			
			if(PushPostIdResult != null){
				PushPostIdResult.close();
				PushPostIdResult = null;
			}
			if(eMsRs != null){
				eMsRs.close();
				eMsRs = null;
			}
			if(PSTMT != null){
				PSTMT.close();
				PSTMT = null;
			}
			
			if(OPEN_PSTMT != null){
				OPEN_PSTMT.close();
				OPEN_PSTMT = null;
			}
			
			if(CHECK_PSTMT != null){
				CHECK_PSTMT.close();
				CHECK_PSTMT = null;
			}
		}
	}
	
	/**
	 * Switching Query : CHECK_FLAG 업데이트 ['-' -> 'A' -> 'Y'] 
	 * @param query
	 * @return
	 * @throws Exception
	 */
/*	private int checkFlagSwitching(String query) throws Exception {
		//SwitchingService switching = SwitchingFactory.getSwitchingFactory().getInstance("push");
		try {
			//switching.doLock();

			int checkFlag = this.TMS_PUSH_FLAG_STMT.executeUpdate(query);
			
			return checkFlag;
		} catch (Exception e) {
			throw e;
		}finally{
			try {
				//switching.unLock();
			} catch (Exception e2) {
				throw e2;
			}
		}
		
	}
*/	
	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		// 반환할 자원이 없다.
	}
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("PushCampSendListUpdator_at_".concat(Cal.getSerialDate()));
	}
	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error("PushCampSendListUpdator", "init error", thw);
	}
}// end class
