/*
 * Created on 2010. 8. 15.
 */
package jupiter.mass.log.updator;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
/**
 * @author 에이메일  push UPDATE
 */
@Slf4j
public class PushAutoUpdator extends PushUpdator {

	
	private static String 	AUTO_LIST_TABLE							= "TMS_AUTO_SEND_LIST_";

	static {
	}

	protected eMsConnection			UPDATOR_CONNECTION					= null;

	public static final String 		OPEN_TYPE 		= "R";
	public static final String 		CLICK_TYPE 		= "C";
	private eMsPreparedStatement 	SEND_LIST_PSTMT_01   						= null;
	private eMsPreparedStatement 	SEND_LIST_PSTMT_02    						= null;
	private eMsPreparedStatement 	SEND_LIST_PSTMT_03    						= null;
	private eMsPreparedStatement 	SEND_LIST_PSTMT_04    						= null;
	private eMsPreparedStatement 	SEND_LIST_PSTMT_05    						= null;


	private eMsPreparedStatement 	SEND_OPEN_LIST_PSTMT					= null;
	private eMsPreparedStatement 	SEND_CLICK_LIST_PSTMT  					= null;
	private eMsPreparedStatement 	SEND_OPEN_STAT_PSTMT   					= null;
	private eMsPreparedStatement 	SEND_CLICK_STAT_PSTMT  					= null;
	
	private eMsPreparedStatement 	PUSH_QUE_LOG_PSTMT  					= null;
	
	//리스트테이블 업데이트
	private String UPDATE_TMS_PUSH_LIST_N;
	//오픈ㅇㅇ
	private String UPDATE_TMS_CAMP_SEND_OPEN_N;
	private String UPDATE_TMS_CAMP_SEND_CLICK_N;
	private String UPDATE_TMS_CAMP_SEND_OPEN_STAT_N;
	private String UPDATE_TMS_CAMP_SEND_CLICK_STAT_N;
	
	private String UPDATE_TMS_PUSH_QUE_LOG;
	
	
	
	public PushAutoUpdator() {
		
		super();
		//LIST TABLE에 결과 값을 업데이트
		this.UPDATE_TMS_PUSH_LIST_N 				= SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_PUSH_LIST_N");
		//PUSH_SEND_QUE_LOG -> TMS_CAMP_SEND_OPEN (SELECT INSERT)
		this.UPDATE_TMS_CAMP_SEND_OPEN_N 			= SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_CAMP_SEND_OPEN_N");
		//PUSH_SEND_QUE_LOG -> TMS_CAMP_SEND_CLICK (SELECT INSERT)
		this.UPDATE_TMS_CAMP_SEND_CLICK_N 			= SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_CAMP_SEND_CLICK_N");	
		this.UPDATE_TMS_CAMP_SEND_OPEN_STAT_N 		= SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_CAMP_SEND_OPEN_STAT_N");		
		this.UPDATE_TMS_CAMP_SEND_CLICK_STAT_N 		= SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_CAMP_SEND_CLICK_STAT_N");
		this.UPDATE_TMS_PUSH_QUE_LOG				=	SqlManager.getQuery("COMMON_UPDATE","UPDATE_TMS_PUSH_QUE_LOG");
	}

	
	public void init_con(String queLogTable) throws Exception{
		String listTable = "";
		String query = UPDATE_TMS_PUSH_LIST_N;
		try{
			this.UPDATOR_CONNECTION = ConnectionPool.getConnection();
		for(int i=1;i<=5;i++){
			listTable = getMonthListTableName(Integer.toString(i),"AUTO");
			query =  ppsParseSQL(UPDATE_TMS_PUSH_LIST_N,"LIST_TABLE",listTable,"@{","}"); 
			 if(i==1) SEND_LIST_PSTMT_01 = this.UPDATOR_CONNECTION.prepareStatement(query,"${","}");
			 if(i==2) SEND_LIST_PSTMT_02 = this.UPDATOR_CONNECTION.prepareStatement(query,"${","}");
			 if(i==3) SEND_LIST_PSTMT_03 = this.UPDATOR_CONNECTION.prepareStatement(query,"${","}");
			 if(i==4) SEND_LIST_PSTMT_04 = this.UPDATOR_CONNECTION.prepareStatement(query,"${","}");
			 if(i==5) SEND_LIST_PSTMT_05 = this.UPDATOR_CONNECTION.prepareStatement(query,"${","}");

		}
		SEND_OPEN_LIST_PSTMT   = this.UPDATOR_CONNECTION.prepareStatement(UPDATE_TMS_CAMP_SEND_OPEN_N,"${","}");
		SEND_CLICK_LIST_PSTMT  = this.UPDATOR_CONNECTION.prepareStatement(UPDATE_TMS_CAMP_SEND_CLICK_N,"${","}");
		SEND_OPEN_STAT_PSTMT   = this.UPDATOR_CONNECTION.prepareStatement(UPDATE_TMS_CAMP_SEND_OPEN_STAT_N,"${","}");
		SEND_CLICK_STAT_PSTMT  = this.UPDATOR_CONNECTION.prepareStatement(UPDATE_TMS_CAMP_SEND_CLICK_STAT_N,"${","}");	
		
		UPDATE_TMS_PUSH_QUE_LOG =  ppsParseSQL(UPDATE_TMS_PUSH_QUE_LOG,"PUSH_LIST_TABLE",queLogTable,"@{","}"); 
		PUSH_QUE_LOG_PSTMT     = this.UPDATOR_CONNECTION.prepareStatement(UPDATE_TMS_PUSH_QUE_LOG,"${","}");	
		}catch(Exception e){
			log.error(e.getMessage());
			release();
		}finally{
			
		}
	}
	
	public void release() throws Exception{
		if(SEND_LIST_PSTMT_01 != null) SEND_LIST_PSTMT_01.close();
		if(SEND_LIST_PSTMT_02 != null) SEND_LIST_PSTMT_02.close();
		if(SEND_LIST_PSTMT_03 != null) SEND_LIST_PSTMT_03.close();
		if(SEND_LIST_PSTMT_04 != null) SEND_LIST_PSTMT_04.close();
		if(SEND_LIST_PSTMT_05 != null) SEND_LIST_PSTMT_05.close();
		
		if(SEND_OPEN_LIST_PSTMT != null) SEND_OPEN_LIST_PSTMT.close();
		if(SEND_CLICK_LIST_PSTMT != null) SEND_CLICK_LIST_PSTMT.close();
		if(SEND_OPEN_STAT_PSTMT != null) SEND_OPEN_STAT_PSTMT.close();
		if(SEND_CLICK_STAT_PSTMT != null) SEND_CLICK_STAT_PSTMT.close();
		if(PUSH_QUE_LOG_PSTMT != null) PUSH_QUE_LOG_PSTMT.close();
		
		if(UPDATOR_CONNECTION != null) UPDATOR_CONNECTION.recycle();
	}
	
	public void update(Properties pushSendResultValue , String list_table) throws Exception{
		boolean testFlag = false;
		String postId = "";
		String memberId = "";
		try{
			pushSendResultValue.setProperty("CHECK_FLAG", "Y");
			pushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
			
			//POST_ID => WORKDAY & SEQNO 로 분리
			int posPostid = postId.indexOf("_");
			String workDay = postId.substring(0, posPostid);
			String seqNo = postId.substring(posPostid+1);
			pushSendResultValue.setProperty("WORKDAY", workDay);
			pushSendResultValue.setProperty("SEQNO", seqNo);
			
			if(pushSendResultValue.getProperty("REQ_UID").indexOf("AT") > 0)		//POST_ID에 테스트 구분코드 'CT'가 있으면 업데이트 SKIP
				testFlag = true;
			
			if(!testFlag){
				// member_id에 ^가 있을 경우 재발송
				if(pushSendResultValue.getProperty("MEMBER_ID").indexOf("*") > 0){
					// M_ID & WORK_SEQ 분리 M_ID=10234567^2  
					int pos = pushSendResultValue.getProperty("MEMBER_ID").indexOf("*");
					
					String mId = pushSendResultValue.getProperty("MEMBER_ID").substring(0, pos);
					String workSeq = pushSendResultValue.getProperty("MEMBER_ID").substring(pos+1);
					
					pushSendResultValue.setProperty("M_ID", mId);
					pushSendResultValue.setProperty("WORK_SEQ", workSeq);
					
					//resend 부분
					
				}else{
					
					int pos = memberId.indexOf("_");
					String mId = memberId.substring(0, pos);
					String mIdSeq = memberId.substring(pos+1);
					pushSendResultValue.setProperty("M_ID", mId);
					pushSendResultValue.setProperty("M_ID_SEQ", mIdSeq);
					
					// 실패건수 처리...
					if(pushSendResultValue.getProperty("RTN_TYPE").equals("S")){ // 성공,실패
						//1-1. TMS_PUSH_LIST ERROR_CODE UPDATE
						getPps(pushSendResultValue.getProperty("LIST_TABLE")).executeUpdate(pushSendResultValue);
										
					}else if(pushSendResultValue.getProperty("RTN_TYPE").equals("R")){	// OPEN
						if(pushSendResultValue.getProperty("OS").equals("I")){
							pushSendResultValue.setProperty("OPEN_CNT_IOS", "1");
						}else{
							pushSendResultValue.setProperty("OPEN_CNT_ANDROID", "1");
						}
						SEND_OPEN_LIST_PSTMT.executeUpdate(pushSendResultValue);
						SEND_OPEN_STAT_PSTMT.executeUpdate(pushSendResultValue);
					}else if(pushSendResultValue.getProperty("RTN_TYPE").equals("C")){	// CLICK
						
						if(pushSendResultValue.getProperty("OS").equals("I")){
							pushSendResultValue.setProperty("CLICK_CNT_IOS", "1");
						}else{
							pushSendResultValue.setProperty("CLICK_CNT_ANDROID", "1");
						}
						SEND_CLICK_LIST_PSTMT.executeUpdate(pushSendResultValue);
						SEND_CLICK_STAT_PSTMT.executeUpdate(pushSendResultValue);
						
					}
				}
			
			}
			PUSH_QUE_LOG_PSTMT.executeUpdate(pushSendResultValue);
	
		}catch(Exception e){
			// e.printStackTrace();
			log.error("PushAutoUpdator", "update", e);
			pushSendResultValue.setProperty("CHECK_FLAG", "F");
			PUSH_QUE_LOG_PSTMT.executeUpdate(pushSendResultValue);
		}finally{

		}
	}
	
	public eMsPreparedStatement getPps(String listTable){
		if(listTable.indexOf("01")>0) return  SEND_LIST_PSTMT_01;
		if(listTable.indexOf("02")>0) return  SEND_LIST_PSTMT_02;
		if(listTable.indexOf("03")>0) return  SEND_LIST_PSTMT_03;
		if(listTable.indexOf("04")>0) return  SEND_LIST_PSTMT_04;
		if(listTable.indexOf("05")>0) return  SEND_LIST_PSTMT_05;
		return null;
		
	}
}// end class
