/*
 * Created on 2010. 8. 15.
 */
package jupiter.mass.log.updator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.common.bean.PlanBean;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.log.Log;
import pluto.util.Cal;
import pluto.util.StringUtil;
/**
 * @author 에이메일  push UPDATE
 */
@Slf4j
public class PushAutoSendListUpdator extends pluto.schedule.Task {

	


	private eMsPreparedStatement PSTMT = null;
	
	private eMsPreparedStatement OPEN_PSTMT = null;
	
	private eMsPreparedStatement CHECK_PSTMT = null;
	/**
	 * push 디비 접속(SOURCE)
	 */
	protected eMsConnection			SOURCE_CONNECTION					= null;
	/**
	 * push 디비 접속 (TARGET ---> TBL_ORG_SM_TRAN, TBL_SM_TRAN, TBL_SM_QUEUE)
	 */
	/**
	 * TMS DB SELECT
	 */
	private eMsStatement			TMS_PUSH_SELECT_STMT				= null;
	/**
	 * 모듈 로그 테이블 가져온다~~~
	 */
	private String				SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE 	= null;
	/**
	 * 결과셋을 가져오는 쿼리
	 */
	private String				QUERY_TARGET_PUSH_POST_ID_QUERY			= null;
	/**
	 * 리스트테이블 TMS_SCHD_INFO 결과 업데이트
	 */
	private String				UPDATE_SCHEDULE_INFO_SUMMARY_QUERY= null;
	/**
	 * 리스트테이블 TMS_SCHD_INFO OPEN 건수 업데이트
	 */
	
	private String 				UPDATE_PUSH_CHECK_FLAG_QUERY					= null;

	private String				SELECT_PUSH_SEND_QUE_LOG			= null;
	
	/**
	 * PUSH DB 작업 결과 일괄 업데이트 처리[TB_SEND_QUE_LOG.CHECK_FLAG='-' TO 'Y'] 
	 */
	private String 				UPDATE_PUSH_CHECK_FLAG_FINAL				= null;
	
	private String 				SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY		= null;
	
	private String 				UPDATE_TMS_PUSH_LIST						= null;
	
	private String 				UPDATE_TMS_AUTO_SEND_OPEN						= null;
	
	private String 				UPDATE_TMS_AUTO_SEND_CLICK						= null;
	
	//flow plan data -------------------------------------------------------------------
	private static eMsPreparedStatement PPS_SELECT_FLOW_DATA  = null;
	private static eMsPreparedStatement PPS_INSERT_FLOW_DATA  = null;
	
	private static String QUERY_SELECT_PLAN_INFO              = SqlManager.getQuery("FLOW_PLAN", "QUERY_SELECT_PLAN_INFO");
	private static String QUERY_INSERT_FLOW_DATA              = SqlManager.getQuery("FLOW_PLAN", "QUERY_INSERT_FLOW_DATA");
		
	//----------------------------------------------------------------------------------	
		
	public PushAutoSendListUpdator() {
		
		super(TYPE_INTERVAL,2);
		this.setName("PushAutoSendListUpdator");
		this.setTaskID("PushAutoSendListUpdator");
		
		this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE = SqlManager.getQuery("AUTO_UPDATE", "SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE");
		
		this.QUERY_TARGET_PUSH_POST_ID_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_TARGET_PUSH_POST_ID_QUERY");
		this.UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
		this.UPDATE_PUSH_CHECK_FLAG_QUERY = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_PUSH_CHECK_FLAG_QUERY");
		this.SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_TARGET_PUSH_COUNT_SUMMARY_QUERY");
		
		this.UPDATE_PUSH_CHECK_FLAG_FINAL = SqlManager.getQuery("AUTO_UPDATE","UPDATE_PUSH_CHECK_FLAG_FINAL");		// TMS_CAMP_SEND_CLICK
		
		this.UPDATE_TMS_PUSH_LIST = SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_PUSH_LIST");
		this.UPDATE_TMS_AUTO_SEND_OPEN = SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_AUTO_SEND_OPEN");
		this.UPDATE_TMS_AUTO_SEND_CLICK = SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_AUTO_SEND_CLICK");
		this.SELECT_PUSH_SEND_QUE_LOG = SqlManager.getQuery("AUTO_UPDATE","SELECT_PUSH_SEND_QUE_LOG");
	}

	public void execute() {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushAutoSendListUpdator===> execute()");
		}
		try {
			// 자원 초기화
			this.execute_init();
			// 메인 프로세스
			this.execute_main();
		}
		catch(Throwable thw) {
			log.error("PushAutoSendListUpdator", "CALL execute() ERROR", thw);
		}
		finally {
			// 자원반환.
			this.releaseResource();
		}
	}

	/**
	 * 초기화하면서 사용할 자원을 할당한다.
	 * @throws Throwable
	 *         초기화 에러.
	 */
	protected void execute_init() throws Throwable {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushAutoSendListUpdator===> execute_init()");
		}
		
		this.SOURCE_CONNECTION = ConnectionPool.getConnection();
		
		this.TMS_PUSH_SELECT_STMT      = this.SOURCE_CONNECTION.createStatement();
	}

	/**
	 * 종료시 진행중 할당받은 자원을 반한다.
	 */
	protected void releaseResource() {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushAutoSendListUpdator===> releaseResource()");
		}
		
		//plan
		if(PPS_SELECT_FLOW_DATA !=null){
			PPS_SELECT_FLOW_DATA.close();
			PPS_SELECT_FLOW_DATA = null; 
		}
		if(PPS_INSERT_FLOW_DATA !=null){
			PPS_INSERT_FLOW_DATA.close();
			PPS_INSERT_FLOW_DATA = null; 
		}
		
		// TMS 대상 연결을 반환한다.
		if( this.SOURCE_CONNECTION != null ) {
			this.SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_SELECT_STMT);
			this.SOURCE_CONNECTION.recycle();
		}
	
	}

	protected void execute_main() throws Throwable {
		
		if (log.isDebugEnabled()) {
			log.debug("CALL PushAutoSendListUpdator===> execute_main()");
		}
		// push_send_conf.xml에서 정의된 db설정
		eMsResultSet pushListTableResult  = null;
		
		
		Properties tValue = new Properties();	
		
		try{
			this.TMS_PUSH_SELECT_STMT      = this.SOURCE_CONNECTION.createStatement();
			
			pushListTableResult =  this.TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE);
			
			while(pushListTableResult.next()){
				
				if(pushListTableResult.getString("LIST_TABLE1").equals(pushListTableResult.getString("LIST_TABLE2"))){
					tValue.setProperty("LIST_TABLE",pushListTableResult.getString("LIST_TABLE1").toString());
				}else{
					pushListTableResult.putToMap(tValue, false);					
				}
			}
			
			if(pushListTableResult != null){
				pushListTableResult.close();
			}
			
			for (Iterator iter = tValue.values().iterator(); iter.hasNext();) {
				String pushListTable = iter.next().toString();
				if(!pushListTable.equals("") && pushListTable != null){
					
					update_process(pushListTable);
				
				
				}else{
					log.debug("TARGET TABLE null ", this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE);
				}
					
			}
			
		}catch(Exception e){
			log.error("PushAutoSendListUpdator", "execute_main", e);
		}finally{
			
			if(pushListTableResult != null){
				pushListTableResult.close();
				pushListTableResult = null;
			}
			
		}
	}// end execute_main()

	
	public List fromResultSetToList(eMsResultSet rs, String tableName) throws Exception{
		List<Properties> pushResult = new ArrayList<Properties>();
		while(rs.next()){
			Properties pushSendResultValue = new Properties();
			pushSendResultValue.setProperty("PUSH_LIST_TABLE", tableName);
			rs.putToMap(pushSendResultValue, false);
			pushResult.add(pushSendResultValue);
		}
		return pushResult;
	}
	
	
	public void update_process(String list_table) throws Exception{
		
		log.debug("PushAutoSendListUpdator", "update_process", "=========================== AUTO SEND LIST UPDATE START ==============================");
		
		eMsResultSet PushPostIdResult  = null;
		eMsResultSet eMsRs  = null;
		Properties prePushSendResultValue = new Properties();
		ScheduleTblBean stBean = null;
		int result=0;
		boolean updateFlag = false;
		StringBuffer buff = new StringBuffer(512);
		
		try{
			prePushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
			
			//CHECK_FLAG '-' 를 'A'로 업데이트
			this.SOURCE_CONNECTION.setAutoCommit(false);
			
			//업데이트 칠 POST_ID를 가져 온다.
			PushPostIdResult = this.TMS_PUSH_SELECT_STMT.executeQuery(this.QUERY_TARGET_PUSH_POST_ID_QUERY ,prePushSendResultValue, "${", "}");
			
			List<Properties> pushPostIdList = fromResultSetToList(PushPostIdResult, list_table);
			
			if(pushPostIdList.size() <= 0) {
				return;
			}
			
			int cnt = 0;
			
			this.SOURCE_CONNECTION.setAutoCommit(false);
			
			for (Properties pushPostIdValue : pushPostIdList) {
				
				String post_id = pushPostIdValue.getProperty("POST_ID");
						
				String push_table =	pushPostIdValue.getProperty("LIST_TABLE");
				
				pushPostIdValue.setProperty("PUSH_TABLE", push_table);
				
				UPDATE_TMS_PUSH_LIST = UPDATE_TMS_PUSH_LIST.replaceAll("\\$\\{PUSH_TABLE}", push_table);
				
				this.PSTMT 	= SOURCE_CONNECTION.prepareStatement(UPDATE_TMS_PUSH_LIST,"${","}");
				
				this.OPEN_PSTMT 	= SOURCE_CONNECTION.prepareStatement(UPDATE_TMS_AUTO_SEND_OPEN,"${","}");
				
				this.CHECK_PSTMT 	= SOURCE_CONNECTION.prepareStatement(UPDATE_PUSH_CHECK_FLAG_FINAL,"${","}");
				
				try{
					//가져온 POST_ID 기준 으로 TMS_PUSH_LIST 테이블에 성공여부, 오픈, 클릭 건수 정보를 업데이트 한다.					
					//log.error("PushAutoSendListUpdator", "UPDATE_TMS_PUSH_LIST", StringUtil.ConvertQueryString(UPDATE_TMS_PUSH_LIST, pushPostIdValue, "${", "}"));
					
					eMsRs = this.TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_PUSH_SEND_QUE_LOG ,pushPostIdValue, "${", "}");
					int listCnt = 0;
					int openCnt = 0;
					
					while(eMsRs.next()){
						//listCnt +=	this.TMS_PUSH_UPDATE_STMT.executeUpdate( UPDATE_TMS_PUSH_LIST , pushPostIdValue , "${", "}");
						Properties p = new Properties();
						eMsRs.putToMap(p, false);
						//p.setProperty("PUSH_TABLE", push_table);
						listCnt += PSTMT.executeUpdateLong(p);
						
						// ### auto flow plan ###
						
						if(!p.getProperty("PUSHED_CNT", "0").equals("0")){
							p.setProperty("DATA_TYPE", "SEND");
							
							try{
								insertFlowPlanData(p);	
							}catch(Exception e){
								log.error("PushAutoSendListUpdator", "POST_ID :"+post_id+ " MEMBER_ID :"+p.getProperty("ORI_MEMBER_ID") +" ERROR MESSAGE : "+e.getMessage());
							}
							
						}
						
						if(!p.getProperty("OPEN_CNT", "0").equals("0")){
							p.setProperty("DATA_TYPE", "OPEN");
							
							try{
								insertFlowPlanData(p);
							}catch(Exception e){
								log.error("PushAutoSendListUpdator", "POST_ID :"+post_id+ " MEMBER_ID :"+p.getProperty("ORI_MEMBER_ID") +" ERROR MESSAGE : "+e.getMessage());
							}
						}
						
						if(!p.getProperty("CLICK_CNT", "0").equals("0")){
							p.setProperty("DATA_TYPE", "CLICK");
							insertFlowPlanData(p);
						}
						
						//openCnt +=	this.TMS_PUSH_UPDATE_STMT.executeUpdate( UPDATE_TMS_AUTO_SEND_OPEN , p , "${", "}");
						//OPEN_CNT 값이 있을 경우에만 TMS_AUTO_SEND_OPEN에 업데이트 한다.
						if(!p.getProperty("OPEN_CNT", "0").equals("0")){
							openCnt += OPEN_PSTMT.executeUpdateLong(p);
						}
						// ######################
						//cnt += checkFlagSwitching(UPDATE_PUSH_CHECK_FLAG_FINAL);
						cnt += CHECK_PSTMT.executeUpdateLong(p);
						
						if(listCnt % 5000 == 0){
							log.error("PushAutoSendListUpdator", "POST_ID :"+post_id+ " TMS_PUSH_LIST :"+listCnt+" TMS_CAMP_SEND_OPEN :"+openCnt);
							
							this.SOURCE_CONNECTION.commit();
						}
					}
					
					log.error("PushAutoSendListUpdator", "POST_ID :"+post_id+ " TMS_PUSH_LIST :"+listCnt+" TMS_AUTO_SEND_OPEN :"+openCnt);
					
					this.SOURCE_CONNECTION.commit();
					
				} catch(Exception e) {
					// e.printStackTrace();
					log.error("PushAutoSendListUpdator", "update_process", e);
				}
				
			}
			//switching.unLock();
		
			
			this.SOURCE_CONNECTION.commit();
			
			this.SOURCE_CONNECTION.setAutoCommit(true);

			//CHECK_FLAG '-' 를 'Y'로 업데이트
			//int cnt = checkFlagSwitching(UPDATE_PUSH_CHECK_FLAG_FINAL);
			log.debug("PushAutoSendListUpdator", "UPDATE_PUSH_CHECK_FLAG_QUERY", "CHECK_FLAG = '-' -> 'Y'  : "+cnt);
			
			log.debug("PushAutoSendListUpdator", "update_process", "=========================== AUTO SEND LIST UPDATE END ==============================");
			
			
			
		}catch(Exception e){
			// e.printStackTrace();
			log.error("PushAutoSendListUpdator", "update_process", e);
		}finally{
			
			/*if( SOURCE_CONNECTION != null ) {
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_SELECT_STMT);
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_UPDATE_STMT);
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_FLAG_STMT);
				SOURCE_CONNECTION.recycle();
			}*/
			
			if(PushPostIdResult != null){
				PushPostIdResult.close();
				PushPostIdResult = null;
			}
			if(eMsRs != null){
				eMsRs.close();
				eMsRs = null;
			}
			if(PSTMT != null){
				PSTMT.close();
				PSTMT = null;
			}
			
			if(OPEN_PSTMT != null){
				OPEN_PSTMT.close();
				OPEN_PSTMT = null;
			}
			
			if(CHECK_PSTMT != null){
				CHECK_PSTMT.close();
				CHECK_PSTMT = null;
			}
		}
	}
	
	/*
	[table : PLAN_ACT_LIST]
	
	create table PLAN_ACT_LIST(
			SRC_WORKDAY       varchar(8) NOT NULL, 
			SRC_SEQNO         decimal(9,0) NOT NULL,
			SRC_MEMBER_ID     varchar(20) NOT NULL,
			SRC_MEMBER_ID_SEQ varchar(10) NOT NULL,
			SRC_LIST_TABLE    varchar(100) DEFAULT NULL,
			MSG_TYPE          varchar(3) NOT NULL,
			MSG_TYPE_SEQ      varchar(3) NOT NULL,
			PLAN_STATUS       varchar(2) NOT NULL,
			PLAN_DAY          varchar(5) ,
			PLAN_HOUR         varchar(10) ,
			T_DATE            datetime,  -- 로그 일시
			ACT_DATE          datetime,  -- 작업할 일시
			REG_DATE          datetime,  -- 등록일시
			SEND_FLAG_DATE    datetime   -- 발송 완료시 update
	)
	*/
	/**
	 * 
	 * @param target
	 * @return
	 * @throws Exception 
	 */
	protected String insertFlowPlanData(Object target) throws Exception{
		Properties propLogData = ( Properties )target;
		
		String  dataType = propLogData.getProperty("DATA_TYPE");
		boolean isResend = propLogData.getProperty("IS_RESEND", "false").equals("true");
		int     failCnt  = Integer.parseInt(propLogData.getProperty("FAIL_CNT")); 
		
				
		String postId    = propLogData.getProperty( Log.LOG_MAIL_ID );
		
//		String workday   = propLogData.getProperty( Log.LOG_WORKDAY );
//		String seqNo     = propLogData.getProperty( Log.LOG_SEQNO );
//		String mId       = propLogData.getProperty( Log.LOG_MEMBER_ID );
//		String mIdSeq    = propLogData.getProperty( Log.LOG_MEMBER_ID_SEQ );
//		String listTable = propLogData.getProperty( Log.LOG_LIST_TABLE );
		
		String actType   = "SKIP";
		
		if(dataType.equals("SEND")){
			if(failCnt > 0){
				actType = "FAIL";
			}else{
				if(isResend){
					actType = "SUCCESS_RETRY";
				}else{
					actType = "SUCCESS_FIRST";
				}
			}
			
		}else if(dataType.equals("OPEN")){
			actType = "OPEN";
			
		}else if(dataType.equals("CLICK")){
			actType = "CLICK";
		}else{
			return "SKIP";
		}
		
		
		
		//static hashtable에서 post_id에 해당하는 bean을 가져옴
		PlanBean bean = PlanBean.getPlanBean(postId);
		if(bean == null){
			bean = new PlanBean();
			/*
			SELECT B.MSG_TYPE     AS MSG_TYPE,
				   B.MSG_TYPE_SEQ AS MSG_TYPE_SEQ,
				   B.PLAN_DAY     AS PLAN_DAY,
				   B.PLAN_HOUR    AS PLAN_HOUR,
				   B.PLAN_STATUS  AS PLAN_STATUS
			  FROM TMS_AUTO_SCHD_INFO A, 
			       TMS_AUTO_MSG_INFO B
			 WHERE A.WORKDAY = '${WORKDAY}'
			   AND A.SEQNO = '${SEQNO}'
			   AND A.MSG_TYPE = B.PLAN_PARENT_MSG_TYPE
			   AND A.MSG_TYPE_SEQ = B.PLAN_PARENT_MSG_TYPE_SEQ
			   AND B.CHANNEL_TYPE= 'PU' 
			 */
			//preparedStatement를 생성
			if(PPS_SELECT_FLOW_DATA == null){
				PPS_SELECT_FLOW_DATA = SOURCE_CONNECTION.prepareStatement(QUERY_SELECT_PLAN_INFO,"${","}");
			}
			
			eMsResultSet rsFlowData = PPS_SELECT_FLOW_DATA.executeQuery(propLogData);
			
			ArrayList    arrTarget  = new ArrayList();
			
			while(rsFlowData.next()){
				Properties prop = new Properties();
				
				prop.setProperty("MSG_TYPE",    rsFlowData.getString("MSG_TYPE"));
				prop.setProperty("MSG_TYPE_SEQ",rsFlowData.getString("MSG_TYPE_SEQ"));
				prop.setProperty("PLAN_DAY",    rsFlowData.getString("PLAN_DAY"));
				prop.setProperty("PLAN_HOUR",   rsFlowData.getString("PLAN_HOUR"));
				prop.setProperty("PLAN_STATUS", rsFlowData.getString("PLAN_STATUS"));
				
				arrTarget.add(prop);
			}
			
			bean.setPostId(postId);
			bean.setArrTarget(arrTarget);
			
			//static hashtable에 저장
			PlanBean.setPlanBean(bean);
		}
		
		
		
		//plan 이 아닐경우 skip
		if(!bean.isPlanYn()){
			return "SKIP";
		}

		ArrayList<Properties> dataList = bean.getArrTarget();
		
		int    dataCnt    = dataList.size();
		String msgType    = "";
		String msgTypeSeq = "";
		String planStatus = "";
		String planDay    = "";
		String planHour   = "";
		
		boolean actFlag   = false;
		
		//insert
		for(int i=0; i< dataCnt; i++){
			Properties propPlanData = dataList.get(i);
			
			msgType      = propPlanData.getProperty("MSG_TYPE");
			msgTypeSeq   = propPlanData.getProperty("MSG_TYPE_SEQ");
			planStatus   = propPlanData.getProperty("PLAN_STATUS");
			planDay      = propPlanData.getProperty("PLAN_DAY");
			planHour     = propPlanData.getProperty("PLAN_HOUR");
			
			/*
			 * 유효데이터인지 검증
			 */
			if(log.isDebugEnabled()){
				log.debug("[planStatus]"+planStatus+"[actType]"+actType);
			}
			
			if( "A".equals(planStatus)){ //전체
				if( "SUCCESS_FIRST".equals(actType) || "FAIL".equals(actType) ){ //첫번째 성공, 첫번째 실패 건 합
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:ALL> SUCCESS_FIRST / FAIL");
					}
				}else{
					continue;
				}
			}else if( "S".equals(planStatus)){ //성공
				if( "SUCCESS_FIRST".equals(actType) || "SUCCESS_RETRY".equals(actType) ){ //모든 성공
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:SUCCESS> SUCCESS_FIRST / SUCCESS_RETRY");
					}
				}else{
					continue;
				}
			}else if( "F".equals(planStatus)){ //실패
				if( "FAIL".equals(actType) ){ // 첫번째 실패만 처리
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:FAIL> FAIL_FIRST");
					}
				}else{
					continue;
				}
			}else if( "O".equals(planStatus)){ //오픈
				if( "OPEN".equals(actType) ){
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:OPEN> OPEN");
					}
				}else{
					continue;
				}
			}else if( "C".equals(planStatus)){ //클릭
				if( "CLICK".equals(actType) ){
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:CLICK> CLICK");
					}
				}else{
					continue;
				}
			}else{
				continue;
			}
						
			propLogData.setProperty("MSG_TYPE",     msgType);
			propLogData.setProperty("MSG_TYPE_SEQ", msgTypeSeq);
			propLogData.setProperty("PLAN_STATUS",  planStatus);
			propLogData.setProperty("PLAN_DAY",     StringUtil.isNull(planDay)?"0":planDay );
			propLogData.setProperty("PLAN_HOUR",    StringUtil.isNull(planHour)?"0":planHour);

			/*
			INSERT INTO PLAN_ACT_LIST(
				SRC_WORKDAY, SRC_SEQNO, SRC_MEMBER_ID, SRC_MEMBER_ID_SEQ, SRC_LIST_TABLE,
				MSG_TYPE, MSG_TYPE_SEQ,
				PLAN_STATUS, PLAN_DAY, PLAN_HOUR,
				T_DATE, 
				ACT_DATE, 
				REG_DATE )
			VALUES (
				'${WORKDAY}','${SEQNO}','${M_ID}','${M_ID_SEQ}','${LIST_TABLE}',
				'${MSG_TYPE}','${MSG_TYPE_SEQ}',
				'${PLAN_STATUS}','${PLAN_DAY}','${PLAN_HOUR}',
				DATE_FORMAT( '${T_DATE}' , '%Y-%m-%d %H:%i:%S' ),
				DATE_SUB(DATE_SUB(DATE_FORMAT( '${T_DATE}', '%Y-%m-%d %H:%i:%S' ), INTERVAL (-1*${PLAN_DAY}) DAY), INTERVAL (-1*${PLAN_HOUR}) HOUR),
				NOW() )
			 */
			//preparedStatement를 생성
			
			if(PPS_INSERT_FLOW_DATA == null){
				PPS_INSERT_FLOW_DATA = SOURCE_CONNECTION.prepareStatement(this.QUERY_INSERT_FLOW_DATA,"${","}");
			}
			
			int cnt_insert = PPS_INSERT_FLOW_DATA.executeUpdate(propLogData);
			if(cnt_insert != 1){
				log.debug("[ERROR] insert fail <FLOW_DATA> "+propLogData.toString());
			}else{
				actFlag = true;
			}
			
		}//end of for
		
		if(!actFlag){
			actType = "no Match";
		}
		
		return actType;
	}
	
	/**
	 * Switching Query : CHECK_FLAG 업데이트 ['-' -> 'A' -> 'Y'] 
	 * @param query
	 * @return
	 * @throws Exception
	 */
	/*private int checkFlagSwitching(String query) throws Exception {
		//SwitchingService switching = SwitchingFactory.getSwitchingFactory().getInstance("push");
		try {
			//switching.doLock();

			int checkFlag = this.TMS_PUSH_FLAG_STMT.executeUpdate(query);
			
			return checkFlag;
		} catch (Exception e) {
			throw e;
		}finally{
			try {
				//switching.unLock();
			} catch (Exception e2) {
				throw e2;
			}
		}
		
	}*/
	
	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		// 반환할 자원이 없다.
	}
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("PushAutoSendListUpdator_at_".concat(Cal.getSerialDate()));
	}
	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error("PushAutoSendListUpdator", "init error", thw);
	}
}// end class
