/*
 * Created on 2010. 8. 15.
 */
package jupiter.mass.log.updator;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
/**
 * @author 에이메일  push UPDATE
 */
@Slf4j
public class PushAutoCountUpdator extends pluto.schedule.Task {

	

	private static ConnectInfo	TARGET_CONNECT_INFO					= null;

	static {
		TARGET_CONNECT_INFO = new ConnectInfo();
		TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("push.db.driver"));
		TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("push.db.url"));
		TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("push.db.id"));
		TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("push.db.pass"));
		TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("push.db.init"));
		TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("push.db.base.charset"));
		TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("push.db.out.charset"));
		TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("push.db.in.charset"));
	}

	/**
	 * push 디비 접속(SOURCE)
	 */
	protected eMsConnection			SOURCE_CONNECTION					= null;
	/**
	 * push 디비 접속 (TARGET ---> TBL_ORG_SM_TRAN, TBL_SM_TRAN, TBL_SM_QUEUE)
	 */
	/**
	 * TMS DB SELECT
	 */
	private eMsStatement			TMS_PUSH_SELECT_STMT				= null;
	
	private eMsStatement			TMS_PUSH_SELECT_STMT2				= null;
	/**
	 * TMS DB UPDATE
	 */
	private eMsStatement			TMS_PUSH_UPDATE_STMT				= null;
	/**
	 * TMS DB INSERT
	 */
	private eMsStatement			TMS_PUSH_FLAG_STMT				= null;
	/**
	 * MODULE DB SELECT
	 */
	
	/**
	 * 모듈 로그 테이블 가져온다~~~
	 */
	private String				SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE 	= null;
	/**
	 * 결과셋을 가져오는 쿼리
	 */
	private String				QUERY_TARGET_PUSH_POST_ID_QUERY			= null;
	/**
	 * 리스트테이블 TMS_SCHD_INFO 결과 업데이트
	 */
	private String				UPDATE_SCHEDULE_INFO_SUMMARY_QUERY= null;
	
	private String 				QUERY_TARGET_PUSH_COUNT_POST_ID_QUERY		= null;
	/**
	 * 리스트테이블 TMS_SCHD_INFO OPEN 건수 업데이트
	 */
	
	private String 				UPDATE_PUSH_CHECK_FLAG_QUERY					= null;

	
	/**
	 * PUSH DB 작업 결과 일괄 업데이트 처리[TB_SEND_QUE_LOG.CHECK_FLAG='-' TO 'Y'] 
	 */
	private String 				UPDATE_PUSH_CHECK_FLAG_FINAL				= null;
	
	private String 				SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY		= null;
	
	private String 				UPDATE_TMS_PUSH_LIST						= null;
	
	private String 				UPDATE_TMS_CAMP_SEND_OPEN						= null;
	
	private String 				UPDATE_TMS_CAMP_SEND_CLICK						= null;
	
	public PushAutoCountUpdator() {
		
		super(TYPE_INTERVAL,2);
		this.setName("PushAutoCountUpdator");
		this.setTaskID("PushAutoCountUpdator");
		
		this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE = SqlManager.getQuery("AUTO_UPDATE", "SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE");
		
		this.QUERY_TARGET_PUSH_POST_ID_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_TARGET_PUSH_POST_ID_QUERY");
		this.UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
		this.UPDATE_PUSH_CHECK_FLAG_QUERY = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_PUSH_CHECK_FLAG_QUERY");
		this.SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY = SqlManager.getQuery("AUTO_UPDATE", "SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY");
		this.QUERY_TARGET_PUSH_COUNT_POST_ID_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_TARGET_PUSH_COUNT_POST_ID_QUERY");
		
		this.UPDATE_PUSH_CHECK_FLAG_FINAL = SqlManager.getQuery("AUTO_UPDATE","UPDATE_PUSH_CHECK_FLAG_FINAL");		// TMS_CAMP_SEND_CLICK
		
		this.UPDATE_TMS_PUSH_LIST = SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_PUSH_LIST");
		this.UPDATE_TMS_CAMP_SEND_OPEN = SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_CAMP_SEND_OPEN");
		this.UPDATE_TMS_CAMP_SEND_CLICK = SqlManager.getQuery("AUTO_UPDATE","UPDATE_TMS_CAMP_SEND_CLICK");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pluto.push.module.PUSHCall#execute()
	 */
	public void execute() {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushAutoCountUpdator===> execute()");
		}
		try {
			// 자원 초기화
			this.execute_init();
			// 메인 프로세스
			this.execute_main();
		}
		catch(Throwable thw) {
			log.error("PushAutoCountUpdator", "CALL execute() ERROR", thw);
			//thw.printStackTrace();
		}
		finally {
			// 자원반환.
			this.releaseResource();
		}
	}

	/**
	 * 초기화하면서 사용할 자원을 할당한다.
	 * @throws Throwable
	 *         초기화 에러.
	 */
	protected void execute_init() throws Throwable {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushAutoCountUpdator===> execute_init()");
		}
		//eMs DB 접속 Connection
		//this.SOURCE_CONNECTION = ConnectionPool.getConnection();
		
		
		
		//feelingk DB 접속 Connection
		/*this.TARGET_CONNECTION = ConnectionPool.getConnection(TARGET_CONNECT_INFO);
		
		this.TARGET_CONNECTION_UPDATE = ConnectionPool.getConnection(TARGET_CONNECT_INFO);*/
		
		//this.TMS_PUSH_SELECT_STMT      = this.SOURCE_CONNECTION.createStatement();
		
		//this.TMS_PUSH_UPDATE_STMT      = this.SOURCE_CONNECTION.createStatement();
		
		//this.TMS_PUSH_FLAG_STMT      = this.SOURCE_CONNECTION.createStatement();
		
		//this.MODULE_PUSH_SELECT_STMT 		= this.TARGET_CONNECTION.createStatement();
		
		//this.MODULE_PUSH_UPDATE_STMT 		= this.TARGET_CONNECTION.createStatement();
		
		//this.MODULE_PUSH_UPDATE_ALL_STMT 	= this.TARGET_CONNECTION_UPDATE.createStatement();
		
	}

	/**
	 * 종료시 진행중 할당받은 자원을 반한다.
	 */
	protected void releaseResource() {
		if (log.isDebugEnabled()) {
			log.debug("CALL PushAutoCountUpdator===> releaseResource()");
		}
		// TMS 대상 연결을 반환한다.
		if( this.SOURCE_CONNECTION != null ) {
			this.SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_SELECT_STMT);
			this.SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_UPDATE_STMT);
			this.SOURCE_CONNECTION.recycleStatement(this.TMS_PUSH_FLAG_STMT);
			this.SOURCE_CONNECTION.recycle();
		}
		// feelingk 대상 연결을 반환한다.		
		/*if( this.TARGET_CONNECTION != null ) {			
			this.TARGET_CONNECTION.recycleStatement(this.MODULE_PUSH_SELECT_STMT);
			this.TARGET_CONNECTION.recycleStatement(this.MODULE_PUSH_UPDATE_STMT);
			this.TARGET_CONNECTION.recycle();
		}
		
		if( this.TARGET_CONNECTION_UPDATE != null ) {			
			this.TARGET_CONNECTION_UPDATE.recycleStatement(this.MODULE_PUSH_UPDATE_ALL_STMT);
			this.TARGET_CONNECTION_UPDATE.recycle();
		}*/
		
	}

	protected void execute_main() throws Throwable {
		
		if (log.isDebugEnabled()) {
			log.debug("CALL PushAutoCountUpdator===> execute_main()");
		}
		// push_send_conf.xml에서 정의된 db설정
		eMsResultSet pushListTableResult  = null;
		
		
		Properties tValue = new Properties();	
		
		eMsConnection SOURCE_CONNECTION = null;
		
		try{
			SOURCE_CONNECTION = ConnectionPool.getConnection();
			
			TMS_PUSH_SELECT_STMT      = SOURCE_CONNECTION.createStatement();
			
			pushListTableResult =  TMS_PUSH_SELECT_STMT.executeQuery(this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE); 
			
			while(pushListTableResult.next()){
				
				if(pushListTableResult.getString("LIST_TABLE1").equals(pushListTableResult.getString("LIST_TABLE2"))){
					tValue.setProperty("LIST_TABLE",pushListTableResult.getString("LIST_TABLE1").toString());
				}else{
					pushListTableResult.putToMap(tValue, false);					
				}
			}
			
			if(pushListTableResult != null){
				pushListTableResult.close();
			}
			
			for (Iterator iter = tValue.values().iterator(); iter.hasNext();) {
				String pushListTable = iter.next().toString();
				if(!pushListTable.equals("") && pushListTable != null){
					
					// real update !!!!!!!!!!!!!!!!!!!!!!!!
					update_process(pushListTable);
				
				}else{
					log.debug("TARGET TABLE null ", this.SELECT_TARGET_PUSH_SEND_QUE_LOG_TABLE);
				}
					
			}
			
		}catch(Exception e){
			log.error("PushAutoCountUpdator", "execute_main", e);
		}finally{
			
			if( SOURCE_CONNECTION != null ) {
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_SELECT_STMT);
				SOURCE_CONNECTION.recycle();
			}
			
			if(pushListTableResult != null){
				pushListTableResult.close();
				pushListTableResult = null;
			}
			
		}
	}// end execute_main()

	
	public List fromResultSetToList(eMsResultSet rs, String tableName) throws Exception{
		List<Properties> pushResult = new ArrayList<Properties>();
		while(rs.next()){
			Properties pushSendResultValue = new Properties();
			pushSendResultValue.setProperty("PUSH_LIST_TABLE", tableName);
			rs.putToMap(pushSendResultValue, false);
			pushResult.add(pushSendResultValue);
		}
		return pushResult;
	}
	
	
	public void update_process(String list_table) throws Exception{
		
		log.error("PushAutoCountUpdator", "update_process", "=========================== AUTO UPDATE COUNT START ==============================");
		
		eMsResultSet PushPostIdResult  = null;
		eMsResultSet eMsRs  = null;
		eMsResultSet rs  = null;
		Properties prePushSendResultValue = new Properties();
		
		eMsConnection SOURCE_CONNECTION = null;
		
		try{
			SOURCE_CONNECTION = ConnectionPool.getConnection();
			
			TMS_PUSH_SELECT_STMT      = SOURCE_CONNECTION.createStatement();
			TMS_PUSH_SELECT_STMT2     = SOURCE_CONNECTION.createStatement();
			TMS_PUSH_UPDATE_STMT      = SOURCE_CONNECTION.createStatement();
			TMS_PUSH_FLAG_STMT        = SOURCE_CONNECTION.createStatement();
			
			
			prePushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
			
			eMsRs = TMS_PUSH_SELECT_STMT.executeQuery(QUERY_TARGET_PUSH_COUNT_POST_ID_QUERY);
			
			List<Properties> pushSendResult = fromResultSetToList(eMsRs, list_table);
			
			for (Properties pushPostIdValue : pushSendResult) {
				
				try{
					
					log.error("AUTO POST_ID : "+pushPostIdValue.getProperty("POST_ID"));
					
					rs = TMS_PUSH_SELECT_STMT2.executeQuery(SELECT_TARGET_PUSH_COUNT_SUMMARY_QUERY, pushPostIdValue, "${","}");
					
					Properties pushSendResultValue = new Properties();
					
					if(rs.next()){
						
						rs.putToMap(pushSendResultValue, false);
						
						TMS_PUSH_UPDATE_STMT.executeUpdate(UPDATE_SCHEDULE_INFO_SUMMARY_QUERY, pushSendResultValue, "${", "}");
					}
					//log.error("PushCampCountUpdator", "UPDATE_SCHEDULE_INFO_SUMMARY_QUERY", StringUtil.ConvertQueryString(UPDATE_SCHEDULE_INFO_SUMMARY_QUERY, pushSendResultValue, "${", "}"));
					
					
				
				} catch (Exception e) {
					//e.printStackTrace();
					log.error("PushCampCountUpdator", "update_process", e);
				}
			}
			

			
			log.error("PushAutoCountUpdator", "update_process", "=========================== AUTO UPDATE COUNT END ==============================");
		}catch(Exception e){
			//e.printStackTrace();
			log.error("PushAutoCountUpdator", "update_process", e);
		}finally{
			
			if( SOURCE_CONNECTION != null ) {
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_SELECT_STMT);
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_UPDATE_STMT);
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_SELECT_STMT2);
				SOURCE_CONNECTION.recycleStatement(TMS_PUSH_FLAG_STMT);
				SOURCE_CONNECTION.recycle();
			}
			
			if(PushPostIdResult != null){
				PushPostIdResult.close();
				PushPostIdResult = null;
			}
			if(eMsRs != null){
				eMsRs.close();
				eMsRs = null;
			}
			if(rs != null){
				rs.close();
				rs = null;
			}
		}
	}

	private void lastUpdate(ScheduleTblBean stBean, StringBuffer buff, String sql) throws SQLException {
		try {
			StringConvertUtil.ConvertString( buff , sql , stBean.getElement("MASS") , "${" , "}" , true , false );
			if(this.TMS_PUSH_UPDATE_STMT.executeUpdate(buff.toString())  < 1 ) {
				log.info("[SCHEDULE SUMMARY FAIL]:"+stBean.getName() +"_sql : " + sql);
			}
		} catch (Exception e) {
			log.error("last update error", e);
		}finally{
			buff.setLength(0);
		}
	}
	
	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		// 반환할 자원이 없다.
	}
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("PushAutoCountUpdator_at_".concat(Cal.getSerialDate()));
	}
	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error("PushAutoCountUpdator", "init error", thw);
	}
}// end class
