/*
 * @(#)UpdatorCheckTask.java            2016. 03. 25.
 *
 * Copyright (c) 1998-2011 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.log.updator;


import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.schedule.AlreadyRegistTaskException;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;
import pluto.util.convert.StringConvert;
import pluto.util.recycle.BufferedObjectPool;


/**
 * Class description :
 * 
 * @version
 * @author bhkim
 * 
 */
@Slf4j
public class MmsUpdatorCheckTask extends pluto.schedule.Task {

	private	static	String	MAX_THREAD_SIZE = "10";
	
	private	static	String	ONE_THREAD_CNT = "1000";
	
	private	static	String	CHANNEL_TYPE = "";
	
	private	static	String	UPDATE_CLASS_NAME = "";
	
	//업데이트할 대상의 MIN /MAX SEQ를 가져오는 쿼리
	public static 	String	QUERY_SELECT_TARGET_RANGE	= null;
	
	public static	String  QUERY_SELECT_TARGET_MMS_LIST_TABLE = null;
	/**
	 * 구동에 필요한 기본 static 변수의 초기화
	 */
	static {
		try {
			QUERY_SELECT_TARGET_RANGE = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_RANGE");
			
			QUERY_SELECT_TARGET_MMS_LIST_TABLE  = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_MMS_LIST_TABLE");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	protected 	eMsConnection		EMS_CONNECTION							= null;
	protected 	eMsStatement		__SELECT_SEARCH_STATEMENT__				= null;
	
	/** Creates a new instance of RealTimeCheckTask */
	public MmsUpdatorCheckTask() {
		super(TYPE_INTERVAL);
		this.setName("MmsUpdatorCheckTask_at_".concat(Cal.getSerialDate()));
		this.setTaskID("MmsUpdatorCheckTask");
	}

	
	public static void init(Object tmp) throws Exception {
		Properties prop = (Properties) tmp;
		ONE_THREAD_CNT = prop.getProperty("one.thread.cnt", "1000");//default size 1000.
		MAX_THREAD_SIZE = prop.getProperty("max.thread.size", "10");//default size 10.
		CHANNEL_TYPE = prop.getProperty("channel.type", "PU");//PU , SM , KA
		UPDATE_CLASS_NAME = prop.getProperty("update.class.name", "");
	}
	
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("MmsUpdatorCheckTask_at_".concat(Cal.getSerialDate()));
		if (log.isDebugEnabled()) {
			log.info( "MmsUpdatorCheckTask_START" );//for health check
		}
		EMS_CONNECTION = ConnectionPool.getConnection();
		
		try {
			__SELECT_SEARCH_STATEMENT__ = EMS_CONNECTION.createStatement();
		} catch (Exception e) {
			EMS_CONNECTION = ConnectionPool.getConnection();
			__SELECT_SEARCH_STATEMENT__ = EMS_CONNECTION.createStatement();
		}
		
	}

	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error(getName(), " Request Connection Error");
		log.error(getName(), thw);
	}

	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		if( EMS_CONNECTION != null ) {
			EMS_CONNECTION.recycleStatement(__SELECT_SEARCH_STATEMENT__);
			EMS_CONNECTION.recycle();
		}
	}
	
	/**
	 * 실제적인 일을 처리하는 비지니스로직
	 * 
	 * @return true : 성공적인 수행 <br>
	 *         false : 수행 실패
	 */
	public void execute() throws Exception {
		
		eMsResultSet __RESULT_OF_TARGET_RANGE = null;
		eMsResultSet __SMS_LIST_TABLE = null;
		Properties TARGET_RANGE_INFO = new Properties();
		Hashtable info = null;
		Properties tValue = new Properties();
		
		
		
		
		try {
			__SMS_LIST_TABLE = __SELECT_SEARCH_STATEMENT__.executeQuery(QUERY_SELECT_TARGET_MMS_LIST_TABLE);
			while(__SMS_LIST_TABLE.next()){			
				if(__SMS_LIST_TABLE.getString("LIST_TABLE1").equals(__SMS_LIST_TABLE.getString("LIST_TABLE2"))){
					tValue.setProperty("LIST_TABLE",__SMS_LIST_TABLE.getString("LIST_TABLE1").toString());
				}else{
					__SMS_LIST_TABLE.putToMap(tValue, false);					
				}
			}	
			int th_id=1;
			for (Iterator iter = tValue.values().iterator(); iter.hasNext();) {
				String smsListTable = iter.next().toString();
				info = new Hashtable();
				info.put("SMS_LIST_TABLE", smsListTable);
				__RESULT_OF_TARGET_RANGE = this.__SELECT_SEARCH_STATEMENT__.executeQuery(QUERY_SELECT_TARGET_RANGE ,info, "${", "}");
						
				while(__RESULT_OF_TARGET_RANGE.next()){
					__RESULT_OF_TARGET_RANGE.putToMap(TARGET_RANGE_INFO, false);
				}
				//수행할 대상이 있는지 판단. 없을 경우는 종료
				if(TARGET_RANGE_INFO.size() > 0){
					if(Integer.parseInt(TARGET_RANGE_INFO.getProperty("TO_CNT")) > 0){
						
						info = getThreadInfo(TARGET_RANGE_INFO.getProperty("MIN_ID") , TARGET_RANGE_INFO.getProperty("MAX_ID"), smsListTable, th_id++);
						for (Enumeration myEnum = info.elements(); myEnum.hasMoreElements();) {
							TARGET_RANGE_INFO = (Properties) myEnum.nextElement();
							try {
								log.debug("TEST",TARGET_RANGE_INFO.toString());
								execute_createTask(TARGET_RANGE_INFO);
							}
							catch(Exception e) {
								log.error("POOL FLUSH EXCEPTION", e);
							}
						}
					}
				
				}else{
					log.info("no data skip .....[OK]");
				}
			}
		}catch(Exception e) {
			log.error("MMS update error", e);
			throw e;
		}finally{
			try {
				if(__RESULT_OF_TARGET_RANGE != null){
					__RESULT_OF_TARGET_RANGE.close();
				}
				//2017.03.07
				if(__SMS_LIST_TABLE != null){
					__SMS_LIST_TABLE.close();
				}
				
			}catch(Exception ignore){
			}
		}
		if (log.isDebugEnabled()) {
			log.debug("START is execute execute_createTask method...[OK]");
		}
	}

	/**
	 * 조건에 걸리는 녀석들을 집어 내어 MakeSendInfoTask 로 만들어 TaskManager에 등록을 한다. step :
	 * START 에서 실행 된다.
	 */
	private synchronized void execute_createTask(Properties info) throws Exception {
		
		
		try {
			
			try {
				Task make_info = (Task)getInstance(UPDATE_CLASS_NAME);
				/**
				 * 스케쥴을 초기화 한다.
				 */
				make_info.setTaskProperty(info);
				/**
				 * 등록한다.
				 */
				TaskManager.executeTask(make_info);
				
				
				try {
					wait(500);
				}catch(Exception e) {
				}
			} catch(AlreadyRegistTaskException e) {
				log.error("AlreadyRegistTaskException is skip");
			} catch (Exception e) {
				log.error(getName(), e);
			}
		}catch(Exception e) {
			log.error(e.getMessage());
			throw e;
		}finally {
			
		}
	}
	
	
	/**
	 * 
	 * @param min : 수행할 최소 seq
	 * @param max : 수행할 최대 seq
	 * @return	Hashtable : key - 스래드순번 , value - Properties (해당스래드의 min/max)
	 * @throws Exception
	 */
	public static Hashtable getThreadInfo( String min , String max , String listTable, int th_id) throws Exception {
		// 하나의 스래드가 수행할 최대건수
		int oneThreadCnt = Integer.parseInt(ONE_THREAD_CNT);
		// 스래드 갯수
		int threadSize = 1;
		long maxSeq = Long.parseLong(max);
		long minSeq = Long.parseLong(min);
		//수행할 건수
		int range = (int) (maxSeq-minSeq);
		Properties info = null;
		
		Hashtable selectInfo = new Hashtable();
		//남은 건수 
		int remain = range;
		
		log.info("range ==> {}", range);
		threadSize = divideCeil(remain,oneThreadCnt);
		
		if(threadSize > 10){
			threadSize = 10;
			oneThreadCnt = divideCeil(remain,threadSize);
		}
		
		log.info("threadSize ==> {}", threadSize);
		log.info("oneThreadCnt ==> {}", oneThreadCnt);
		
		if(threadSize == 1 || maxSeq == minSeq){
			info = new Properties();
			info.setProperty("MAX_ID", Long.toString(maxSeq));
			info.setProperty("MIN_ID",	Long.toString(minSeq));
			info.setProperty("SMS_LIST_TABLE",	listTable);
			info.setProperty("THREAD_ID",	Integer.toString(th_id));
			selectInfo.put("1", info);
			return selectInfo;
		}
		
		long maxVal =0; 
		long minVal =0;
		
		for(int i=0;i<threadSize;i++){
			info = new Properties();
			maxVal = maxSeq-(oneThreadCnt*i);
			if(i+1 == threadSize){
				minVal = minSeq;
			}else{
				minVal = maxVal-oneThreadCnt;
			}
			info.setProperty("MAX_ID", Long.toString(maxVal));
			info.setProperty("MIN_ID",	Long.toString(minVal));
			info.setProperty("THREAD_ID",	Integer.toString(i));
			log.info("info : {}", info.toString());
			selectInfo.put(Integer.toString(i), info);
		}
		return selectInfo;
	}

	public Object getInstance( String className ) throws Exception {
		
		Class classes = Class.forName( className );
		
		return classes.newInstance();
	}
	//나는 몫을 올림으로 구한다. (11, 2) = 6
	public static int divideCeil(int a1, int b1) {
		int returnStr = 0;
		try {
			float leaves = a1%b1;
			
			int temp = 0;
			if (leaves!= 0)
				temp = (a1/b1) + 1;
			else
				temp = a1/b1;
			
			returnStr = temp;
			return returnStr;
		} catch(Exception e) {
			return returnStr;
		}
    }    
}
