/*
 * @(#)MassStateLogUpdator.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.mass.log.updator;

import java.util.List;
import java.util.Properties;

import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;
/**
 * 대량 메일 발송 상태값의 업데이트를 담당한다.
 * 
 * @version		
 * @author 		dragon
 *
 */
public class MassStateLogUpdator extends LogUpdatorImpl  {
	
	protected static List QUERY_UPDATE_INFO_STATE = null;
	
	protected static List QUERY_UPDATE_INFO_START = null;
	
	protected static List QUERY_UPDATE_INFO_STOP = null;
	
	protected static List QUERY_UPDATE_INFO_END = null;

	protected static List QUERY_UPDATE_INFO_RETRY_START = null;
	
	protected static List QUERY_UPDATE_INFO_QUE_RETRY_START = null;
	protected static List QUERY_UPDATE_INFO_QUE_RETRY_END = null;
	
	static{
		QUERY_UPDATE_INFO_STATE = SqlManager.getMultiQuery("WINDFORCE_STATE_LOG_UPDATE","QUERY_UPDATE_INFO_STATE");

		QUERY_UPDATE_INFO_START = SqlManager.getMultiQuery("WINDFORCE_STATE_LOG_UPDATE","QUERY_UPDATE_INFO_START");
		QUERY_UPDATE_INFO_STOP = SqlManager.getMultiQuery("WINDFORCE_STATE_LOG_UPDATE","QUERY_UPDATE_INFO_STOP");
		QUERY_UPDATE_INFO_END = SqlManager.getMultiQuery("WINDFORCE_STATE_LOG_UPDATE","QUERY_UPDATE_INFO_END");
		
		QUERY_UPDATE_INFO_RETRY_START = SqlManager.getMultiQuery("WINDFORCE_STATE_LOG_UPDATE","QUERY_UPDATE_INFO_RETRY_START");
		
		QUERY_UPDATE_INFO_QUE_RETRY_START = SqlManager.getMultiQuery("WINDFORCE_STATE_LOG_UPDATE","QUERY_UPDATE_INFO_QUE_RETRY_START");
		QUERY_UPDATE_INFO_QUE_RETRY_END = SqlManager.getMultiQuery("WINDFORCE_STATE_LOG_UPDATE","QUERY_UPDATE_INFO_QUE_RETRY_END");
		
	}

	
	
	/** Creates a new instance of MassStateLogUpdator */
	public MassStateLogUpdator() {
	}
	
	/** 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object log) throws Exception {
		
		Properties __LOG_DATA__ = ( Properties )log;
		
		String __T_TYPE__ = __LOG_DATA__.getProperty( LOG_T_TYPE );
		String __T_CODE__ = __LOG_DATA__.getProperty( LOG_T_CODE );
		
		/**41 발송 상태 업데이트 일경우 20/70 테이블에 업데이트를 한다.
		 */
		if(__T_TYPE__.equals("41") ) {
			executeUpdateList( QUERY_UPDATE_INFO_STATE , log );
			//update_list = QUERY_UPDATE_INFO_STATE.iterator();
		}
		/** 90-00 발송 정지 에 대한 업데이트
		 */
		else if(__T_TYPE__.equals("90") && __T_CODE__.equals("00")) {
			return "OK";
		}
		/** 90-30 발송 시작에 대한 업데이트
		 */
		//else if(__T_TYPE__.equals("90") && __T_CODE__.equals("30")) {
		//	executeUpdateList( QUERY_UPDATE_INFO_START , log );
			//update_list = QUERY_UPDATE_INFO_START.iterator();
		//}
		/** 90-32 발송 정지에 대한 업데이트
		 */
		else if(__T_TYPE__.equals("90") && __T_CODE__.equals("32")) {
			executeUpdateList( QUERY_UPDATE_INFO_STOP , log );
			//update_list = QUERY_UPDATE_INFO_STOP.iterator();
		}
		/** 90-40 발송 종료에 대한 업데이트
		 */
		/*else if(__T_TYPE__.equals("90") && __T_CODE__.equals("40")) {
			executeUpdateList( QUERY_UPDATE_INFO_END , log );
			//update_list = QUERY_UPDATE_INFO_END.iterator();
		}
		*//** 90-35 실패메일 재발송 시작에 대한 업데이트
		 */
		/*else if(__T_TYPE__.equals("90") && __T_CODE__.equals("36")) {
			executeUpdateList( QUERY_UPDATE_INFO_RETRY_START , log );
			//update_list = QUERY_UPDATE_INFO_RETRY_START.iterator();
		}
		*//** 90-46 에러메일 재발송 시작에 대한 업데이트
		 *//*
		else if(__T_TYPE__.equals("95") && __T_CODE__.equals("46")) {
			executeUpdateList( QUERY_UPDATE_INFO_QUE_RETRY_START , log );
			//update_list = QUERY_UPDATE_INFO_QUE_RETRY_START.iterator();
		}*/
		else if(__T_TYPE__.equals("95") && __T_CODE__.equals("40")) {
			executeUpdateList( QUERY_UPDATE_INFO_QUE_RETRY_END , log );
			//update_list = QUERY_UPDATE_INFO_QUE_RETRY_END.iterator();
		}
		else{
			return "NO";
		}
		
		return "OK";
	}
	
}

