/*
 * @(#)MassSendBasicSepCodeLogUpdator.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.log.updator;

import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;
import pluto.db.eMsResultSet;

/**
 * <br>
 * 대량 메일 에러 로그 업데이트에 대한 규칙을 제공한다. <br>
 * 여러번 재발송 하는 경우 이전 에러 값을 참조하여 업데이트 한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class MassSendBasicSepCodeLogUpdator extends LogUpdatorImpl {

	protected static List			QUERY_UPDATE_SEND_START			= null;

	protected static String			QUERY_UPDATE_20_QUE_SUCCESS		= null;

	protected static String			QUERY_UPDATE_60_SUCCESS			= null;

	protected static String			QUERY_UPDATE_60_ERROR			= null;

	protected static String			QUERY_UPDATE_20_QUE_ERROR		= null;

	protected static String			QUERY_UPDATE_20_ERROR			= null;

	protected static String			QUERY_SELECT_CURRENT_ERROR_CODE	= null;

	static {
		try {
			QUERY_UPDATE_SEND_START = SqlManager.getMultiQuery("MASS_SEND_LOG_UPDATE", "QUERY_UPDATE_SEND_START");

			QUERY_UPDATE_20_QUE_SUCCESS = SqlManager.getQuery("MASS_SEND_LOG_UPDATE", "QUERY_UPDATE_20_QUE_SUCCESS");

			QUERY_UPDATE_20_QUE_ERROR = SqlManager.getQuery("MASS_SEND_LOG_UPDATE", "QUERY_UPDATE_20_QUE_ERROR");

			QUERY_UPDATE_20_ERROR = SqlManager.getQuery("MASS_SEND_LOG_UPDATE", "QUERY_UPDATE_20_ERROR");

			QUERY_UPDATE_60_SUCCESS = SqlManager.getQuery("MASS_SEND_LOG_UPDATE", "QUERY_UPDATE_60_SUCCESS");

			QUERY_UPDATE_60_ERROR = SqlManager.getQuery("MASS_SEND_LOG_UPDATE", "QUERY_UPDATE_60_ERROR");

			QUERY_SELECT_CURRENT_ERROR_CODE = SqlManager.getQuery("MASS_SEND_LOG_UPDATE", "QUERY_SELECT_CURRENT_ERROR_CODE");
		}
		catch(Exception e) {
			log.error("Exception", e);
			//e.printStackTrace();
			System.exit(1);
		}
	}

	

	/** Creates a new instance of MassSendBasicSepCodeLogUpdator */
	public MassSendBasicSepCodeLogUpdator() {
	}

	/**
	 * 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object log) throws Exception {

		Properties __LOG_DATA__ = (Properties) log;

		String __T_TYPE__ = __LOG_DATA__.getProperty(LOG_T_TYPE);
		String __T_CODE__ = __LOG_DATA__.getProperty(LOG_T_CODE);

		int __QUE_STEP__ = 0;

		try {
			__QUE_STEP__ = Integer.parseInt(__LOG_DATA__.getProperty(LOG_STEP));
		}
		catch(Exception _ex) {
		}
		/**
		 * 54-00 메일발송시작 업데이트
		 */
		if( __T_TYPE__.equals("54") && __T_CODE__.equals("--") ) {
			/* 큐발송일 경우에는 카운트를 올리지 않는다 */
			if( __QUE_STEP__ != 0 ) {
				return "QUE OR EXT SEND";
			}

			executeUpdateList(QUERY_UPDATE_SEND_START, log);

			return "START";
		}

		/**
		 * 54-10 발송성공에 대한 업데이트
		 */
		if( __T_TYPE__.equals("54") && __T_CODE__.equals("00") ) {
			/* 큐발송에서 성공할 경우 */
			if( __QUE_STEP__ > 0 ) {
				/**
				 * 큐는 기타오류에서 성공한것 이기 때문에 20 테이블의 카운트를조절해야한당....
				 */
				/**
				 * 예전에 어떤 에러였는지를알아와야한다.
				 */
				eMsResultSet RS = null;
				try {
					RS = executeQuery(QUERY_SELECT_CURRENT_ERROR_CODE, __LOG_DATA__);
					if( RS.next() ) {
						RS.putToMap(__LOG_DATA__, false);
						String curr = __LOG_DATA__.getProperty("CURRENT_CODE");
						if( curr.equals("00") )
							return "BEFORE SUCCESS AND NOW SUCCESS?";
					}
					else {
						return "NO CURRENT DATA";
					}
				}
				catch(Exception e) {
					throw e;
				}
				finally {
					if(RS != null)
						RS.close();
				}
			}
			/* 일단 리스트 테이블의 플래그를 업데이트 한다. */
			executeUpdate(QUERY_UPDATE_60_SUCCESS, __LOG_DATA__);

			if( __QUE_STEP__ > 0 ) {
				executeUpdate(QUERY_UPDATE_20_QUE_SUCCESS, __LOG_DATA__);
				return "QUE SUCCESS OK";
			}
			return "1ST OK";
		}

		/**
		 * 55-00스풀링 단계가 다 끝났다고 하는 거가 오면
		 */
		if( __T_TYPE__.equals("55") && __T_CODE__.equals("00") ) {
			/* 큐처리가 종료된다는 것을 마킹하는 것이 필요하다. 현재는 그런 로직이 없으므로 .. 일단은 skip */
			return "OK";
		}

		/**
		 * 자 ... 에러가 발생을 했습니다.
		 */
		if( __T_TYPE__.equals("55") ) {

			if( __QUE_STEP__ > 0 ) {
				/**
				 * 예전에 어떤 에러였는지를알아와야한다.
				 */
				eMsResultSet RS = null;
				try {
					RS = executeQuery(QUERY_SELECT_CURRENT_ERROR_CODE, __LOG_DATA__);
					if( RS.next() ) {
						RS.putToMap(__LOG_DATA__, false);
					}
					else {
						return "NO CURRENT DATA";
					}
				}
				catch(Exception e) {
					throw e;
				}
				finally {
					if(RS != null)
						RS.close();
				}

				String CURRENT_ERROR_CODE = __LOG_DATA__.getProperty("CURRENT_CODE");

				// 기존 에러코드와 동일하다면 업데이트 필요가 없다.
				if( __T_CODE__.equals(CURRENT_ERROR_CODE) ) {
					return "QUE SAME ERROR SKIP";
				}
			}

			/**
			 * 일단 제일먼저 60테이블에 에러코드를 업데이트 한다.
			 */
			executeUpdate(QUERY_UPDATE_60_ERROR, __LOG_DATA__);

			if( __QUE_STEP__ > 0 ) {
				executeUpdate(QUERY_UPDATE_20_QUE_ERROR, __LOG_DATA__);
				return "QUE DEF ERROR OK";
			}
			executeUpdate(QUERY_UPDATE_20_ERROR, __LOG_DATA__);
			return "FIRST ERROR OK";
		}
		return "NO UPDATE";
	}
}
