/*
 * Created on 2010. 8. 15.
 */
package jupiter.mass.log.updator;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

import jupiter.common.task.RealTimeCheckTask;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
/**
 * @author 에이메일  LMS UPDATE
 */
@Slf4j
public class LmsCampUpdator extends pluto.schedule.Task {

	

	private static ConnectInfo	TARGET_CONNECT_INFO					= null;

	static {
		TARGET_CONNECT_INFO = new ConnectInfo();
		TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
		TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("sms.db.url"));
		TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("sms.db.id"));
		TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
		TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
		TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
		TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
		TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
	}

	/**
	 * SMS 디비 접속(SOURCE)
	 */
	private eMsConnection			SOURCE_CONNECTION					= null;
	/**
	 * SMS 디비 접속 (TARGET ---> TBL_ORG_SM_TRAN, TBL_SM_TRAN, TBL_SM_QUEUE)
	 */
	private eMsConnection			TARGET_CONNECTION					= null;	
	/**
	 * TMS DB SELECT
	 */
	private eMsStatement			TMS_SMS_SELECT_STMT					= null;
	/**
	 * TMS DB UPDATE
	 */
	private eMsStatement			TMS_SMS_UPDATE_STMT					= null;
	/**
	 * MODULE DB SELECT
	 */
	private eMsStatement			MODULE_SMS_SELECT_STMT			= null;
	/**
	 * MODULE DB UPDATE
	 */
	private eMsPreparedStatement	MODULE_SMS_UPDATE_PSTMT			= null;	
	
	/**
	 * 모듈 로그 테이블 가져온다~~~
	 */
	private String				QUERY_SELECT_TARGET_SMS_LIST_TABLE 			= null;
	/**
	 * 결과셋을 가져오는 쿼리
	 */
	private String				QUERY_TARGET_SMS_RESULT_QUERY				= null;
	/**
	 * 대량발송 리스트테이블 업데이트 쿼리
	 */
	private String				QUERY_UPDATE_MASS_RESULT_QUERY				= null;
	/**
	 * 대량발송 TBL_ORG_SM_TRAN RESERVED2(MASS->MASS_Y)업데이트 쿼리
	 */
	private String				QUERY_UPDATE_SMS_TRAN_FLAG_QUERY			= null;	
	/**
	 * 리스트테이블 TMS_SMS_MASS_SCHEDULE_INFO 가져오기
	 */
	private String				QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY	= null;
	
	private static Hashtable 	CAMP_SCHEDULE_PPT 							= new Hashtable();
	
	private String 				QUERY_UPDATE_RESULT 						= null;
	
	public LmsCampUpdator() {
		
		super(TYPE_INTERVAL,2);
		this.setName("LmsCampUpdator");
		this.setTaskID("LmsCampUpdator");
		
		this.QUERY_SELECT_TARGET_SMS_LIST_TABLE = SqlManager.getQuery("MASS_UPDATE", "QUERY_SELECT_TARGET_LMS_LIST_TABLE");

		this.QUERY_TARGET_SMS_RESULT_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_TARGET_LMS_RESULT_QUERY");
		this.QUERY_UPDATE_MASS_RESULT_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_MASS_RESULT_QUERY");
		this.QUERY_UPDATE_SMS_TRAN_FLAG_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_LMS_TRAN_FLAG_QUERY");
		this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
		//재발송QUERY
		this.QUERY_UPDATE_RESULT = SqlManager.getQuery("PERSONAL_RESEND","QUERY_UPDATE_RESULT");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pluto.sms.module.SMSCall#execute()
	 */
	public void execute() {
		if (log.isDebugEnabled()) {
			log.debug("CALL LmsCampUpdator===> execute()");
		}
		try {
			// 자원 초기화
			this.execute_init();
			// 메인 프로세스
			this.execute_main();
		}
		catch(Throwable thw) {
			log.error("CALL execute(), ", thw);
		}
	}

	/**
	 * 초기화하면서 사용할 자원을 할당한다.
	 * @throws Throwable
	 *         초기화 에러.
	 */
	protected void execute_init() throws Throwable {
		if (log.isDebugEnabled()) {
			log.debug("CALL LmsCampUpdator===> execute_init()");
		}
		//eMs DB 접속 Connection
		this.SOURCE_CONNECTION = ConnectionPool.getConnection();
		
		CAMP_SCHEDULE_PPT.clear();

		//SMS AGENT DB 접속 Connection
		this.TARGET_CONNECTION = ConnectionPool.getConnection(TARGET_CONNECT_INFO);
		
		this.TMS_SMS_SELECT_STMT      = this.SOURCE_CONNECTION.createStatement();
		
		this.TMS_SMS_UPDATE_STMT      = this.SOURCE_CONNECTION.createStatement();
		
		this.MODULE_SMS_SELECT_STMT = this.TARGET_CONNECTION.createStatement();
		
		this.MODULE_SMS_UPDATE_PSTMT = null;
	}

	protected void execute_main() throws Throwable {
		
		if (log.isDebugEnabled()) {
			log.debug("CALL LmsCampUpdator===> execute_main()");
		}
		// sms_send_conf.xml에서 정의된 db설정
		eMsResultSet smsListTableResult  = null;
		
		
		Properties tValue = new Properties();	
		
		try{
			smsListTableResult =  this.MODULE_SMS_SELECT_STMT.executeQuery(this.QUERY_SELECT_TARGET_SMS_LIST_TABLE); 

//FIXME 반듯이 한 LOW의 정보만 나옴. warring 단계
			if(smsListTableResult.next()){   
				String L1 = smsListTableResult.getString("LIST_TABLE1");
				String L2 = smsListTableResult.getString("LIST_TABLE2");
				String L3 = smsListTableResult.getString("LIST_TABLE3");
				
				if(L1.equals(L2)){
					tValue.setProperty("LIST_TABLE1", L1);
				}
				else{
					tValue.setProperty("LIST_TABLE2", L2);
					
					if(!L2.equals(L3)){
						tValue.setProperty("LIST_TABLE3", L3);
					}
				}
			}
			if(smsListTableResult != null){
				smsListTableResult.close();
			}
			
//FIXME 동일한 테이블로 LOOP를 한번 더 돌 수 있음. warring 단계(버그의 원인이 될지 몰르겠음)
//LIST_TABLE2 == LIST_TABLE3 인 경우(위의 로직 변경으로 해결)
			for (Iterator iter = tValue.values().iterator(); iter.hasNext();) {
				String smsListTable = iter.next().toString();
				if(!smsListTable.equals("") && smsListTable != null){
					
					// real update !!!!!!!!!!!!!!!!!!!!!!!!
					update_process(smsListTable);
				
				
				}else{
					log.debug("TARGET TABLE null ", this.QUERY_SELECT_TARGET_SMS_LIST_TABLE);
				}
					
			}
		}catch(Exception e){
			log.error("LmsCampUpdator", "execute_main", e);
		}finally{
			if(smsListTableResult != null){
				smsListTableResult.close();
			}
			
		}
	}// end execute_main()

	
	
	public void update_process(String list_table) throws Exception{
		
		eMsResultSet moduleSMSResult  = null;
		
		Properties sMsSendResultValue = new Properties();
		
		Properties summaryValue = new Properties();
		
		ScheduleTblBean stBean = null;
		
		int result=0;
		
		int count=0;
		
		StringBuffer buff = new StringBuffer(512);
		
		try{
			
			sMsSendResultValue.setProperty("LMS_LIST_TABLE", list_table);
			
			moduleSMSResult = this.MODULE_SMS_SELECT_STMT.executeQuery(this.QUERY_TARGET_SMS_RESULT_QUERY ,sMsSendResultValue, "${", "}");
			Properties tableNameProp = new Properties();
			tableNameProp.setProperty("LMS_LIST_TABLE", list_table);

			StringBuffer buffer = new StringBuffer();
			StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_SMS_TRAN_FLAG_QUERY, tableNameProp, "${", "}", true, true);
			this.MODULE_SMS_UPDATE_PSTMT = new eMsPreparedStatement(buffer.toString(), "${", "}");
			this.MODULE_SMS_UPDATE_PSTMT.connectTo(this.TARGET_CONNECTION);
			
			while(moduleSMSResult.next()){
				
				sMsSendResultValue.clear();
				sMsSendResultValue.setProperty("LMS_LIST_TABLE", list_table);
								
				moduleSMSResult.putToMap(sMsSendResultValue, false);
				
				stBean = (ScheduleTblBean)CAMP_SCHEDULE_PPT.get(sMsSendResultValue.getProperty("POST_ID"));
				
				if(stBean==null){
					stBean = new ScheduleTblBean(sMsSendResultValue.getProperty("POST_ID"));
					CAMP_SCHEDULE_PPT.put(sMsSendResultValue.getProperty("POST_ID"), stBean);
				}
				// member_id에 ^가 있을 경우 재발송
				if(sMsSendResultValue.getProperty("MEMBER_ID").indexOf("^") > 0){
					// M_ID & WORK_SEQ 분리 M_ID=10234567^2  
					int pos = sMsSendResultValue.getProperty("MEMBER_ID").indexOf("^");
					
					String mId = sMsSendResultValue.getProperty("MEMBER_ID").substring(0, pos);
					String workSeq = sMsSendResultValue.getProperty("MEMBER_ID").substring(pos+1);
					
					sMsSendResultValue.setProperty("M_ID", mId);
					sMsSendResultValue.setProperty("WORK_SEQ", workSeq);
					
					this.TMS_SMS_UPDATE_STMT.executeUpdate( QUERY_UPDATE_RESULT , sMsSendResultValue , "${", "}");
					//1-2. TBL_ORG_SM_TRAN RESERVER2(MASS->MASS_Y) UPDATE
					
				}else{
					// 실패건수 처리...
					//1-1. TMS_SMS_SEND_LIST ERROR_CODE UPDATE
					this.TMS_SMS_UPDATE_STMT.executeUpdate(QUERY_UPDATE_MASS_RESULT_QUERY, sMsSendResultValue, "${", "}");
					//옵티마이징통계테이블(TMS_CUST_STAT_TMP)에 성공/실패 INSERT
//					this.TMS_SMS_UPDATE_STMT.executeUpdate(QUERY_INSERT_SEND_OPTIMIZ, sMsSendResultValue, "${", "}");
	
					//1-2. TBL_ORG_SM_TRAN RESERVER2(MASS->MASS_Y) UPDATE
//					this.MODULE_SMS_UPDATE_STMT.executeUpdate(QUERY_UPDATE_SMS_TRAN_FLAG_QUERY, sMsSendResultValue, "${", "}");
					
//					UPDATE	${LMS_LIST_TABLE}
//					SET		BROAD_DATE = 'Y'
//					WHERE	MSGKEY = '${TR_NUM}'
					
					if(Integer.parseInt(sMsSendResultValue.getProperty("FAIL_CNT")) > 0){
						stBean.addFailCnt();
						stBean.addErrorCnt(sMsSendResultValue.getProperty("ERROR_CODE"));
					}
						stBean.addPush();
				}
				
				this.MODULE_SMS_UPDATE_PSTMT.executeUpdate(sMsSendResultValue);
				
			} //END while 	
			
			
			if(CAMP_SCHEDULE_PPT.size() <= 0){
				return;
			}
			
//FIXME ==========================================================================
// moduleSMSResult.next()의 마지막 데이터가 재발송인 경우 updateFlag=false 라서 아래 로직을 타지 않음.
//================================================================================
				Enumeration e = CAMP_SCHEDULE_PPT.elements();
				
				while(e.hasMoreElements()){	
					stBean = (ScheduleTblBean)e.nextElement();
					buff.setLength(0);
					if(log.isDebugEnabled()){log.debug("[stBean content]\n\t"+stBean.toString());}
					
					StringConvertUtil.ConvertString( buff , QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY , stBean.getElement("MASS") , "${" , "}" , true , false );
					result = this.TMS_SMS_UPDATE_STMT.executeUpdate(buff.toString());
					
					if(result<1){
						log.debug("[SCHEDULE SUMMARY FAIL]:"+stBean.getName());
					}else{
						count++;
					}
				}

				if( count == CAMP_SCHEDULE_PPT.size() ) {
//						log.debug("\t\t\t\t[SCHEDULE SUMMARY SUCCESS !!!]");
				}
//			}
		}catch(Exception e){
			
			log.error("LmsCampUpdator", "execute_main", e);
		}finally{
			if(moduleSMSResult != null){
				moduleSMSResult.close();
			}
//FIXME 테이블 명이 변경 될 수록 QUERY TEXT가 바뀌므로 매번 CLOSE 해줘야 됨.			
			if(this.MODULE_SMS_UPDATE_PSTMT !=null){
				this.MODULE_SMS_UPDATE_PSTMT.close();
			}
		}
	}
	
	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
//FIXME releaseResource() 메소드 삭제 및 아래 로직으로 통합 함.
	@Override
	public void release_Resource() {
		if (log.isDebugEnabled()) {
			log.debug("CALL LmsCampUpdator===> releaseResource()");
		}
		// TMS 대상 연결을 반환한다.
		if(this.TMS_SMS_SELECT_STMT != null) 	this.TMS_SMS_SELECT_STMT.close();
		if(this.TMS_SMS_UPDATE_STMT != null) 	this.TMS_SMS_UPDATE_STMT.close();
		
		if( this.SOURCE_CONNECTION != null ) this.SOURCE_CONNECTION.recycle();

		// feelingk 대상 연결을 반환한다.
		//if(this.MODULE_SMS_UPDATE_STMT !=null)  MODULE_SMS_UPDATE_STMT.close();
		if(this.MODULE_SMS_SELECT_STMT != null) 	this.MODULE_SMS_SELECT_STMT.close();
		if(this.MODULE_SMS_UPDATE_PSTMT != null) 	this.MODULE_SMS_UPDATE_PSTMT.close();
		
		if( this.TARGET_CONNECTION != null )  this.TARGET_CONNECTION.recycle();

	}
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("LmsCampUpdator_at_".concat(Cal.getSerialDate()));
	}
	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error("LmsCampUpdator", "init error", thw);
	}
	
}// end class
