/*
 * Created on 2010. 8. 15.
 */
package jupiter.mass.log.updator;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

import jupiter.common.task.RealTimeCheckTask;
import pluto.common.bean.PlanBean;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.log.Log;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
/**
 * @author 에이메일  LMS UPDATE
 */
@Slf4j
public class LmsAutoUpdator extends pluto.schedule.Task {

	

	private static ConnectInfo	TARGET_CONNECT_INFO					= null;

	static {
		TARGET_CONNECT_INFO = new ConnectInfo();
		TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
		TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("sms.db.url"));
		TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("sms.db.id"));
		TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
		TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
		TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
		TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
		TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
	}

	/**
	 * SMS 디비 접속(SOURCE)
	 */
	private eMsConnection			SOURCE_CONNECTION					= null;
	/**
	 * SMS 디비 접속 (TARGET ---> TBL_ORG_SM_TRAN, TBL_SM_TRAN, TBL_SM_QUEUE)
	 */
	private eMsConnection			TARGET_CONNECTION					= null;	
	/**
	 * TMS DB SELECT
	 */
	private eMsStatement			TMS_SMS_SELECT_STMT					= null;
	/**
	 * TMS DB UPDATE
	 */
	private eMsStatement			TMS_SMS_UPDATE_STMT					= null;
	/**
	 * MODULE DB SELECT
	 */
	private eMsStatement			MODULE_SMS_SELECT_STMT			= null;
	/**
	 * MODULE DB UPDATE
	 */
	private eMsPreparedStatement			MODULE_SMS_UPDATE_STMT			= null;	
	
	/**
	 * 모듈 로그 테이블 가져온다~~~
	 */
	private String				QUERY_SELECT_TARGET_SMS_LIST_TABLE 			= null;
	/**
	 * 결과셋을 가져오는 쿼리
	 */
	private String				QUERY_TARGET_SMS_RESULT_QUERY				= null;
	/**
	 * 대량발송 리스트테이블 업데이트 쿼리
	 */
	private String				QUERY_UPDATE_MASS_RESULT_QUERY				= null;
	/**
	 * 대량발송 TBL_ORG_SM_TRAN RESERVED2(MASS->MASS_Y)업데이트 쿼리
	 */
	private String				QUERY_UPDATE_SMS_TRAN_FLAG_QUERY			= null;	
	/**
	 * 리스트테이블 TMS_SMS_MASS_SCHEDULE_INFO 가져오기
	 */
	private String				QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY	= null;
		
	private static Hashtable 	CAMP_SCHEDULE_PPT 							= new Hashtable();
	
	private String 				QUERY_UPDATE_RESULT 						= null;
	
	
	//flow plan data -------------------------------------------------------------------
	private static eMsPreparedStatement PPS_SELECT_FLOW_DATA  = null;
	private static eMsPreparedStatement PPS_INSERT_FLOW_DATA  = null;
	
	private static String QUERY_SELECT_PLAN_INFO              = SqlManager.getQuery("FLOW_PLAN", "QUERY_SELECT_PLAN_INFO");
	private static String QUERY_INSERT_FLOW_DATA              = SqlManager.getQuery("FLOW_PLAN", "QUERY_INSERT_FLOW_DATA");
		
	//----------------------------------------------------------------------------------
		
	public LmsAutoUpdator() {
		
		super(TYPE_INTERVAL, 2);
		this.setName("LmsAutoUpdator");
		this.setTaskID("LmsAutoUpdator");
		
		this.QUERY_SELECT_TARGET_SMS_LIST_TABLE = SqlManager.getQuery("AUTO_UPDATE", "QUERY_SELECT_TARGET_LMS_LIST_TABLE");

		this.QUERY_TARGET_SMS_RESULT_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_TARGET_LMS_RESULT_QUERY");
		this.QUERY_UPDATE_MASS_RESULT_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_MASS_RESULT_QUERY");
		this.QUERY_UPDATE_SMS_TRAN_FLAG_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_LMS_TRAN_FLAG_QUERY");
		this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
		//재발송QUERY
		this.QUERY_UPDATE_RESULT = SqlManager.getQuery("PERSONAL_RESEND","QUERY_UPDATE_RESULT");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pluto.sms.module.SMSCall#execute()
	 */
	public void execute() {
		if (log.isDebugEnabled()) {
			log.debug("CALL LmsAutoUpdator===> execute()");
		}
		try {
			// 자원 초기화
			this.execute_init();
			// 메인 프로세스
			this.execute_main();
		}
		catch(Throwable thw) {
			log.error("CALL execute() ERROR", thw);
			// thw.printStackTrace();
		}
		finally {
			// 자원반환.
			this.releaseResource();
		}
	}

	/**
	 * 초기화하면서 사용할 자원을 할당한다.
	 * @throws Throwable
	 *         초기화 에러.
	 */
	protected void execute_init() throws Throwable {
		if (log.isDebugEnabled()) {
			log.debug("CALL LmsAutoUpdator===> execute_init()");
		}
		
		//eMs DB 접속 Connection
		this.SOURCE_CONNECTION = ConnectionPool.getConnection();
		
		CAMP_SCHEDULE_PPT.clear();

		//SMS AGENT DB 접속 Connection
		this.TARGET_CONNECTION = ConnectionPool.getConnection(TARGET_CONNECT_INFO);
		
		this.TMS_SMS_SELECT_STMT      = this.SOURCE_CONNECTION.createStatement();
		
		this.TMS_SMS_UPDATE_STMT      = this.SOURCE_CONNECTION.createStatement();
		
		this.MODULE_SMS_SELECT_STMT = this.TARGET_CONNECTION.createStatement();
		
		this.MODULE_SMS_UPDATE_STMT = null;
	}

	/**
	 * 종료시 진행중 할당받은 자원을 반한다.
	 */
	protected void releaseResource() {
		if (log.isDebugEnabled()) {
			log.debug("CALL LmsAutoUpdator===> releaseResource()");
		}
		
		//plan <사용하지 않는 것 같음 확인 필요>
		if(this.PPS_SELECT_FLOW_DATA !=null){
			PPS_SELECT_FLOW_DATA.close();
			PPS_SELECT_FLOW_DATA = null; 
		}
		if(this.PPS_INSERT_FLOW_DATA !=null){
			PPS_INSERT_FLOW_DATA.close();
			PPS_INSERT_FLOW_DATA = null; 
		}
		
		// TMS 대상 연결을 반환한다.
		if( this.SOURCE_CONNECTION != null ) {
			this.SOURCE_CONNECTION.recycleStatement(this.TMS_SMS_SELECT_STMT);
			this.SOURCE_CONNECTION.recycleStatement(this.TMS_SMS_UPDATE_STMT);
			this.SOURCE_CONNECTION.recycle();
		}
		// feelingk 대상 연결을 반환한다.
		//if(this.MODULE_SMS_UPDATE_STMT !=null)  MODULE_SMS_UPDATE_STMT.close();
		if( this.TARGET_CONNECTION != null ) {
			this.TARGET_CONNECTION.recycleStatement(this.MODULE_SMS_UPDATE_STMT);
			this.TARGET_CONNECTION.recycleStatement(this.MODULE_SMS_SELECT_STMT);
			TARGET_CONNECTION.recycle();		
		
//			this.TARGET_CONNECTION.recycleStatement(this.MODULE_SMS_SELECT_STMT);
//			this.TARGET_CONNECTION.recycleStatement(this.MODULE_SMS_UPDATE_STMT);
//			this.TARGET_CONNECTION.recycle();
		}
		

	}

	protected void execute_main() throws Throwable {
		
		if (log.isDebugEnabled()) {
			log.debug("CALL LmsAutoUpdator===> execute_main()");
		}
		// sms_send_conf.xml에서 정의된 db설정
		eMsResultSet smsListTableResult  = null;
		
		
		Properties tValue = new Properties();	
		
		try{
			//MSG_LOG_YYYYMM logTable 
			smsListTableResult =  this.MODULE_SMS_SELECT_STMT.executeQuery(this.QUERY_SELECT_TARGET_SMS_LIST_TABLE); 
			
			while(smsListTableResult.next()){
				
				if(smsListTableResult.getString("LIST_TABLE1").equals(smsListTableResult.getString("LIST_TABLE2"))){
					tValue.setProperty("LIST_TABLE",smsListTableResult.getString("LIST_TABLE1").toString());
				}else{
					smsListTableResult.putToMap(tValue, false);					
				}
			}
			
			if(smsListTableResult != null){
				smsListTableResult.close();
			}
			
			for (Iterator iter = tValue.values().iterator(); iter.hasNext();) {
				String smsListTable = iter.next().toString();
				if(!smsListTable.equals("") && smsListTable != null){
					
					// real update !!!!!!!!!!!!!!!!!!!!!!!!
					update_process(smsListTable);
				
				
				}else{
					log.debug("TARGET TABLE null ", this.QUERY_SELECT_TARGET_SMS_LIST_TABLE);
				}
					
			}
		}catch(Exception e){
			log.error("LmsAutoUpdator", "execute_main", e);
		}finally{
			if(smsListTableResult != null){
				smsListTableResult.close();
			}
			
		}
	}// end execute_main()

	
	
	public void update_process(String list_table) throws Exception{
		
		eMsResultSet moduleSMSResult  = null;
		
		Properties sMsSendResultValue = new Properties();
		
		Properties summaryValue = new Properties();
		
		ScheduleTblBean stBean = null;
		
		ScheduleTblBean updateBean = null;
		
		int result=0;
		
		int count=0;
		
		boolean updateFlag = false;
		
		StringBuffer buff = new StringBuffer(512);
		
		String postId = "";
		String memberId = "";
		
		try{
			
			sMsSendResultValue.setProperty("LMS_LIST_TABLE", list_table);
			
			moduleSMSResult = this.MODULE_SMS_SELECT_STMT.executeQuery(this.QUERY_TARGET_SMS_RESULT_QUERY ,sMsSendResultValue, "${", "}");
			Properties tableNameProp = new Properties();
			tableNameProp.setProperty("LMS_LIST_TABLE", list_table);

			StringBuffer buffer = new StringBuffer();
			StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_SMS_TRAN_FLAG_QUERY, tableNameProp, "${", "}", true, true);
			this.MODULE_SMS_UPDATE_STMT = new eMsPreparedStatement(buffer.toString(), "${", "}");
			this.MODULE_SMS_UPDATE_STMT.connectTo(this.TARGET_CONNECTION);
			
			while(moduleSMSResult.next()){
				//String post_id = "";
				updateFlag = true;
				
				sMsSendResultValue.clear();
				sMsSendResultValue.setProperty("LMS_LIST_TABLE", list_table);	
				moduleSMSResult.putToMap(sMsSendResultValue, false);
				
				postId = sMsSendResultValue.getProperty("POST_ID").trim();
				memberId = sMsSendResultValue.getProperty("MEMBER_ID").trim(); 
				
				stBean = (ScheduleTblBean)CAMP_SCHEDULE_PPT.get(postId);
				
				if(stBean==null){
					stBean = new ScheduleTblBean(postId);
					CAMP_SCHEDULE_PPT.put(postId, stBean);
				}
				//POST_ID => WORKDAY & SEQNO 로 분리
				int posPostid = postId.indexOf("_");
				String workDay = postId.substring(0, posPostid);
				String seqNo = postId.substring(posPostid+1);
				sMsSendResultValue.setProperty("WORKDAY", workDay);
				sMsSendResultValue.setProperty("SEQNO", seqNo);
				
				// member_id에 ^가 있을 경우 재발송
				if(sMsSendResultValue.getProperty("MEMBER_ID").indexOf("^") > 0){
					// M_ID & WORK_SEQ 분리 M_ID=10234567^2  
					int pos = memberId.lastIndexOf("^");
					int pos2 = memberId.lastIndexOf("_");
					String mId = memberId.substring(0, pos2);
					String mIdSeq = memberId.substring(pos2+1, pos);
					String workSeq = memberId.substring(pos+1);
					
					sMsSendResultValue.setProperty("M_ID", mId);
					sMsSendResultValue.setProperty("M_ID_SEQ", mIdSeq);
					sMsSendResultValue.setProperty("WORK_SEQ", workSeq);
					
					this.TMS_SMS_UPDATE_STMT.executeUpdate( QUERY_UPDATE_RESULT , sMsSendResultValue , "${", "}");
					//1-2. TBL_ORG_SM_TRAN RESERVER2(MASS->MASS_Y) UPDATE
					
					this.MODULE_SMS_UPDATE_STMT.executeUpdate(sMsSendResultValue);
					
					updateFlag = false;
				}else{
					// 실패건수 처리...
					//1-1. TMS_SMS_SEND_LIST ERROR_CODE UPDATE
					int posMid = memberId.lastIndexOf("_");					
					String mId = memberId.substring(0, posMid);
					String mIdSeq = memberId.substring(posMid+1);					
					sMsSendResultValue.setProperty("MEMBER_ID", mId);
					sMsSendResultValue.setProperty("MEMBER_ID_SEQ", mIdSeq);
					
					
					this.TMS_SMS_UPDATE_STMT.executeUpdate(QUERY_UPDATE_MASS_RESULT_QUERY, sMsSendResultValue, "${", "}");
						
					//1-2. TBL_ORG_SM_TRAN RESERVER2(MASS->MASS_Y) UPDATE
//					this.MODULE_SMS_UPDATE_STMT.executeUpdate(QUERY_UPDATE_SMS_TRAN_FLAG_QUERY, sMsSendResultValue, "${", "}");
					
					this.MODULE_SMS_UPDATE_STMT.executeUpdate(sMsSendResultValue);
					
//					UPDATE	${LMS_LIST_TABLE}
//					SET		BROAD_DATE = 'Y'
//					WHERE	MSGKEY = '${TR_NUM}'
					
					
					if(Integer.parseInt(sMsSendResultValue.getProperty("FAIL_CNT")) > 0){
						stBean.addFailCnt();
						stBean.addErrorCnt(sMsSendResultValue.getProperty("ERROR_CODE"));
					}
						stBean.addPush();
				}
			}		
			if(CAMP_SCHEDULE_PPT.size() <= 0){
				return;
			}
			
			if(updateFlag){
				Enumeration e = CAMP_SCHEDULE_PPT.elements();
				
				while(e.hasMoreElements()){	
					stBean = (ScheduleTblBean)e.nextElement();
					buff.setLength(0);
					if(log.isDebugEnabled()){log.debug("[stBean content]\n\t"+stBean.toString());}
					
					StringConvertUtil.ConvertString( buff , QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY , stBean.getElement("AUTO") , "${" , "}" , true , false );
					result = this.TMS_SMS_UPDATE_STMT.executeUpdate(buff.toString());
					
					if(result<1){
						log.debug("[SCHEDULE SUMMARY FAIL]:"+stBean.getName());
					}else{
						count++;
					}
				}
				
				
				if( count == CAMP_SCHEDULE_PPT.size() ) {
//						log.debug("\t\t\t\t[SCHEDULE SUMMARY SUCCESS !!!]");
				}
			}
			
			insertFlowPlanData(sMsSendResultValue);
			
		}catch(Exception e){
			
			log.error("LmsAutoUpdator", "execute_main", e);
		}finally{
			
			if(moduleSMSResult != null){
				moduleSMSResult.close();
			}
			//releaseResource();
		}
	}
	
	/*
	[table : PLAN_ACT_LIST]
	
	create table PLAN_ACT_LIST(
			SRC_WORKDAY       varchar(8) NOT NULL, 
			SRC_SEQNO         decimal(9,0) NOT NULL,
			SRC_MEMBER_ID     varchar(20) NOT NULL,
			SRC_MEMBER_ID_SEQ varchar(10) NOT NULL,
			SRC_LIST_TABLE    varchar(100) DEFAULT NULL,
			MSG_TYPE          varchar(3) NOT NULL,
			MSG_TYPE_SEQ      varchar(3) NOT NULL,
			PLAN_STATUS       varchar(2) NOT NULL,
			PLAN_DAY          varchar(5) ,
			PLAN_HOUR         varchar(10) ,
			T_DATE            datetime,  -- 로그 일시
			ACT_DATE          datetime,  -- 작업할 일시
			REG_DATE          datetime,  -- 등록일시
			SEND_FLAG_DATE    datetime   -- 발송 완료시 update
	)
	*/
	/**
	 * 
	 * @param target
	 * @return
	 * @throws Exception 
	 */
	protected String insertFlowPlanData(Object target) throws Exception{
		Properties propLogData = ( Properties )target;
		
		boolean isResend = propLogData.getProperty("IS_RESEND", "false").equals("true");
		int     failCnt  = Integer.parseInt(propLogData.getProperty("FAIL_CNT")); 
		
				
		String postId    = propLogData.getProperty( Log.LOG_MAIL_ID );
		
//		String workday   = propLogData.getProperty( Log.LOG_WORKDAY );
//		String seqNo     = propLogData.getProperty( Log.LOG_SEQNO );
//		String mId       = propLogData.getProperty( Log.LOG_MEMBER_ID );
//		String mIdSeq    = propLogData.getProperty( Log.LOG_MEMBER_ID_SEQ );
//		String listTable = propLogData.getProperty( Log.LOG_LIST_TABLE );
		
		String actType   = "SKIP";
		
		if(failCnt > 0){
			actType = "FAIL";
		}else{
			if(isResend){
				actType = "SUCCESS_RETRY";
			}else{
				actType = "SUCCESS_FIRST";
			}
		}
		
		//static hashtable에서 post_id에 해당하는 bean을 가져옴
		PlanBean bean = PlanBean.getPlanBean(postId);
		if(bean == null){
			bean = new PlanBean();
			/*
			SELECT B.MSG_TYPE     AS MSG_TYPE,
				   B.MSG_TYPE_SEQ AS MSG_TYPE_SEQ,
				   B.PLAN_DAY     AS PLAN_DAY,
				   B.PLAN_HOUR    AS PLAN_HOUR,
				   B.PLAN_STATUS  AS PLAN_STATUS
			  FROM TMS_AUTO_SCHD_INFO A, 
			       TMS_AUTO_MSG_INFO B
			 WHERE A.WORKDAY = '${WORKDAY}'
			   AND A.SEQNO = '${SEQNO}'
			   AND A.MSG_TYPE = B.PLAN_PARENT_MSG_TYPE
			   AND A.MSG_TYPE_SEQ = B.PLAN_PARENT_MSG_TYPE_SEQ
			   AND B.CHANNEL_TYPE= 'SM' 
			 */
			//preparedStatement를 생성
			if(PPS_SELECT_FLOW_DATA == null){
				PPS_SELECT_FLOW_DATA = SOURCE_CONNECTION.prepareStatement(QUERY_SELECT_PLAN_INFO,"${","}");
			}
			
			ArrayList    arrTarget  = new ArrayList();
			
			eMsResultSet rsFlowData = null;
			try{
				
				rsFlowData = PPS_SELECT_FLOW_DATA.executeQuery(propLogData);
				
				while(rsFlowData.next()){
					Properties prop = new Properties();
					
					prop.setProperty("MSG_TYPE",    rsFlowData.getString("MSG_TYPE"));
					prop.setProperty("MSG_TYPE_SEQ",rsFlowData.getString("MSG_TYPE_SEQ"));
					prop.setProperty("PLAN_DAY",    rsFlowData.getString("PLAN_DAY"));
					prop.setProperty("PLAN_HOUR",   rsFlowData.getString("PLAN_HOUR"));
					prop.setProperty("PLAN_STATUS", rsFlowData.getString("PLAN_STATUS"));
					
					arrTarget.add(prop);
				}
			}catch(Exception e){
				
			}finally{
				if(rsFlowData != null){
					rsFlowData.close();
					rsFlowData = null;
				}
			}
			
			bean.setPostId(postId);
			bean.setArrTarget(arrTarget);
			
			//static hashtable에 저장
			PlanBean.setPlanBean(bean);
		}
		
		
		
		//plan 이 아닐경우 skip
		if(!bean.isPlanYn()){
			return "SKIP";
		}

		ArrayList<Properties> dataList = bean.getArrTarget();
		
		int    dataCnt    = dataList.size();
		String msgType    = "";
		String msgTypeSeq = "";
		String planStatus = "";
		String planDay    = "";
		String planHour   = "";
		
		boolean actFlag   = false;
		
		//insert
		for(int i=0; i< dataCnt; i++){
			Properties propPlanData = dataList.get(i);
			
			msgType      = propPlanData.getProperty("MSG_TYPE");
			msgTypeSeq   = propPlanData.getProperty("MSG_TYPE_SEQ");
			planStatus   = propPlanData.getProperty("PLAN_STATUS");
			planDay      = propPlanData.getProperty("PLAN_DAY");
			planHour     = propPlanData.getProperty("PLAN_HOUR");
			
			/*
			 * 유효데이터인지 검증
			 */
			if(log.isDebugEnabled()){
				log.debug("[planStatus]"+planStatus+"[actType]"+actType);
			}
			
			if( "A".equals(planStatus)){ //전체
				if( "SUCCESS_FIRST".equals(actType) || "FAIL".equals(actType) ){ //첫번째 성공, 첫번째 실패 건 합
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:ALL> SUCCESS_FIRST / FAIL");
					}
				}else{
					continue;
				}
			}else if( "S".equals(planStatus)){ //성공
				if( "SUCCESS_FIRST".equals(actType) || "SUCCESS_RETRY".equals(actType) ){ //모든 성공
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:SUCCESS> SUCCESS_FIRST / SUCCESS_RETRY");
					}
				}else{
					continue;
				}
			}else if( "F".equals(planStatus)){ //실패
				if( "FAIL".equals(actType) ){ // 첫번째 실패만 처리
					//대상
					if(log.isDebugEnabled()){
						log.debug("[TARGET_AREA]<Type:FAIL> FAIL_FIRST");
					}
				}else{
					continue;
				}
			}else{
				continue;
			}
						
			propLogData.setProperty("MSG_TYPE",     msgType);
			propLogData.setProperty("MSG_TYPE_SEQ", msgTypeSeq);
			propLogData.setProperty("PLAN_STATUS",  planStatus);
			propLogData.setProperty("PLAN_DAY",     StringUtil.isNull(planDay)?"0":planDay );
			propLogData.setProperty("PLAN_HOUR",    StringUtil.isNull(planHour)?"0":planHour);

			/*
			INSERT INTO PLAN_ACT_LIST(
				SRC_WORKDAY, SRC_SEQNO, SRC_MEMBER_ID, SRC_MEMBER_ID_SEQ, SRC_LIST_TABLE,
				MSG_TYPE, MSG_TYPE_SEQ,
				PLAN_STATUS, PLAN_DAY, PLAN_HOUR,
				T_DATE, 
				ACT_DATE, 
				REG_DATE )
			VALUES (
				'${WORKDAY}','${SEQNO}','${M_ID}','${M_ID_SEQ}','${LIST_TABLE}',
				'${MSG_TYPE}','${MSG_TYPE_SEQ}',
				'${PLAN_STATUS}','${PLAN_DAY}','${PLAN_HOUR}',
				DATE_FORMAT( '${T_DATE}' , '%Y-%m-%d %H:%i:%S' ),
				DATE_SUB(DATE_SUB(DATE_FORMAT( '${T_DATE}', '%Y-%m-%d %H:%i:%S' ), INTERVAL (-1*${PLAN_DAY}) DAY), INTERVAL (-1*${PLAN_HOUR}) HOUR),
				NOW() )
			 */
			//preparedStatement를 생성
			if(PPS_INSERT_FLOW_DATA == null){
				PPS_INSERT_FLOW_DATA = SOURCE_CONNECTION.prepareStatement(this.QUERY_INSERT_FLOW_DATA,"${","}");
			}
			
			int cnt_insert = PPS_INSERT_FLOW_DATA.executeUpdate(propLogData);
			if(cnt_insert != 1){
				log.debug("[ERROR] insert fail <FLOW_DATA> "+propLogData.toString());
			}else{
				actFlag = true;
			}
			
		}//end of for
		
		if(!actFlag){
			actType = "no Match";
		}
		
		return actType;
	}
	
	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		// 반환할 자원이 없다.
		//plan
		if(this.PPS_SELECT_FLOW_DATA !=null){
			PPS_SELECT_FLOW_DATA.close();
			PPS_SELECT_FLOW_DATA = null; 
		}
		if(this.PPS_INSERT_FLOW_DATA !=null){
			PPS_INSERT_FLOW_DATA.close();
			PPS_INSERT_FLOW_DATA = null; 
		}
		// TMS 대상 연결을 반환한다.
		if( this.SOURCE_CONNECTION != null ) {
			this.SOURCE_CONNECTION.recycleStatement(this.TMS_SMS_SELECT_STMT);
			this.SOURCE_CONNECTION.recycleStatement(this.TMS_SMS_UPDATE_STMT);
			this.SOURCE_CONNECTION.recycle();
		}
		// feelingk 대상 연결을 반환한다.
		//if(this.MODULE_SMS_UPDATE_STMT !=null)  MODULE_SMS_UPDATE_STMT.close();
		if( this.TARGET_CONNECTION != null ) {
			this.TARGET_CONNECTION.recycleStatement(this.MODULE_SMS_UPDATE_STMT);
			this.TARGET_CONNECTION.recycleStatement(this.MODULE_SMS_SELECT_STMT);
			TARGET_CONNECTION.recycle();		
		}
	}
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("LmsAutoUpdator_at_".concat(Cal.getSerialDate()));
	}
	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error("LmsAutoUpdator", "init error", thw);
	}
}// end class
