/*
 * Created on 2016. 5. 18.
 */
package jupiter.mass.log.updator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.Tracer;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
/**
 * @author  KAKAO UPDATE
 */
@Slf4j
public class KakaoUpdator extends pluto.schedule.Task {
	
	// 모듈이 디비가 다른 곳에 존재할 경우
	// kakao_update_conf.xml 에 설정되어 있음
	private static final String _USE_OTHER_DB_ = "use.other.db";
	
	protected static final String _MASS_ = "MASS";
	protected static final String _AUTO_ = "AUTO";
	protected static final String _TEST_ = "TEST";
	
	private static String commitInterval = "1000";
	/**
	 * 모듈쪽
	 */
	// 로그 테이블 가져온다.
	private static String QUERY_SELECT_TARGET_LIST_TABLE = null;
	// 결과셋을 가져오는 쿼리
	private static String QUERY_TARGET_KAKAO_RESULT_QUERY = null;
	private static String QUERY_TARGET_FT_RESULT_QUERY = null;
	/**
	 * TMS쪽
	 */
	// 대량
	private static String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
	// 자동
	private static String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = null;
	
	private String threadId = null;
	
	private Map<String,ScheduleTblBean> campSummaryPpp = new HashMap<String,ScheduleTblBean>();
	private Map<String,ScheduleTblBean> autoSummaryPpp = new HashMap<String,ScheduleTblBean>();
	
	private Map<String,List<Properties>> autoListPpp = new HashMap<String,List<Properties>>();
	private Map<String,List<Properties>> campListPpp = new HashMap<String,List<Properties>>();
	
	private eMsConnection SOURCE_CONNECTION = null;
	private eMsConnection moduleConnection = null;
	
	private eMsStatement MODULE_KAKAO_SELECT_STMT = null;
	private eMsStatement TMS_KAKAO_SELECT_STMT = null;
	private eMsStatement BASIC_KAKAO_UPDATE_STMT = null;
	
	private boolean isUseOtherDb = false;
	private static ConnectInfo moduleConnectionInformation = new ConnectInfo();
	
	//ADD BATCH 처리를 위한 list
	/**
	 * 자동 KAKAO 관련 데이터를 담는 곳
	 */
	protected List<Properties> AUTO_TARGETLIST = null;
	//protected Hashtable<String,Properties> AUTO_TARGETLIST = null;
	/**
	 * 대량 KAKAO 관련 데이터를 담는 곳
	 */
	protected List<Properties> CAMP_TARGETLIST = null; 
	
	static {
		
		QUERY_TARGET_KAKAO_RESULT_QUERY = SqlManager.getQuery("COMMON_UPDATE", "QUERY_TARGET_KAKAO_RESULT_QUERY");
		QUERY_TARGET_FT_RESULT_QUERY = SqlManager.getQuery("COMMON_UPDATE", "QUERY_TARGET_FT_RESULT_QUERY");
		QUERY_SELECT_TARGET_LIST_TABLE = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_LIST_TABLE");
		QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
		QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO");
		
		moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
		moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
		moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
		moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
		moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
		moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
		moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
		moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
	}
	
	public KakaoUpdator() {
		super();
	}
	
	public void setTaskProperty(Properties prop) {
		this.TASK_PROPERTY = prop;
		this.setName("KakaoUpdator" );
		this.setTaskID("KakaoUpdator_"+this.TASK_PROPERTY.getProperty("THREAD_ID") );
		
		threadId = this.TASK_PROPERTY.getProperty("THREAD_ID");
		isUseOtherDb = Boolean.parseBoolean(TASK_PROPERTY.getProperty(_USE_OTHER_DB_));
	}
	
	/*
	 * @see pluto.push.module.PUSHCall#execute()
	 */
	public void execute() {
		
		log.info("{}_{} CALL KakaoUpdator===> execute()", getName(), threadId);
		
		try {
			log.debug("{}_{} CALL KakaoUpdator===> execute_init start", getName(), threadId);
			// 자원 초기화
			this.execute_init();
			log.debug("{}_{} CALL KakaoUpdator===> execute_init done", getName(), threadId);
			log.debug("{}_{} CALL KakaoUpdator===> execute_main start", getName(), threadId);
			// 메인 프로세스
			this.execute_main();
			log.debug("{}_{} CALL KakaoUpdator===> execute_main done", getName(), threadId);
		} catch(Throwable thw) {
			log.error("KakaoUpdator", "CALL execute() ERROR", thw);
			// thw.printStackTrace();
		} finally {
			log.debug("{}_{} CALL KakaoUpdator===> releaseResource start", getName(), threadId);
			// 자원반환.
			this.releaseResource();
			log.debug("{}_{} CALL KakaoUpdator===> releaseResource done", getName(), threadId);
		}
	}
	
	protected String getMonthListTableName(String month , String type){
		
		month = (month.length() == 1) ? "0" + month : month;
		
		if (type.equals(_AUTO_)) {
			return  "TMS_AUTO_SEND_LIST_"+month;
		} else {
			return  "TMS_CAMP_SEND_LIST_"+month;
		}
	}
	
	/**
	 * 초기화하면서 사용할 자원을 할당한다.
	 * @throws Throwable
	 *         초기화 에러.
	 */
	protected void execute_init() throws Throwable {
		
		log.debug("{}_{} CALL KakaoUpdator===> execute_init()", getName(), threadId);
		
		//eMs DB 접속 Connection
		this.SOURCE_CONNECTION = ConnectionPool.getConnection();
		
		// 모듈 DB 접속 Connection
		moduleConnection = ConnectionPool.getConnection(moduleConnectionInformation);
		
		this.TMS_KAKAO_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
		this.BASIC_KAKAO_UPDATE_STMT = this.SOURCE_CONNECTION.createStatement();
		
		this.MODULE_KAKAO_SELECT_STMT = this.moduleConnection.createStatement();
	}

	/**
	 * 종료시 진행중 할당받은 자원을 반한다.
	 */
	protected void releaseResource() {
		log.debug("{}_{} CALL KAKAOUpdator===> releaseResource()", getName(), threadId);
		
		// TMS 대상 연결을 반환한다.
		if (this.SOURCE_CONNECTION != null) {
			if (this.TMS_KAKAO_SELECT_STMT != null) {
				this.SOURCE_CONNECTION.recycleStatement(this.TMS_KAKAO_SELECT_STMT);
			}
			
			if (this.BASIC_KAKAO_UPDATE_STMT != null) {
				this.SOURCE_CONNECTION.recycleStatement(this.BASIC_KAKAO_UPDATE_STMT);
			}
			
			try {
				this.SOURCE_CONNECTION.commit();
				this.SOURCE_CONNECTION.setAutoCommit(true);
			} catch(Exception ee) {}
			
			this.SOURCE_CONNECTION.recycle();
		}
		
		// 모듈 디비 커넥션을 반환한다.
		if (moduleConnection != null) {
			if (this.MODULE_KAKAO_SELECT_STMT != null) {
				moduleConnection.recycleStatement(this.MODULE_KAKAO_SELECT_STMT);
			}
			
			try {
				moduleConnection.commit();
				moduleConnection.setAutoCommit(true);
			} catch(Exception ee) {}
			
			moduleConnection.recycle();
		}
	}

	protected void execute_main() throws Throwable {
		
		log.debug("{}_{} CALL KAKAOUpdator===> execute_main()", getName(), threadId);
		updateProcess(this.TASK_PROPERTY.getProperty("SMS_LIST_TABLE",""));

		/*Properties tValue = new Properties();
		
		eMsResultSet kakaoListTableResult = null;
		try {
			
			kakaoListTableResult = this.TMS_KAKAO_SELECT_STMT.executeQuery(QUERY_SELECT_TARGET_LIST_TABLE);
			while (kakaoListTableResult.next()) {
				String listTable1 = kakaoListTableResult.getString("LIST_TABLE1");
				String listTable2 = kakaoListTableResult.getString("LIST_TABLE2");
				
				if (listTable1.equals(listTable2)) {
					tValue.setProperty("LIST_TABLE", listTable1);
				} else {
					kakaoListTableResult.putToMap(tValue, false);
				}
			}
			
			log.debug("{}_{} CALL KAKAOUpdator===> execute_main() LIST_TABLE done", getName(), threadId);
			
			for (Iterator iter = tValue.values().iterator(); iter.hasNext();) {
				String kakaoListTable = iter.next().toString();
				
				if ((kakaoListTable != null) && (!"".equals(kakaoListTable))) {
					updateProcess(kakaoListTable);
				} else {
					log.debug("{}_{}, TARGET TABLE is null.. Query: {}", getName(), threadId, QUERY_SELECT_TARGET_LIST_TABLE);
				}
			}
		} catch(Exception e) {
			log.error("KAKAOUpdator execute_main()...", e);
		} finally {
			if (kakaoListTableResult != null) {
				kakaoListTableResult.close();
			}
		}*/
	}
	
	public void updateProcess(String list_table) {
		
		Properties kakaoSendResultValue = new Properties();
		
		String maxId = "";
		String minId = "";
		
		// TODO 현재는 무조건 자동으로 처리함
		// 아직 대량은 기능을 제공하지 않음
		//KakaoAutoUpdator autoUpdator = new KakaoAutoUpdator();
		
		//KakaoCampUpdator campUpdator = new KakaoCampUpdator();
		
		eMsResultSet moduleKakaoResult = null;
		
		try {
			
			this.SOURCE_CONNECTION.setAutoCommit(false);
			
			if (moduleConnection != null) {
				moduleConnection.setAutoCommit(false);
			}
			
			//autoUpdator.init(isUseOtherDb);
			
			maxId = this.TASK_PROPERTY.getProperty("MAX_ID");
			minId = this.TASK_PROPERTY.getProperty("MIN_ID");
			commitInterval = this.TASK_PROPERTY.getProperty("CHECK_INTERVAL");
			
			kakaoSendResultValue.setProperty("LIST_TABLE", list_table);
			kakaoSendResultValue.setProperty("MAX_ID", maxId);
			kakaoSendResultValue.setProperty("MIN_ID", minId);
			/*
			 *  알림톡, 친구톡 분기
			 *  IMC agent 기준 (수정 필요)
			 */
			if(list_table.startsWith("IMC_FT_BIZ_MSG_LOG")) {
				moduleKakaoResult = this.MODULE_KAKAO_SELECT_STMT.executeQuery(QUERY_TARGET_FT_RESULT_QUERY, kakaoSendResultValue, "${", "}");
			}else {
				moduleKakaoResult = this.MODULE_KAKAO_SELECT_STMT.executeQuery(QUERY_TARGET_KAKAO_RESULT_QUERY, kakaoSendResultValue, "${", "}");	
			}
			
			while (moduleKakaoResult.next()) {
				Properties resultProp = new Properties();
				moduleKakaoResult.putToMap(resultProp, false);
				
				String sendType = resultProp.getProperty("SEND_TYPE", _AUTO_);
				resultProp.setProperty("AGENT_TABLE", list_table);
				log.debug("======== resultProp : {}   listTable : {}", resultProp.toString(), list_table);
				// 자동 업데이트 처리
				if (sendType.equals(_AUTO_)) {
					String postId = resultProp.getProperty("POST_ID","").trim();
					String workday = postId.split("_")[0].trim();
					String seqno = postId.split("_")[1].trim();
					String tempMemberId = resultProp.getProperty("MEMBER_ID");
					
					int posMid = tempMemberId.lastIndexOf("_");					
					String mId = tempMemberId.substring(0, posMid).trim();
					String mIdSeq = tempMemberId.substring(posMid+1).trim();
					
					resultProp.setProperty("WORKDAY", workday);
					resultProp.setProperty("SEQNO", seqno);
					resultProp.setProperty("MEMBER_ID", mId);
					resultProp.setProperty("MEMBER_ID_SEQ", mIdSeq);
					if ("".equals(postId) || "".equals(workday) || "".equals(seqno)|| "".equals(tempMemberId)) {
						log.debug("Data is invalid skip...AUTO UPDATE PARAM: {}", resultProp);
						continue;
					}
					
					String listTable = resultProp.getProperty("LIST_TABLE","").trim();
					List<Properties> autoList = autoListPpp.get(listTable);
					if(autoList == null){
						autoList = new ArrayList<Properties>();
						autoListPpp.put(listTable, autoList);
					}
					autoList.add(resultProp);
					//AUTO_TARGETLIST.add(resultProp);
					//autoUpdator.update(resultProp);
					
					ScheduleTblBean autoBean = autoSummaryPpp.get(postId);
					if (autoBean == null) {
						autoBean = new ScheduleTblBean(postId);
						autoSummaryPpp.put(postId, autoBean);
					}
					
					int failCnt = Integer.parseInt(resultProp.getProperty("FAIL_CNT","0"));
					int switchedCnt = Integer.parseInt(resultProp.getProperty("SWITCHED_CNT","0"));
					// 2019.01.02 알림톡 업데이트 문자전환실패 카운터 추가로 인한 수정  by kwj
					int switchedFailCnt = Integer.parseInt(resultProp.getProperty("SWITCHED_FAIL_CNT","0"));
					if (failCnt > 0) {
						autoBean.addFailCnt();
						autoBean.addErrorCnt(resultProp.getProperty("ERROR_CODE",""));
					}
					if(switchedCnt>0){
						autoBean.addSwitchedCnt();
					}
					// 2019.01.02 알림톡 업데이트 문자전환실패 카운터 추가로 인한 수정  by kwj
					if(switchedFailCnt>0){
						autoBean.addSwitchedFailCnt();
					}
					autoBean.addPush();
				} else if(sendType.equals(_MASS_)) {	// 대량 업데이트 처리
					// TODO 현재 알림톡은 대량 서비스는 지원하지 않으므로 구현하지 않음. 추후 구현 필요
					String postId = resultProp.getProperty("POST_ID","").trim();
					if ("".equals(postId)) {
						log.debug("Data is invalid skip... MASS UPDATE PARAM : {}", resultProp);
						continue;
					}
					
					String listTable = resultProp.getProperty("LIST_TABLE","").trim();
					log.debug("======== resultProp : {}   listTable : {}", resultProp.toString(), listTable);
					List<Properties> campList = campListPpp.get(listTable);
					if(campList == null){
						campList = new ArrayList<Properties>();
						campListPpp.put(listTable, campList);
					}
					campList.add(resultProp);
					//CAMP_TARGETLIST.add(resultProp);
					//autoUpdator.update(resultProp);
					
					ScheduleTblBean campBean = campSummaryPpp.get(postId);
					if (campBean == null) {
						campBean = new ScheduleTblBean(postId);
						campSummaryPpp.put(postId, campBean);
					}
					
					int failCnt = Integer.parseInt(resultProp.getProperty("FAIL_CNT","0"));
					int switchedCnt = Integer.parseInt(resultProp.getProperty("SWITCHED_CNT","0"));
					int switchedFailCnt = Integer.parseInt(resultProp.getProperty("SWITCHED_FAIL_CNT","0"));
					if (failCnt > 0) {
						campBean.addFailCnt();
						campBean.addErrorCnt(resultProp.getProperty("ERROR_CODE",""));
					}
					if(switchedCnt>0){
						campBean.addSwitchedCnt();
					}
					if(switchedFailCnt>0){
						campBean.addSwitchedFailCnt();
					}
					campBean.addPush();
				} else if(sendType.equals(_TEST_)){
					// 테스트 추후 정산 페이지 개발관련 확장성을 놓고 볼때 필요 
					// 성능 저하 및 정상 업데이트를 위해 
					// 추후 연동 테이블에 insert 작업 하여 이력 남기도록 개발진행
					log.debug("[TEST] sended test data : {}", resultProp);
				} else {
					log.debug("[ERROR] not update target data : {}", resultProp);
					// 자동 / 대량 / 테스트 이외 건들의 경우 => 보통은 인터페이스 연동 및 커스터마이징 작업에서
					// 데이터가 잘못 들어온 경우
					// 해당 건의 경우 지속적으로 select문에 걸릴경우 성능 저하 및 정상 update되지 않을 수 있으므로, 
					// ETC5를 K로 업데이트 한다.
				}
			}
			log.debug("{}_{} update_process while end autoListPpp {} campListPpp {} campSummaryPpp {} autoSummaryPpp {}", 
					getName(), threadId, autoListPpp.size(), campListPpp.size(), campSummaryPpp.size(), autoSummaryPpp.size());
			
			if(autoListPpp.size()>0){
				listUpdate(_AUTO_, autoListPpp);
			}
			if(campListPpp.size()>0){
				listUpdate(_MASS_, campListPpp);
			}
			// 대량 업데이트 건이 존재하면...
			if(campSummaryPpp.size() > 0){
				schdSummary(_MASS_, campSummaryPpp);
			}
			// 자동 업데이트 건이 존재하면...
			if(autoSummaryPpp.size() > 0){
				schdSummary(_AUTO_, autoSummaryPpp);
			}
			
		} catch(Exception e) {
			try {
				this.SOURCE_CONNECTION.rollback();
			} catch(Exception ee1) {}
			
			if (moduleConnection != null) {
				try {
					moduleConnection.rollback();
				} catch(Exception ee2) {}
			}
			
			log.error("KAKAOUpdator execute_main()...", e);
		} finally {
			if (moduleKakaoResult != null) {
				moduleKakaoResult.close();
			}
			
			//autoUpdator.release();
		}
	}
	
	private void schdSummary(String type, Map<String,ScheduleTblBean> schdMap) {
		
		StringBuffer buff = new StringBuffer(512);
		
		try {
			
			for (Map.Entry<String, ScheduleTblBean> target : schdMap.entrySet()) {
				
				buff.setLength(0);
				
				ScheduleTblBean stBean = target.getValue();
				
				log.debug("{}_{} summary stBean data: {}", getName(), threadId, stBean.toString());
				
				String targetQuery;
				if (type.equals(_AUTO_)) {
					targetQuery = QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY_AUTO;
				} else {
					targetQuery = QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY;
				}
				
				StringConvertUtil.ConvertString(buff, targetQuery, stBean.getElement(type), "${" , "}", true, false);
				
				if (this.BASIC_KAKAO_UPDATE_STMT.executeUpdate(buff.toString()) < 1) {
					log.debug("{}_{} schedule summary fail: {}", getName(), threadId, stBean.getName());
				}
			}
		} catch(Exception e) {
			log.error("ERROR schdSummary... ", e);
		}
	}
	
	private void listUpdate(String type, Map<String,List<Properties>> targetList) {
		
		StringBuffer buff = new StringBuffer(512);
		log.debug("Taget Type is {}", type);
		try {
			log.info("{}_{} update_process listUpdate start, commit Interval : {} ", getName(), threadId, commitInterval);
			for (Map.Entry<String, List<Properties>> target : targetList.entrySet()) {
				buff.setLength(0);
				String listTable = target.getKey();
				List<Properties> targetListData = target.getValue();
				KakaoResultUpdator resultUpdator = new KakaoResultUpdator();
				resultUpdator.init(commitInterval);
				resultUpdator.update(targetListData, listTable, type);
				resultUpdator.moduleUpdate(targetListData);
				resultUpdator.release();
				
			}
		} catch(Exception e) {
			log.error("ERROR UpdateError... ", e);
		} 
		log.info("{}_{} update_process listUpdate end ", getName(), threadId);
	}
	
	protected String ppsParseSQL(String source, String mapping, String value,String start, String end) {

		if( mapping == null || source == null )
			return source;

		return replace_target(source, start + mapping + end, value);
	}
	
	public static String replace_target(String target, String from, String to) {
		if( target == null || from == null || to == null )
			return null;

		int idx1 = 0;
		int idx2;

		while ((idx2 = target.indexOf(from, idx1)) != -1) {
			target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
			idx1 = idx2 + to.length();
		}
		return target;
	}
	
	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		// 반환할 자원이 없다.
	}
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("KAKAOUpdator_at_".concat(Cal.getSerialDate()));
	}
	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		Tracer.error("KAKAOUpdator", "init error", thw);
	}
}// end class
