package jupiter.mass.log.updator;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;

@Slf4j
public class KakaoSwitchUpdator extends KakaoUpdator {
	
	private static final String CHECK_FLAG = "UPDATE_CHECK_FLAG";
	private static final String FAIL = "F";
	private static final String OK = "Y";
	private static final String ING_MSG = "S";
	
	private static String queryAutoUpdateSendList = null;
	private static String queryMassUpdateSendList = null;
	private static String queryUpdateLog = null;
	
	private static int commit =  1000;
	
	private eMsConnection oriConnection = null;
	private eMsConnection moduleConnection = null;
	
	private eMsPreparedStatement oriPsSendList = null;
	private eMsPreparedStatement modulePsLog = null;
	
	
	private static ConnectInfo moduleConnectionInformation = new ConnectInfo();
	
	static {
		
		queryUpdateLog = SqlManager.getQuery("SWITCHED_UPDATE", "QUERY_UPDATE_TARGET_LIST");
		queryAutoUpdateSendList = SqlManager.getQuery("SWITCHED_UPDATE", "QUERY_UPDATE_AUTO_SEND_LIST");
		queryMassUpdateSendList = SqlManager.getQuery("SWITCHED_UPDATE", "QUERY_UPDATE_CAMP_SEND_LIST");
		moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
		moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
		moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
		moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
		moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
		moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
		moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
		moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
	}				

	
	public void init(int commitInterval) {
		
		try {
			// Tms Connection
			oriConnection = ConnectionPool.getConnection();
			commit = commitInterval;
			// module Connection
			moduleConnection = ConnectionPool.getConnection(moduleConnectionInformation);
			
		} catch(Exception e) {
			log.error("ERROR init()... {}", e);
		}
	}
	public void update(List<Properties> resultPropList, String listTable, String sendType) throws Exception {
		try {
			log.info("[{}] update kakao Msg : list_table : {}",sendType,listTable);
			String targetQuery;
			
			if(sendType.equals(_AUTO_)){
				targetQuery = queryAutoUpdateSendList;
			}else{
				targetQuery = queryMassUpdateSendList;
			}
			
			targetQuery = ppsParseSQL(targetQuery, "LIST_TABLE", listTable, "@{", "}");
			oriConnection.setAutoCommit(false);
			oriPsSendList = oriConnection.prepareStatement(targetQuery, "${", "}");
			
			log.debug("Update Send List Query: {}", targetQuery);
			int commitCnt = 0;
			for(Properties resultProp : resultPropList){
				commitCnt++;
				oriPsSendList.addBatch(resultProp);
				if(commitCnt % commit == 0){
					oriPsSendList.executeBatch();
					oriConnection.commit();
				}
			}
			oriPsSendList.executeBatch();
			oriConnection.commit();
		} catch(Exception e) {
			oriConnection.rollback();;
			for(Properties resultProp : resultPropList){
				updateOne(resultProp, sendType);
			}
			if (e instanceof SQLException) {
				throw e;
			}
		}
	}
	public void moduleUpdate(List<Properties> resultPropList) throws Exception {
		try {
			moduleConnection.setAutoCommit(false);
			modulePsLog = moduleConnection.prepareStatement(queryUpdateLog, "${", "}");
			log.debug("Update module List Query: {}", queryUpdateLog);
			
			int commitCnt = 0;
			for(Properties resultProp : resultPropList){
				//테스트용 정상 update 확인용
				resultProp.setProperty(CHECK_FLAG, OK);
				commitCnt++;
				modulePsLog.addBatch(resultProp);
				if(commitCnt % commit == 0){
					moduleConnection.commit();
				}
			}
			modulePsLog.executeBatch();
			moduleConnection.commit();
		} catch(Exception e) {
			moduleConnection.rollback();;
		}
	}
	public void updateOne(Properties resultProp, String sendType) throws Exception {
		try {
			resultProp.setProperty(CHECK_FLAG, OK);
			
			String listTableName = resultProp.getProperty("LIST_TABLE","");
			if ("".equals(listTableName)) {
				log.debug("LIST_TABLE is null... update skip... {}", resultProp);
				return ;
			}
			
			String targetQuery;
			if(sendType.equals(_AUTO_)){
				targetQuery = queryAutoUpdateSendList;
			}else{
				targetQuery = queryMassUpdateSendList;
			}
			log.debug("Update Send List Query: {}", targetQuery);
			// 업데이트 할 테이블 이름이 다를 수 있으므로
			targetQuery = ppsParseSQL(targetQuery, "LIST_TABLE", listTableName, "@{", "}");
			oriPsSendList = oriConnection.prepareStatement(targetQuery, "${", "}");
			oriPsSendList.executeUpdate(resultProp);
			modulePsLog.executeUpdate(resultProp);
			
		} catch(Exception e) {
			resultProp.setProperty(CHECK_FLAG, FAIL);
			
			try {
				modulePsLog.executeUpdate(resultProp);
			} catch(Exception ee) {
				try {
					oriConnection.rollback();
				} catch(Exception ee1) {}
				
				if (moduleConnection != null) {
					try {
						moduleConnection.rollback();
					} catch(Exception ee2) {}
				}
				throw ee;
			}
			log.error("ERROR update...", e);
			
			if (e instanceof SQLException) {
				throw e;
			}
		} finally {
			if (oriPsSendList != null && oriConnection != null) {
				oriConnection.recycleStatement(oriPsSendList);
			}
			
			if (modulePsLog != null && moduleConnection != null) {
				moduleConnection.recycleStatement(modulePsLog);
			}
		}
	}
	
	public void release() {
		if (oriPsSendList != null) {
			oriConnection.recycleStatement(oriPsSendList);
		}
		
		if (modulePsLog != null) {
			moduleConnection.recycleStatement(modulePsLog);
		}
		
		if (oriConnection != null) {
			try {
				oriConnection.commit();
				oriConnection.setAutoCommit(true);
			} catch(Exception ee) {}
			
			oriConnection.recycle();
		}
		
		if (moduleConnection != null) {
			try {
				moduleConnection.commit();
				moduleConnection.setAutoCommit(true);
			} catch(Exception ee) {}
			
			moduleConnection.recycle();
		}
	}
}
