package jupiter.mass.log.updator;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;

@Slf4j
public class KakaoResultUpdator extends KakaoUpdator {
	
	private static final String CHECK_FLAG = "UPDATE_CHECK_FLAG";
	private static final String FAIL = "F";
	private static final String OK = "Y";
	private static final String ING_MSG = "S";
	
	private static int commit = 1000;
	
	private static String queryAutoUpdateSendList = null;
	private static String queryMassUpdateSendList = null;

	private static String queryUpdateLog = null;
	private static String queryUpdateLogBasic = null;
	
	private eMsConnection oriConnection = null;
	private eMsConnection moduleConnection = null;
	
	private eMsPreparedStatement oriPsSendList = null;
	private eMsPreparedStatement modulePsLog = null;
	
	private static ConnectInfo moduleConnectionInformation = new ConnectInfo();
	
	static {
		
		queryAutoUpdateSendList = SqlManager.getQuery("AUTO_UPDATE", "UPDATE_TMS_SEND_LIST_N");
		queryMassUpdateSendList = SqlManager.getQuery("MASS_UPDATE", "UPDATE_TMS_SEND_LIST_N");

		queryUpdateLog = SqlManager.getQuery("COMMON_UPDATE", "UPDATE_TMS_KAKAO_LOG");
		queryUpdateLogBasic = SqlManager.getQuery("COMMON_UPDATE", "UPDATE_TMS_KAKAO_LOG");
		
		moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
		moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
		moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
		moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
		moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
		moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
		moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
		moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
	}
	
	public void init(String commitInterval) {
		
		try {
			// Tms Connection
			oriConnection = ConnectionPool.getConnection();
			// module Connection
			moduleConnection = ConnectionPool.getConnection(moduleConnectionInformation);
			commit = Integer.parseInt(commitInterval);
			
		} catch(Exception e) {
			log.error("ERROR init()... {}", e);
		}
	}
	public void update(List<Properties> resultPropList, String listTable, String sendType) throws Exception {
		try {
			
			StringBuffer buff = new StringBuffer(512);
			buff.setLength(0);
			log.debug("[{}] update kakao Msg : list_table : {}",sendType,listTable);
			String targetQuery;
			if(sendType.equals(_AUTO_)){
				targetQuery = queryAutoUpdateSendList;
			}else{
				targetQuery = queryMassUpdateSendList;
			}
			targetQuery = ppsParseSQL(targetQuery, "LIST_TABLE", listTable, "@{", "}");
			targetQuery = ppsParseSQL(targetQuery, "PK_INDEX", listTable.replace("TMS_", "PK_"), "@{", "}");
			
			log.debug("Update Send List Query: {}", targetQuery);
			
			oriConnection.setAutoCommit(false);
			
			oriPsSendList = oriConnection.prepareStatement(targetQuery, "${", "}");
			int commitCnt = 0;
			for(Properties resultProp : resultPropList){
				commitCnt++;
				oriPsSendList.addBatch(resultProp);
				if(commitCnt % commit == 0){
					oriPsSendList.executeBatch();
					oriConnection.commit();
					log.debug("{} commited", targetQuery);
				}
			}
			// 1000 건 단위가 되지 못한 항목 마무리
			oriPsSendList.executeBatch();
			oriConnection.commit();
		} catch(Exception e) {
			oriConnection.rollback();;
			for(Properties resultProp : resultPropList){
				updateOne(resultProp, sendType);
			}
			if (e instanceof SQLException) {
				throw e;
			}
		}
	}
	public void moduleUpdate(List<Properties> resultPropList) throws Exception {
		try {
			moduleConnection.setAutoCommit(false);
			log.debug("queryUpdateLog: {}", queryUpdateLog);
			queryUpdateLog = ppsParseSQL(queryUpdateLogBasic,"AGENT_TABLE",resultPropList.get(0).getProperty("AGENT_TABLE"),"@{","}");
			modulePsLog = moduleConnection.prepareStatement(queryUpdateLog, "${", "}");
			log.debug("Update module List Query: {}", queryUpdateLog);
			int commitCnt = 0;
			for(Properties resultProp : resultPropList){
				commitCnt++;
				resultProp.setProperty(CHECK_FLAG, OK);
				
				// 알림톡 성공이 아니고 SMS_TYPE이 존재하면 실패시 문자 전환 대상자이므로
				// 문자에 대한 결과를 업데이트 해줘야 함.
//				if (!resultProp.getProperty("ERROR_CODE").equals("01") && !resultProp.getProperty("SMS_TYPE","").equals("NO")) {
//					resultProp.setProperty(CHECK_FLAG, ING_MSG);
//				}
				log.debug("get Id : {}",resultProp.getProperty("ID"));
				modulePsLog.addBatch(resultProp);
				if(commitCnt % commit == 0){
					modulePsLog.executeBatch();
					moduleConnection.commit();
					log.debug("{} 1000 commited", queryUpdateLog);
				}
			}
			// 1000 건 단위가 되지 못한 항목 마무리
			modulePsLog.executeBatch();
			moduleConnection.commit();
		} catch(Exception e) {
			moduleConnection.rollback();;
		}
	}
	public void updateOne(Properties resultProp, String sendType) throws Exception {
		try {
			resultProp.setProperty(CHECK_FLAG, OK);
			
			// 알림톡 성공이 아니고 SMS_TYPE이 존재하면 실패시 문자 전환 대상자이므로
			// 문자에 대한 결과를 업데이트 해줘야 함.
			if (!resultProp.getProperty("ERROR_CODE").equals("01")
					&& !resultProp.getProperty("SMS_TYPE","").equals("NO")) {
				resultProp.setProperty(CHECK_FLAG, ING_MSG);
			}
			
			String listTableName = resultProp.getProperty("LIST_TABLE","");
			if ("".equals(listTableName)) {
				log.debug("LIST_TABLE is null... update skip... {}", resultProp);
				return ;
			}
			
			String targetQuery;
			if(sendType.equals(_AUTO_)){
				targetQuery = queryAutoUpdateSendList;
			}else{
				targetQuery = queryMassUpdateSendList;
			}
			// 업데이트 할 테이블 이름이 다를 수 있으므로
			targetQuery = ppsParseSQL(targetQuery, "LIST_TABLE", listTableName, "@{", "}");
			
			log.debug("Update Send List Query: {}", targetQuery);
			
			oriPsSendList = oriConnection.prepareStatement(targetQuery, "${", "}");
			modulePsLog = moduleConnection.prepareStatement(queryUpdateLog, "${", "}");
			
			oriPsSendList.executeUpdate(resultProp);
			modulePsLog.executeUpdate(resultProp);
			
		} catch(Exception e) {
			resultProp.setProperty(CHECK_FLAG, FAIL);
			
			try {
				modulePsLog.executeUpdate(resultProp);
			} catch(Exception ee) {
				try {
					oriConnection.rollback();
				} catch(Exception ee1) {}
				
				if (moduleConnection != null) {
					try {
						moduleConnection.rollback();
					} catch(Exception ee2) {}
				}
				throw ee;
			}
			log.error("ERROR update...", e);
			
			if (e instanceof SQLException) {
				throw e;
			}
		}finally {
			if (oriPsSendList != null && oriConnection != null) {
				oriConnection.recycleStatement(oriPsSendList);
			}
			
			if (modulePsLog != null && moduleConnection != null) {
				moduleConnection.recycleStatement(modulePsLog);
			}
		}
	}
	
	public void release() {
		if (oriPsSendList != null) {
			oriConnection.recycleStatement(oriPsSendList);
		}
		
		if (modulePsLog != null) {
			moduleConnection.recycleStatement(modulePsLog);
		}
		
		if (oriConnection != null) {
			try {
				oriConnection.commit();
				oriConnection.setAutoCommit(true);
			} catch(Exception ee) {}
			
			oriConnection.recycle();
		}
		
		if (moduleConnection != null) {
			try {
				moduleConnection.commit();
				moduleConnection.setAutoCommit(true);
			} catch(Exception ee) {}
			
			moduleConnection.recycle();
		}
	}
}
