package jupiter.mass.log.updator;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;

@Slf4j
public class KakaoMsgUpdateCheckTask extends Task {
	
	private static final String IS_OTHER_DB = "use.other.db";
	
	private static boolean isOtherDb = false;
	private static ConnectInfo otherConnectInfo = new ConnectInfo();
	private static String querySelectTargetRange = null;
	private static String commitInterval = null;
	private static String updatorClassName = "jupiter.mass.log.updator.KakaoMsgUpdator";
	
	// Module Name
	
	private eMsConnection con = null;
	private eMsStatement stmtSelect = null;
	private eMsResultSet rsSelect = null;
	
	//private eMsPreparedStatement psSelect = null;
	
	static {
		querySelectTargetRange = SqlManager.getQuery("SWITCHED_UPDATE","QUERY_SELECT_TARGET_RANGE");
		
		otherConnectInfo.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
		otherConnectInfo.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
		otherConnectInfo.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
		otherConnectInfo.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
		otherConnectInfo.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
		otherConnectInfo.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
		otherConnectInfo.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
		otherConnectInfo.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
	}
	
	public KakaoMsgUpdateCheckTask() {
		super(TYPE_INTERVAL);
		this.setName("KakaoMsgUpdateCheckTask_at" + Cal.getSerialDate());
		this.setTaskID("KakaoMsgUpdateCheckTask");
	}
	
	public static void init(Object param) {
		// do nothing...
		Properties prop = (Properties) param;
		
		isOtherDb = Boolean.parseBoolean(prop.getProperty(IS_OTHER_DB, "false"));
		updatorClassName = prop.getProperty("updator.class.name","");
		commitInterval = prop.getProperty("commit.interval.size","1000");
	}
	
	@Override
	public void execute_initiate() throws Exception {
		log.info("{}... START", getName());
		
		if (isOtherDb) {
			con = ConnectionPool.getConnection(otherConnectInfo);
		} else {
			con = ConnectionPool.getConnection();
		}
		
		stmtSelect = con.createStatement();
	}
	
	@Override
	public void execute() throws Exception {
		Properties result = new Properties();
		
		rsSelect = stmtSelect.executeQuery(querySelectTargetRange);
		if(rsSelect.next()) {
			rsSelect.putToMap(result, false);
		}
		log.debug("SELECT TARGET RANGE: {}", result);
		
		if (!result.isEmpty()) {
			// 알림톡 테이블이 솔루션과 같은 DB에 존재히는지에 대한 값.
			result.setProperty(IS_OTHER_DB, String.valueOf(isOtherDb));
			result.setProperty("CHECK_INTERVAL", commitInterval);
			
			// 업데이트 할 클래스 생성
			executeUpdatorTask(result);
		}
	}

	@Override
	public void release_Resource() {
		if (rsSelect != null)rsSelect.close();
		if (stmtSelect != null) stmtSelect.close();
		if (con != null) con.close();
		
		log.info("{}... END", getName());
	}
	
	@Override
	public void execute_initiateError(Throwable thw) {
		log.error("execute_initiateError()...", thw);
	}
	
	// 실제 업데이트를 수행 Task 생성.
	private synchronized void executeUpdatorTask(Properties prop) {
		try {
			
			Task updatorTask = (Task) getInstance(updatorClassName);
			updatorTask.setTaskProperty(prop);
			TaskManager.executeTask(updatorTask);
			
			try {
				wait(1000);
			} catch(Exception e) {}
			
		} catch(Exception e) {
			log.error("[ERROR] executeUpdatorTask()", e);
		}
		
		log.info("executeUpdatorTask()... START");
	}
	
	private Object getInstance(String className) throws Exception {
		return Class.forName(className).newInstance();
	}
}
