package jupiter.mass.log.updator;

import java.sql.SQLException;
import java.util.Properties;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.ErrorCode;
import com.humuson.tms.constrants.StatusType;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;

@Slf4j
public class KakaoCampUpdator extends KakaoUpdator {
	
	private static final String CHECK_FLAG = "CHECK_FLAG";
	private static final String FAIL = "F";
	private static final String OK = "Y";
	private static final String ING_MSG = "S";
	
	private static String queryUpdateSendList = null;
	private static String queryUpdateLog = null;
	
	private eMsConnection oriConnection = null;
	private eMsConnection moduleConnection = null;
	
	private eMsPreparedStatement oriPsSendList = null;
	private eMsPreparedStatement modulePsLog = null;
	
	private boolean useOthreDb = false;
	
	private static ConnectInfo moduleConnectionInformation = new ConnectInfo();
	
	static {
		
		queryUpdateSendList = SqlManager.getQuery("MASS_UPDATE", "UPDATE_TMS_SEND_LIST_N");
		queryUpdateLog = SqlManager.getQuery("COMMON_UPDATE", "UPDATE_TMS_KAKAO_LOG");
		
		moduleConnectionInformation.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
		moduleConnectionInformation.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
		moduleConnectionInformation.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
		moduleConnectionInformation.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
		moduleConnectionInformation.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
		moduleConnectionInformation.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
		moduleConnectionInformation.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
		moduleConnectionInformation.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
	}
	
	public void init(boolean _useOthreDb) {
		
		useOthreDb = _useOthreDb;
		
		try {
			oriConnection = ConnectionPool.getConnection();
			
			if (useOthreDb) {
				moduleConnection = ConnectionPool.getConnection(moduleConnectionInformation);
				modulePsLog = moduleConnection.prepareStatement(queryUpdateLog, "${", "}");
			} else {
				modulePsLog = oriConnection.prepareStatement(queryUpdateLog, "${", "}");
			}
			
		} catch(Exception e) {
			log.error("ERROR init()... {}", e);
		}
	}
	
	public void update(Properties resultProp) throws Exception {
		try {
			
			oriConnection.setAutoCommit(false);
			
			if (moduleConnection != null) {
				moduleConnection.setAutoCommit(false);
			}
			
			resultProp.setProperty(CHECK_FLAG, OK);
			
			// 알림톡 성공이 아니고 SMS_TYPE이 존재하면 실패시 문자 전환 대상자이므로
			// 문자에 대한 결과를 업데이트 해줘야 함.
			if (!resultProp.getProperty("ERROR_CODE").equals("01")
					&& !resultProp.getProperty("SMS_TYPE","").equals("NO")) {
				resultProp.setProperty(CHECK_FLAG, ING_MSG);
			}
			
			String listTableName = resultProp.getProperty("LIST_TABLE","");
			if ("".equals(listTableName)) {
				log.debug("LIST_TABLE is null... update skip... {}", resultProp);
				return ;
			}
			
			// 업데이트 할 테이블 이름이 다를 수 있으므로
			queryUpdateSendList = ppsParseSQL(queryUpdateSendList, "LIST_TABLE", listTableName, "@{", "}");
			
			log.debug("Update Send List Query: {}", queryUpdateSendList);
			
			oriPsSendList = oriConnection.prepareStatement(queryUpdateSendList, "${", "}");
			
			oriPsSendList.executeUpdate(resultProp);
			modulePsLog.executeUpdate(resultProp);
			
		} catch(Exception e) {
			resultProp.setProperty(CHECK_FLAG, FAIL);
			
			try {
				modulePsLog.executeUpdate(resultProp);
			} catch(Exception ee) {
				try {
					oriConnection.rollback();
				} catch(Exception ee1) {}
				
				if (moduleConnection != null) {
					try {
						moduleConnection.rollback();
					} catch(Exception ee2) {}
				}
				throw ee;
			}
			log.error("ERROR update...", e);
			
			if (e instanceof SQLException) {
				throw e;
			}
		}
	}
	
	public void release() {
		if (oriPsSendList != null) {
			oriConnection.recycleStatement(oriPsSendList);
		}
		
		if (modulePsLog != null) {
			if (useOthreDb) {
				moduleConnection.recycleStatement(modulePsLog);
			} else {
				oriConnection.recycleStatement(modulePsLog);
			}
		}
		
		if (oriConnection != null) {
			try {
				oriConnection.commit();
				oriConnection.setAutoCommit(true);
			} catch(Exception ee) {}
			
			oriConnection.recycle();
		}
		
		if (moduleConnection != null) {
			try {
				moduleConnection.commit();
				moduleConnection.setAutoCommit(true);
			} catch(Exception ee) {}
			
			moduleConnection.recycle();
		}
	}
}
