package jupiter.mass.log.updator;

import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;



/**
 * @FileName  	: ExternalPushConnection.java
 * @Project     : TMS_1.0_DEV
 * @Date        : 2014. 7. 24. 
 * @Actor      	: pioneer
 * @modify 		:
 * @comment 	: 원격 DB Repository 접속 서비스
 */
public class ExternalConnectionFactory {
	
	private static ConnectInfo	TARGET_CONNECT_INFO					= null;
	private static String EX_NAME ;

	static {
		TARGET_CONNECT_INFO = new ConnectInfo();
		TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty(EX_NAME+".db.driver"));
		TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty(EX_NAME+".db.url"));
		TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty(EX_NAME+".db.id"));
		TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty(EX_NAME+".db.pass"));
		TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty(EX_NAME+".db.init"));
		TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty(EX_NAME+".db.base.charset"));
		TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty(EX_NAME+".db.out.charset"));
		TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty(EX_NAME+".db.in.charset"));
	}
	
	
	/**
	 * @MethodName : ExternalConnectionFactory
	 * @date    : 2014. 8. 18. 
	 * @actor   : pioneer
	 * @modify  : 
	 * @comment : 생성자에 파라메터가 없는 것은 생성 안되게 막아 놓음 / (exName 파라메터 반듯이 넣을 것) 
	 * @param 
	 * @return  
	 */
	private ExternalConnectionFactory(){}
	
	
	/**
	 * @MethodName : ExternalConnectionFactory
	 * @date    : 2014. 8. 18. 
	 * @actor   : pioneer
	 * @modify  : 
	 * @comment : 외부 DB 접속 정보 (eMsSystem.getProperty(EX_NAME + ".xx.xxx") )
	 * @param  exName : 접속 데이터 정보
	 */
	public ExternalConnectionFactory(String exName){
		EX_NAME = exName;
	}
	
	public eMsConnection getConnection() throws Exception{
		return ConnectionPool.getConnection(TARGET_CONNECT_INFO);
	}
	
	public void close(eMsConnection conn){
		conn.close();
	}
}

