package jupiter.mass.log.updator;

import java.sql.Statement;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;

@Slf4j
public class DefaultAddBatch implements AddBatch<TmsAddBatchInfo>{
	
	public void execute(TmsAddBatchInfo ab) throws Exception {
		int insertedCount = 0;
		int count 	= 0;
		int failCount = 0;
		eMsPreparedStatement ps = null;
		eMsConnection conn = null;
		AddBatchIterator rs = null;
		try {
			conn = ab.getConnection();
			conn.setAutoCommit(false);
			ps= ab.getConnection().prepareStatement(ab.getQuery(),"${","}");
			rs = ab.getAddBatchIterator();
			while(rs.next()){
				Properties p = new Properties();
				try {
					rs.putData(p);
					ps.addBatch(p);
				    if( count % ab.getCommitCount() == 0) {  
				    	insertedCount = insertedCount + batchResultCountValidation(ps.executeBatch()); 
				    }
				}catch (Exception e) {
					log.error("PushCampUpdator pushSendLogToTmsRepository", e);
					ab.setErrorInfo("count["+count+"] info["+p.toString()+"]");
					// e.printStackTrace();
				}
			    count++;
			}
			// 나머지를 한번 더 실행
			insertedCount = insertedCount + batchResultCountValidation(ps.executeBatch());
			failCount = count - insertedCount;
			conn.commit();
			conn.setAutoCommit(true);
		}catch(Exception e){
			ab.setErrorInfo("count["+count+"] info["+e.toString()+"]");
		}finally{
			try {
				if(rs != null) rs.close();
			} catch (Exception e2) {
			}
			try {
				if(ps != null) ps.close();
			} catch (Exception e2) {
			}
		}
		ab.setFailCount(failCount);
		ab.setSuccessCount(insertedCount);

		if(ab.isFinallyConnectionClose()) conn.close();
	}
	
	private static int batchResultCountValidation(int[] updates){
	    int tmpCnt = 0;
	    for(int i=0; i < updates.length; i++){
	        if( updates[i] == Statement.SUCCESS_NO_INFO ){         //처리는 되었으나 갱신건수를 알수 없을때 (-2)
	            tmpCnt = tmpCnt + 1;
	        }else if( updates[i] == Statement.EXECUTE_FAILED){     //처리안됨.
	        	log.error("Push Result Insert Fail Position["+i+"]");
	        	continue;
	        }else{
	            tmpCnt = tmpCnt + updates[i];
	        }
	    }
	    return tmpCnt;
	}
}
