package jupiter.mass.log.updator;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.db.eMsResultSet;

/**
 * @FileName  : AddBatchIteratorFactory.java
 * @Project   : TMS_1.0_DEV
 * @Date      : 2014. 8. 18. 
 * @actor     : pioneer
 * @modify    : 
 * @comment   : 그룹 데이터 Commit 서비스 -> 스프링 사용시 integration 사용 하면 쉽게 될텐데, 임시로 만듬.
 */
@Slf4j
public class AddBatchIteratorFactory {

	public Object 	iteratorData;
	private eMsResultSet rs;
	
	
	/**
	 * @MethodName : getInstance
	 * @date    : 2014. 8. 18. 
	 * @actor   : pioneer
	 * @modify  :
	 * @comment : 
	 * @param readData : Reading Data(resultSet , File Stream, Socket ,,)
	 * @return  : AddBatchIterator 익명 클래스 반환
	 */
	public static AddBatchIterator getInstance(final Object readData){
		try {
			if(readData instanceof eMsResultSet) 
				return new AddBatchIterator<eMsResultSet>(){
					eMsResultSet resultSet = (eMsResultSet)readData;

					public boolean next() throws Exception{
						return resultSet.next();
					}
					public eMsResultSet getIterator() {
						return resultSet;
					}
					public void close(){
						resultSet.close();
					}
					public void putData(Object o) throws Exception {
						resultSet.putToMap((Properties)o, false);
					}
				};
				
//TODO (pioneer) stream 이나 기타 추가 할 모듈은 알아서 넣을 것.		
				else return null;	
		} catch (Exception e) {
			log.error("batch Iterator error", e);
			return null;
		}
	}
	
	public AddBatchIteratorFactory(Object o){
		this.iteratorData = o;
		if(o instanceof eMsResultSet) this.rs = (eMsResultSet)o;
	}
	
	public boolean next() throws Exception{
		return rs.next();
	}
}
