package jupiter.mass.log.updator;

import java.util.ArrayList;


public class AddBatchInfo {
	
	private int readCount = 0;
	
	private int failCount = 0;
	
	private int successCount = 0; 
	
	private ArrayList<String> errorListInfo;
	
	private boolean errorCountFull = false;
	
	private final int commitCount ;
	
	private final String  query;
	
	private final boolean finallyConnectionClose;
	
	private AddBatchIterator addBatchIterator ;
	
	public AddBatchInfo(Object o, int commitCount, String query, boolean finallyConnectionClose){
		setAddbatchIterator(o);
		this.commitCount=commitCount;
		this.query = query;
		this.finallyConnectionClose = finallyConnectionClose;
	}
	
	public int getReadCount() {
		return readCount;
	}
	public void setReadCount(int readCount) {
		this.readCount = readCount;
	}
	public int getFailCount() {
		return failCount;
	}
	public void setFailCount(int failCount) {
		this.failCount = failCount;
	}
	public int getSuccessCount() {
		return successCount;
	}
	public void setSuccessCount(int successCount) {
		this.successCount = successCount;
	}
	
	public int getCommitCount() {
		return commitCount;
	}

	public String getQuery() {
		return query;
	}

	public boolean isFinallyConnectionClose() {
		return finallyConnectionClose;
	}

	public boolean isErrorFull(){
		return errorCountFull;
	}
	
	public void setErrorInfo(String error){
		if(errorListInfo.size() > 5000) errorCountFull = true;  //나중에 누가 옵션으로 바꿔라라라라..
		this.errorListInfo.add(error);
	}
	
	public ArrayList getErrorInfo(){
		return this.errorListInfo;
	}
	
	
	public void setAddbatchIterator(Object o){
		addBatchIterator = AddBatchIteratorFactory.getInstance(o);
	}
	
	public AddBatchIterator getAddBatchIterator(){
		return addBatchIterator;
	}
	
	@Override
	public String toString() {
		return "BatchInfo [readCount=" + readCount + ", failCount=" + failCount
				+ ", successCount=" + successCount + ", commitCount="
				+ commitCount + ", query=" + query
				+ ", finallyConnectionClose=" + finallyConnectionClose + "]";
	}

	
}
