/*
 * @(#)MassSendLogFilter.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.mass.log.filter;

import java.util.Properties;

import pluto.log.Log;
import pluto.log.LogFilter;

/**
 * <br>로그의 property들의 값을 변경한다. 
 * <br>Type이 54인 경우 Code를 00은 --로, 10은 00으로 
 * 
 * @version		
 * @author 		dragon
 *
 */
public class MassSendLogFilter implements LogFilter,Log {
	
	
	protected static Properties CODE_COLUMN_CONVERT = null;
	
	protected static String ERR_COL = null;
	
	public synchronized static void init( Object tmp ) throws Exception {
		
		Properties prop = ( Properties )tmp;
		
		ERR_COL = prop.getProperty( "TARGET_INFO_COLUMN_INDEX" );
		
		CODE_COLUMN_CONVERT=new Properties();
		
		CODE_COLUMN_CONVERT.putAll( prop );
	}
	
	/** Creates a new instance of MassSendLogFilter */
	public MassSendLogFilter() {
	}
	
	/** 필터링 룰을 지정한다.
	 * @param tmp 변환할 로그 데이터
	 * @throws Exception 변환에러
	 */
	public Object convert(Object target) throws Exception {
		
		Properties __LOG_DATA__ = ( Properties )target;
		
		String __LOG_T_DATE__ = __LOG_DATA__.getProperty( LOG_T_DATE );
		
		__LOG_DATA__.setProperty( LOG_T_DATE_YYYYMMDD , __LOG_T_DATE__.substring( 0 ,4 ) + __LOG_T_DATE__.substring( 5,7 ) + __LOG_T_DATE__.substring( 8,10 ) );
		
		String __T_TYPE__ = __LOG_DATA__.getProperty( LOG_T_TYPE );
		String __T_CODE__ = __LOG_DATA__.getProperty( LOG_T_CODE );
		
		
		String __SEND_TYPE__ = __LOG_DATA__.getProperty( LOG_SEND_TYPE );
		
		if(__SEND_TYPE__.equals("MASSRESEND")){
			String __MEMBER_ID__ = __LOG_DATA__.getProperty( LOG_MEMBER_ID );
			
			int __IDX_OF_SEP1__ = __MEMBER_ID__.lastIndexOf( "^" );		

			if( __IDX_OF_SEP1__ > 0 ){
				__LOG_DATA__.setProperty( LOG_MEMBER_ID , __MEMBER_ID__.substring( 0 , __IDX_OF_SEP1__ ) );
				
				__LOG_DATA__.setProperty( LOG_WORK_SEQ , __MEMBER_ID__.substring( __IDX_OF_SEP1__ + 1 ) );
			}		
		}

		if( __T_TYPE__.equals( "54" ) ) {
			if( __T_CODE__.equals("10") ) {
				__LOG_DATA__.setProperty( LOG_T_CODE , "00" );
			}
			else if( __T_CODE__.equals("00") ) {
				__LOG_DATA__.setProperty( LOG_T_CODE , "--" );
			}
			return __LOG_DATA__;
		}
		
		if( __T_TYPE__.equals( "55" ) && CODE_COLUMN_CONVERT != null ){
			__LOG_DATA__.setProperty( ERR_COL , CODE_COLUMN_CONVERT.getProperty( __T_CODE__ ) );
		}
		
		return __LOG_DATA__;
	}
	
	/** 필터링 룰을 지정한다.
	 * @param target 초기화 파라미터
	 * @throws Exception 초기화 에러
	 */
	public void setFilteringRules(Object target) throws Exception {
	}
	
}
